#coding: UTF-8

opts_list = ( ( u'一般',
    ( ( u'ネットワーク',
        ( { 'caption': 'enable-named-pipe',
            'description': u'名前付きパイプをサポートする。',
            'name': 'enable-named-pipe',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'port',
            'description': u'接続に使うポート番号。',
            'name': 'port',
            'values': ({ 'default': '3306', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-networking',
            'description': u"TCP/IPでの接続を禁止する",
            'name': 'skip-networking',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'ディレクトリ',
        ( { 'caption': 'datadir',
            'description': u'データベースルートへのパス',
            'name': 'datadir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'basedir',
            'description': u'インストールディレクトリへのパス',
            'name': 'basedir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'tmpdir',
            'description': u'作業用ファイルへのパス',
            'name': 'tmpdir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'メモリ',
        ( { 'caption': 'sort_buffer_size',
            'description': u'ソートする各スレッドはこの大きさのバッファを確保する',
            'name': 'sort_buffer_size',
            'values': ( { 'bitsize': '32',
                          'default': '2097144',
                          'maximum': '4294967295',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '2097144',
                          'maximum': '18446744073709547520',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},)),
      ( u'全体',
        ( { 'caption': 'init-file',
            'description': u'機動時にこのファイルからSQL文を読む',
            'name': 'init-file',
            'optype': { 'format': 'init-file=file_name'},
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'character-set-filesystem',
            'description': u'ファイルシステムの文字セット',
            'name': 'character-set-filesystem',
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 0, 19), (5, 1, 6)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'debug-sync-timeout',
            'description': u'デバッグSync同期ポイントのタイムアウト',
            'name': 'debug-sync-timeout',
            'values': ({ 'type': 'numeric'},),
            'versions': ( ((5, 1, 41), (6, 0, 6)),
                          ((5, 1), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'console',
            'description': u'エラーメッセージを画面に出力する。MS Windowsの場合はコンソールを利用',
            'name': 'console',
            'values': ( { 'off': '0',
                          'on': '1',
                          'platform': 'windows',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'verbose',
            'description': u'--help設定と兼用利用した場合は、詳細な説明を表示する',
            'name': 'verbose',
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'standalone',
            'description': u'MySQLサーバをサービスとして機動しない',
            'name': 'standalone',
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'collation-server',
            'description': u'デフォルト照合順序',
            'name': 'collation-server',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'partition',
            'description': u'パーティションサポートを有効／無効にする',
            'disabledby': 'skip-partition',
            'name': 'partition',
            'values': ( { 'default': 'on',
                          'off': 'disabledby',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'default-storage-engine',
            'description': u'テーブルのデフォルトストレージエンジン',
            'name': 'default-storage-engine',
            'values': ( { 'default': 'MyISAM',
                          'outversion': '5.5.4',
                          'type': 'dropdownbox'},
                        { 'default': 'InnoDB',
                          'inversion': '5.5.5',
                          'type': 'dropdownbox'},
                        { 'default': 'MyISAM',
                          'inversion': '6.0.0',
                          'type': 'dropdownbox'}),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'plugin-load',
            'description': u'機動時に読み込むプラグイン一覧',
            'name': 'plugin-load',
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 1, 18),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'lower_case_file_system',
            'description': u'OSが大文字小文字Jを識別するか',
            'name': 'lower_case_file_system',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'character-set-client-handshake',
            'description': u"ハンドシェーク中にクライアント側文字セットを無視しない",
            'name': 'character-set-client-handshake',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 15),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'character-sets-dir',
            'description': u'文字セットがあるディレクトリ',
            'name': 'character-sets-dir',
            'optype': { 'format': 'character-sets-dir=path'},
            'values': ({ 'type': 'dirname'},),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'default-table-type',
            'deprecated': (5, 0),
            'description': u'--default-storage-engineと同じです',
            'name': 'default-table-type',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)),
                          ((6, 0, 8),))},
          { 'caption': 'port-open-timeout',
            'description': u'ポートが開放されるまで待つ最大時間(デフォルト：待たない)',
            'name': 'port-open-timeout',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ( ((5, 0, 19), (5, 1, 5)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'old',
            'description': u'旧バージョン互換モードでサーバを起動する',
            'name': 'old',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( ((5, 1, 18),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'plugin_dir',
            'description': u'プラグイン用のディレクトリ',
            'name': 'plugin_dir',
            'values': ( { 'default': 'BASEDIR/lib/plugin',
                          'inversion': '5.1.2',
                          'platform': 'windows',
                          'type': 'dirname'},
                        { 'default': 'BASEDIR/lib/mysql/plugin',
                          'inversion': '5.1.2',
                          'platform': 'other',
                          'type': 'dirname'},
                        { 'default': 'BASEDIR/lib/plugin',
                          'inversion': '5.5.0',
                          'outversion': '5.5.4',
                          'platform': 'windows',
                          'type': 'dirname'},
                        { 'default': 'BASEDIR/lib/mysql/plugin',
                          'inversion': '5.5.0',
                          'outversion': '5.5.4',
                          'platform': 'other',
                          'type': 'dirname'},
                        { 'default': 'BASEDIR/lib/plugin',
                          'inversion': '5.5.5',
                          'type': 'dirname'}),
            'versions': ( ((4, 1, 25), (5, 0, 67), (5, 1, 2)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'character-set-server',
            'description': u'デフォルト文字設定',
            'name': 'character-set-server',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 3),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-character-set-client-handshake',
            'description': u'ハンドシェーク時にクライアント側の文字セットを無視する',
            'name': 'skip-character-set-client-handshake',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( ((4, 1, 15), (5, 0, 13)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})))),
  ( u'詳細',
    ( ( u'L10N',
        ( { 'caption': 'default-collation',
            'deprecated': (4, 1, 3),
            'description': u'デフォルト集合',
            'name': 'default-collation',
            'optype': { 'format': 'default-collation=name'},
            'values': ({ 'type': 'string'},),
            'versions': ((), ((4, 1),), ())},
          { 'caption': 'default-time-zone',
            'description': u'デフォルトタイムゾーン',
            'name': 'default-time-zone',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 3),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'language',
            'deprecated': (5, 5, 0),
            'description': u'クライアントに表示するエラーメッセージの言語。完全パスで指定することも可能',
            'name': 'language',
            'values': ( { 'default': '/usr/local/mysql/share/mysql/english/',
                          'type': 'dirname'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ())},
          { 'caption': 'default-character-set',
            'deprecated': (5, 0),
            'description': u'デフォルト文字セット',
            'name': 'default-character-set',
            'optype': { 'format': 'default-character-set=name'},
            'values': ({ 'type': 'string'},),
            'versions': (((4, 1, 3),), ((4, 1), (5, 0)), ())})),
      ( u'一般',
        ( { 'caption': 'open-files-limit',
            'description': u'0以外に設定された場合は、mysqldはsetrlimit()をファイルディスクリプタのその値を使います',
            'name': 'open-files-limit',
            'values': ( { 'default': '0',
                          'maximum': '65535',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sync_frm',
            'description': u'CREATEの場合は.frmをディスクに同期します',
            'name': 'sync_frm',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'old-alter-table',
            'description': u'最適化されていない旧alter tableを使う',
            'name': 'old-alter-table',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'skip-external-locking',
            'description': u'システム（外部）ロックをスキップする',
            'name': 'skip-external-locking',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'gdb',
            'description': u'デバッグ用のシグナルを設定',
            'name': 'gdb',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'flush',
            'description': u'SQL文間にテーブルをディスクにFLUSHする',
            'name': 'flush',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'memlock',
            'description': u'mysqldプロセスをメモリにロックする',
            'name': 'memlock',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'tc-heuristic-recover',
            'description': u'復旧プロセスに使う判断。設定可能な値はCOMMITとROLLBACK',
            'name': 'tc-heuristic-recover',
            'values': ( { 'choice': ['COMMIT', 'RECOVER'],
                          'type': 'dropdownbox'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'default_week_format',
            'description': u'WEEK()関数でデフォルトで使う週の形式',
            'name': 'default_week_format',
            'values': ( { 'default': '0',
                          'maximum': '7',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-safemalloc',
            'description': u"メモリ確保毎にメモリ領域範囲をチェックしない",
            'name': 'skip-safemalloc',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ((5, 5, 6),))},
          { 'caption': 'max_sp_recursion_depth',
            'description': u'ストアドプロシージャの最大の再起の負深さ',
            'name': 'max_sp_recursion_depth',
            'values': ( { 'default': '0',
                          'maximum': '255',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 17),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sysdate-is-now',
            'description': u'safe-replicableにするためのSYSDATE()からNOW()の非デフォルトのalias設定',
            'name': 'sysdate-is-now',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 20), (5, 1, 8)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'old-style-user-limits',
            'description': u'旧文法のユーザ制限（5.0.3より前は、リソースはユーザ＋ホスト（以降はアカウント数）で数えられた）',
            'name': 'old-style-user-limits',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'flush_time',
            'description': u'指定された期間毎にすべてのテーブルをFLUSHするために専用スレッドを作成する',
            'name': 'flush_time',
            'values': ( { 'default': '0',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '1800',
                          'minimum': '0',
                          'platform': 'windows',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'use-symbolic-links',
            'deprecated': (5, 0),
            'description': u'シンボリックリンクサポートを有効にする。非推奨。代わりに--symbolic-linksを使うことを推奨',
            'name': 'use-symbolic-links',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((5, 1), (5, 4), (6, 0)), ())},
          { 'caption': 'updatable_views_with_limit',
            'description': u'ビューがすべての主キーを含まない場合にビューを更新することができるか設定',
            'name': 'updatable_views_with_limit',
            'values': ( { 'default': '1',
                          'off': '0',
                          'on': '1',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 2),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-event-scheduler',
            'description': u'イベントスケジューラをOFF（無効）にする',
            'name': 'skip-event-scheduler',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'low-priority-updates',
            'description': u'INSERT/DELETE/UPDATEはSELECTより優先度が低い',
            'name': 'low-priority-updates',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_error_count',
            'description': u'文毎の最大のエラー／警告数',
            'name': 'max_error_count',
            'values': ( { 'default': '64',
                          'maximum': '65535',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_prepared_stmt_count',
            'description': u'サーバの最大プリペアードステートメント',
            'name': 'max_prepared_stmt_count',
            'optype': { 'inversion': '5.0.21'},
            'values': ( { 'default': '16382',
                          'maximum': '1048576',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 19), (5, 0, 21), (5, 1, 10)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'enable-pstack',
            'deprecated': (5, 1, 54),
            'description': u'失敗した場合はシンボリックスタックを出力する',
            'name': 'enable-pstack',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ((5, 5, 7),))},
          { 'caption': 'skip-stack-trace',
            'description': u"失敗した場合でもスタックトレースを出力しない",
            'name': 'skip-stack-trace',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Thread specific settings',
        ( { 'caption': 'slow_launch_time',
            'description': u'指定した値よりスレッドを作成するのに時間が掛かった場合は、Slow_launch_threadsカウンタを増やす',
            'name': 'slow_launch_time',
            'values': ({ 'default': '2', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'thread_concurrency',
            'description': u'アプリケーションから同時に実行するスレッド数の推奨を受け取れるようにする',
            'name': 'thread_concurrency',
            'values': ( { 'default': '10',
                          'maximum': '512',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'thread_handling',
            'description': u'thread-handlingモデル',
            'name': 'thread_handling',
            'values': ( { 'choice': [ 'no-threads',
                                      'one-thread-per-connection'],
                          'outversion': '6.0.3',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'no-threads',
                                      'one-thread-per-connection',
                                      'pool-of-threads'],
                          'inversion': '6.0.4',
                          'type': 'dropdownbox'}),
            'versions': ( ((5, 1, 17),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'skip-thread-priority',
            'deprecated': (5, 1, 29),
            'description': u"スレッドに異なる優先度を与えない",
            'name': 'skip-thread-priority',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'thread_pool_size',
            'description': u'スレッドプールの大きさ',
            'name': 'thread_pool_size',
            'values': ( { 'default': '20',
                          'maximum': '16384',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': (((6, 0, 4),), ((6, 0),), ((6, 0, 14),))},
          { 'caption': 'thread_stack',
            'description': u'各スレッドのスタックサイズ',
            'name': 'thread_stack',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '196608',
                          'maximum': '4294967295',
                          'minimum': '131072',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '262144',
                          'maximum': '18446744073709547520',
                          'minimum': '131072',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'one-thread',
            'description': u'スレッドを１つのみ使う（Linux上でデバッグする場合に利用）',
            'name': 'one-thread',
            'values': (),
            'versions': ( (),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'thread_cache_size',
            'description': u'再利用のためにキャッシュに残すスレッド数',
            'name': 'thread_cache_size',
            'values': ( { 'default': '0',
                          'maximum': '16384',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Insert delayed settings',
        ( { 'caption': 'delayed_insert_timeout',
            'description': u'INSERT DELAYEDスレッドがINSERT文を停止するまでに待つ秒',
            'name': 'delayed_insert_timeout',
            'values': ({ 'default': '300', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'delayed_queue_size',
            'description': u'INSERT DELAYEDに割り当てるキューの大きさ（行数）',
            'name': 'delayed_queue_size',
            'values': ( { 'bitsize': '32',
                          'default': '1000',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1000',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'delayed_insert_limit',
            'description': u'delayed_insert_limitを挿入した後は、INSERT DELAYEDハンドラーは処理されていないSELECT文があるか確認します。ある場合は、継続する前にそれらを実行します',
            'name': 'delayed_insert_limit',
            'values': ( { 'bitsize': '32',
                          'default': '100',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '100',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_delayed_threads',
            'description': u"INSERT DELAYED文を処理する最大のスレッド数。0に設定した場合はINSERT DELAYEDは利用されません",
            'name': 'max_delayed_threads',
            'values': ( { 'default': '20',
                          'maximum': '16384',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Various',
        ( { 'caption': 'tmp_table_size',
            'description': u'in-memory作業用テーブルが指定された値よりも大きくなった場合は、MySQLはディスク上のMyISAMテーブルを利用します',
            'name': 'tmp_table_size',
            'values': ( { 'default': 'system dependent',
                          'maximum': '4294967295',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'lower_case_table_names',
            'description': u'1の場合はテーブル名はディスクに小文字で作成されます。ファイルシステムが小文字大文字を区別しない場合は2に設定してください',
            'name': 'lower_case_table_names',
            'values': ( { 'default': '0',
                          'maximum': '2',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'transaction-isolation',
            'description': u'デフォルトトランザクションアイソレーションレベル',
            'name': 'transaction-isolation',
            'values': ( { 'choice': [ 'READ-UNCOMMITTED',
                                      'READ-COMMITTED',
                                      'REPEATABLE-READ',
                                      'SERIALIZABLE'],
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'temp-pool',
            'description': u'この項目を設定すると、多くの作業用ファイルはファイト毎に新しい名前では無く、限られた名前を利用します。',
            'name': 'temp-pool',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_length_for_sort_data',
            'description': u'ソートされたレコードの最大バイト数',
            'name': 'max_length_for_sort_data',
            'values': ( { 'default': '1024',
                          'maximum': '8388608',
                          'minimum': '4',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'symbolic-links',
            'description': u'シンボリックリンクを利用',
            'disabledby': 'skip-symbolic-links',
            'name': 'symbolic-links',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_prealloc_size',
            'description': u'クエリー解析と実行用の永続バッファ',
            'name': 'query_prealloc_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '4294967295',
                          'minimum': '8192',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '18446744073709547520',
                          'minimum': '8192',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_binlog_stmt_cache_size',
            'description': u'トランザクション中の非トランザクション文の総合キャッシュの大きさを制限する',
            'name': 'max_binlog_stmt_cache_size',
            'values': ( { 'default': '18446744073709547520',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'},),
            'versions': (((5, 5, 9), (5, 6, 1)), ((5, 5), (5, 6)), ())},
          { 'caption': 'big-tables',
            'description': u'すべての作業用セットをファイルに書出し、大きな結果セットを許可する',
            'name': 'big-tables',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_write_lock_count',
            'description': u'指定された書込みロック数後に読込みロックの実行を許可する',
            'name': 'max_write_lock_count',
            'values': ( { 'bitsize': '32',
                          'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '18446744073709547520',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'bind-address',
            'description': u'バインドするIPアドレス又はホスト名',
            'name': 'bind-address',
            'optype': { 'format': 'bind-address=name'},
            'values': ( { 'default': '0.0.0.0',
                          'maximum': '255.255.255.255',
                          'minimum': '0.0.0.0',
                          'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-merge',
            'description': u'Mergeストレージエンジンを無効にする',
            'name': 'skip-merge',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( ((5, 0, 24), (5, 1, 12)),
                          ((5, 0), (5, 1)),
                          ((5, 1, 14),))},
          { 'caption': 'max_join_size',
            'description': u'max_join_sizeより多くレコードを読む可能性があるJOINはエラーとする',
            'name': 'max_join_size',
            'values': ( { 'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '18446744073709551615',
                          'inversion': '5.5.0',
                          'maximum': '18446744073709551615',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'group_concat_max_len',
            'description': u'group_concat関数結果の最大長',
            'name': 'group_concat_max_len',
            'values': ( { 'bitsize': '32',
                          'default': '1024',
                          'maximum': '4294967295',
                          'minimum': '4',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1024',
                          'maximum': '18446744073709547520',
                          'minimum': '4',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 10),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_seeks_for_key',
            'description': u'キーによる行を検索するのに必要なシークの予想回数を制限する',
            'name': 'max_seeks_for_key',
            'values': ( { 'bitsize': '32',
                          'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '18446744073709547520',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'delay-key-write',
            'description': u'DELAY_KEY_WRITEのタイプ',
            'name': 'delay-key-write',
            'values': ( { 'choice': ['ON', 'OFF', 'ALL'],
                          'default': 'ON',
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'back_log',
            'description': u'MySQLがリクエスト可能なアウトスタンディング接続数',
            'name': 'back_log',
            'values': ( { 'default': '50',
                          'maximum': '65535',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog_cache_size',
            'description': u'トランザクション中にバイナリログ用のSQL文を保管するキャッシュの大きさ',
            'name': 'binlog_cache_size',
            'values': ( { 'bitsize': '32',
                          'default': '32768',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '32768',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sql-mode',
            'description': u'SQLサーバモード',
            'name': 'sql-mode',
            'values': ( { 'choice': [ 'ALLOW_INVALID_DATES',
                                      'ANSI_QUOTES',
                                      'ERROR_FOR_DIVISION_BY_ZERO',
                                      'HIGH_NOT_PRECEDENCE',
                                      'IGNORE_SPACE',
                                      'NO_AUTO_CREATE_USER',
                                      'NO_AUTO_VALUE_ON_ZERO',
                                      'NO_BACKSLASH_ESCAPES',
                                      'NO_DIR_IN_CREATE',
                                      'NO_ENGINE_SUBSTITUTION',
                                      'NO_FIELD_OPTIONS',
                                      'NO_KEY_OPTIONS',
                                      'NO_TABLE_OPTIONS',
                                      'NO_UNSIGNED_SUBTRACTION',
                                      'NO_ZERO_DATE',
                                      'NO_ZERO_IN_DATE',
                                      'ONLY_FULL_GROUP_BY',
                                      'PAD_CHAR_TO_FULL_LENGTH',
                                      'PIPES_AS_CONCAT',
                                      'REAL_AS_FLOAT',
                                      'STRICT_ALL_TABLES',
                                      'STRICT_TRANS_TABLES'],
                          'default': "''",
                          'type': 'set'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-new',
            'description': u"新しい、間違いがある可能性のあるルーチンは使わない",
            'name': 'skip-new',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-partition',
            'description': u'ユーザ定義パーティション設定は有効にしない',
            'name': 'skip-partition',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'key_cache_block_size',
            'description': u'キーキャッシュブロックのデフォルトサイズ',
            'name': 'key_cache_block_size',
            'values': ( { 'default': '1024',
                          'maximum': '16384',
                          'minimum': '512',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'core-file',
            'description': u'エラーの場合はコアも書き出す',
            'name': 'core-file',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-sync-bdb-logs',
            'deprecated': None,
            'description': u'同期DBDログフラッシュを無効にする',
            'name': 'skip-sync-bdb-logs',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'merge',
            'description': u'Mergeストレージエンジンを有効にする',
            'disabledby': 'skip-merge',
            'name': 'merge',
            'values': ( { 'default': 'true',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 21), (5, 0, 24), (5, 1, 12)),
                          ((4, 1), (5, 0), (5, 1)),
                          ((5, 1, 14),))},
          { 'caption': 'preload_buffer_size',
            'description': u'索引をプリロードするために割当てるバッファの大きさ',
            'name': 'preload_buffer_size',
            'values': ( { 'default': '32768',
                          'maximum': '1073741824',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'transaction_alloc_block_size',
            'description': u'バイナリログに保存するトランザクション用に割当てるブロックサイズ',
            'name': 'transaction_alloc_block_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '4294967295',
                          'minimum': '1024',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '18446744073709547520',
                          'minimum': '1024',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'join_buffer_size',
            'description': u'full joinに使うバッファの大きさ',
            'name': 'join_buffer_size',
            'values': ( { 'bitsize': '32',
                          'default': '131072',
                          'maximum': '4294967295',
                          'minimum': '8200',
                          'outversion': '6.0.8',
                          'type': 'numeric'},
                        { 'bitsize': '32',
                          'default': '131072',
                          'inversion': '6.0.9',
                          'maximum': '4294967295',
                          'minimum': '128',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '131072',
                          'maximum': '18446744073709547520',
                          'minimum': '8200',
                          'outversion': '6.0.8',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '131072',
                          'inversion': '6.0.9',
                          'maximum': '18446744073709547520',
                          'minimum': '128',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog_stmt_cache_size',
            'description': u'トランザクション中にバイナリログ用に保管する非トランザクション文用のキャッシュの大きさ',
            'name': 'binlog_stmt_cache_size',
            'values': ( { 'bitsize': '32',
                          'default': '32768',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '32768',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'}),
            'versions': (((5, 5, 9), (5, 6, 1)), ((5, 5), (5, 6)), ())},
          { 'caption': 'table_cache',
            'deprecated': (5, 1, 3),
            'description': u'すべてのスレッド用に開いているテーブルの数',
            'name': 'table_cache',
            'values': ( { 'default': '64',
                          'maximum': '524288',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ((5, 1, 3),))},
          { 'caption': 'read_rnd_buffer_size',
            'description': u'ソートした後にソート順に行を読む場合は、ディスクシークを省くために代わりにこのバッファから読まれる。設定されていない場合はrecord_bufferの値が利用される.',
            'name': 'read_rnd_buffer_size',
            'values': ( { 'default': '262144',
                          'maximum': '4294967295',
                          'minimum': '8200',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_heap_table_size',
            'description': u"設定した値より大きなヒープテーブルの作成を禁止する",
            'name': 'max_heap_table_size',
            'values': ( { 'bitsize': '32',
                          'default': '16777216',
                          'maximum': '4294967295',
                          'minimum': '16384',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '16777216',
                          'maximum': '1844674407370954752',
                          'minimum': '16384',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-bdb',
            'description': u'Berkeley DBを無効にする（MySQLのバージョンが対応している場合）',
            'name': 'skip-bdb',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'chroot',
            'description': u'起動時のChroot mysqldデーモン',
            'name': 'chroot',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'key_cache_division_limit',
            'description': u'キーキャッシュのウォームブロックの最低パーセント',
            'name': 'key_cache_division_limit',
            'values': ( { 'default': '100',
                          'maximum': '100',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_binlog_cache_size',
            'description': u'マルチ文トランザクションのキャッシュの総合サイズを制限する',
            'name': 'max_binlog_cache_size',
            'values': ( { 'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'outversion': '5.1.35',
                          'type': 'numeric'},
                        { 'default': '18446744073709547520',
                          'inversion': '5.1.36',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'},
                        { 'default': '4294967295',
                          'inversion': '5.4.0',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '18446744073709547520',
                          'inversion': '5.4.2',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'},
                        { 'default': '4294967295',
                          'inversion': '6.0.0',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-symlink',
            'description': u"テーブルのsymlinkを禁止する。非推奨。代わりに--skip-symbolic-linksの利用を推奨",
            'name': 'skip-symlink',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'new',
            'description': u"新しい関数。「安全」ではない",
            'disabledby': 'skip-new',
            'name': 'new',
            'values': ( { 'default': 'false',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_sort_length',
            'description': u'BLOB及びTEXTの値をソートする場合に使うバイト数',
            'name': 'max_sort_length',
            'values': ( { 'default': '1024',
                          'maximum': '8388608',
                          'minimum': '4',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-isam',
            'deprecated': None,
            'description': u'ISAMストレージエンジンを無効にする',
            'name': 'skip-isam',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': (((4, 1, 1),), ((4, 1),), ())},
          { 'caption': 'ansi',
            'description': u'MySQL文法の代わりにANSI SQL文法を使う',
            'name': 'ansi',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'read_buffer_size',
            'description': u'シーケンシャルスキャンするスレッド毎にスキャンするテーブル毎に指定した大きさのバッファが割当てられる。',
            'name': 'read_buffer_size',
            'values': ( { 'default': '131072',
                          'maximum': '2147479552',
                          'minimum': '8200',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'user',
            'description': u'mysqldデーモンをユーザとして実行',
            'name': 'user',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'range_alloc_block_size',
            'description': u'最適化中に確保する範囲を保存するためのブロックサイズ',
            'name': 'range_alloc_block_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '2048',
                          'maximum': '4294967295',
                          'minimum': '2048',
                          'type': 'numeric'},
                        { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '4096',
                          'inversion': '5.0.54',
                          'maximum': '4294967295',
                          'minimum': '4096',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '2048',
                          'maximum': '18446744073709547520',
                          'minimum': '2048',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '4096',
                          'inversion': '5.0.54',
                          'maximum': '18446744073709547520',
                          'minimum': '4096',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'pid-file',
            'description': u'mysqld_safeで使うプロセスID',
            'name': 'pid-file',
            'optype': { 'format': 'pid-file=file_name'},
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_alloc_block_size',
            'description': u'クエリー解析と実行のブロックサイズ',
            'name': 'query_alloc_block_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '4294967295',
                          'minimum': '1024',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '8192',
                          'maximum': '18446744073709547520',
                          'minimum': '1024',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'bulk_insert_buffer_size',
            'description': u'バッチINSERTの最適化で使うツリーキャッシュの大きさ',
            'name': 'bulk_insert_buffer_size',
            'values': ( { 'bitsize': '32',
                          'default': '8388608',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '8388608',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_tmp_tables',
            'description': u'クライアントが同時に開ける作業用テーブルの最大数',
            'name': 'max_tmp_tables',
            'values': ( { 'bitsize': '32',
                          'default': '32',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '32',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'transaction_prealloc_size',
            'description': u'バイナリログに保存するトランザクション用の永続バッファ',
            'name': 'transaction_prealloc_size',
            'values': ( { 'bitsize': '32',
                          'blocksize': '1024',
                          'default': '4096',
                          'maximum': '4294967295',
                          'minimum': '1024',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'blocksize': '1024',
                          'default': '4096',
                          'maximum': '18446744073709547520',
                          'minimum': '1024',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog_direct_non_transactional_updates',
            'description': u'非トランザクションエンジンへのステートメント形式のUPDATEを直接バイナリログに書き出す。利用する前に簿球面とを参照してください',
            'name': 'binlog_direct_non_transactional_updates',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 44), (5, 5, 2), (6, 0, 14)),
                          ((5, 1), (5, 5), (5, 6), (6, 0)),
                          ())})))),
  ( 'MyISAM',
    ( ( u'一般',
        ( { 'caption': 'concurrent_insert',
            'description': u'MyISAMでの平行insertを使う',
            'disabledby': 'skip-concurrent-insert',
            'name': 'concurrent_insert',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'outversion': '5.0.5',
                          'type': 'boolean'},
                        { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'inversion': '5.0.6',
                          'outversion': '5.5.2',
                          'type': 'numeric'},
                        { 'choice': [ 'NEVER',
                                      'AUTO',
                                      'ALWAYS',
                                      '0',
                                      '1',
                                      '2'],
                          'default': 'AUTO',
                          'inversion': '5.5.3',
                          'type': 'dropdownbox'},
                        { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'inversion': '6.0.0',
                          'outversion': '6.0.14',
                          'type': 'numeric'},
                        { 'choice': [ 'NEVER',
                                      'AUTO',
                                      'ALWAYS',
                                      '0',
                                      '1',
                                      '2'],
                          'default': 'AUTO',
                          'inversion': '6.0.14',
                          'type': 'dropdownbox'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'keep_files_on_create',
            'description': u'デフォルトデータベースディレクトリの.MYD/.MYIを上書きしない',
            'name': 'keep_files_on_create',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 48), (5, 1, 21)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'key_buffer_size',
            'description': u'MyISAMテーブルの索引ブロックで利用するバッファの大きさ',
            'name': 'key_buffer_size',
            'values': ( { 'default': '8388608',
                          'maximum': '4294967295',
                          'minimum': '8',
                          'outversion': '5.1.22',
                          'type': 'numeric'},
                        { 'bitsize': '32',
                          'default': '8388608',
                          'inversion': '5.1.23',
                          'maximum': '4294967295',
                          'minimum': '8',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '8388608',
                          'inversion': '5.1.23',
                          'maximum': 'OS_PER_PROCESS_LIMIT',
                          'minimum': '8',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-locking',
            'deprecated': None,
            'description': u'非推奨',
            'name': 'skip-locking',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'key_cache_age_threshold',
            'description': u'ホットブロックがウォームブロックにダウングレードされるまで利用されないヒット数。ヒット数とキーキャッシュの合計ブロック数の比率を指定します。',
            'name': 'key_cache_age_threshold',
            'values': ( { 'bitsize': '32',
                          'default': '300',
                          'maximum': '4294967295',
                          'minimum': '100',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '300',
                          'maximum': '18446744073709547520',
                          'minimum': '100',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'external-locking',
            'description': u'システム（外部）ロックを利用',
            'disabledby': 'skip-external-locking',
            'name': 'external-locking',
            'values': ( { 'default': 'false',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'全文検索',
        ( { 'caption': 'ft_min_word_len',
            'description': u'FULLTEXT索引に含む単語の最短長。注：この設定を変更した後は、FULLTEXT索引を再構築する必要があります',
            'name': 'ft_min_word_len',
            'values': ( { 'default': '4',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ft_boolean_syntax',
            'description': u'MATCH ... AGAINST ( ... IN BOOLEAN MODE)オペレータの一覧',
            'name': 'ft_boolean_syntax',
            'values': ({ 'default': '+-><()~*:""&', 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ft_max_word_len',
            'description': u'FULLTEXT索引に含める単語の最大の長さ。注：値を変更した後はFULLTEXT索引を再構築してください。',
            'name': 'ft_max_word_len',
            'values': ({ 'minimum': '10', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ft_stopword_file',
            'description': u'ビルドイン一覧の代わりにストップワードにこの一覧を利用',
            'name': 'ft_stopword_file',
            'optype': { 'format': 'ft_stopword_file=file_name'},
            'values': ({ 'type': 'filename'},),
            'versions': ( ((4, 1, 10),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ft_query_expansion_limit',
            'description': u'クエリーの展開に使う最適な一致する数',
            'name': 'ft_query_expansion_limit',
            'values': ( { 'default': '20',
                          'maximum': '1000',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Advanced Settings',
        ( { 'caption': 'skip-concurrent-insert',
            'description': u'MyISAMテーブルに同時にSELECTとINSERTできないようにする',
            'name': 'skip-concurrent-insert',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam-recover-options',
            'description': u'自動MyISAMリカバリする場合はこモードを設定',
            'name': 'myisam-recover-options',
            'values': ( { 'choice': [ 'OFF',
                                      'DEFAULT',
                                      'BACKUP',
                                      'FORCE',
                                      'QUICK'],
                          'default': 'OFF',
                          'type': 'dropdownbox'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'myisam_sort_buffer_size',
            'description': u'CREATE INDEX又はALTER TABLEで索引を作成又はREPAIRで索引のソートに使われるバッファ',
            'name': 'myisam_sort_buffer_size',
            'values': ( { 'bitsize': '32',
                          'default': '8388608',
                          'maximum': '4294967295',
                          'minimum': '4',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '8388608',
                          'maximum': '18446744073709547520',
                          'minimum': '4',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_max_extra_sort_file_size',
            'deprecated': (5, 0, 6),
            'description': u'非推奨の設定',
            'name': 'myisam_max_extra_sort_file_size',
            'optype': { 'outversion': '5.0.6'},
            'values': ( { 'default': '2147483648',
                          'outversion': '5.0.6',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'myisam_use_mmap',
            'description': u'MyISAMテーブルの読み書きにはメモリマップを利用',
            'name': 'myisam_use_mmap',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 4),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'myisam_stats_method',
            'description': u'MyISAM索引統計コレクションがNULLをどのように扱うか指定',
            'name': 'myisam_stats_method',
            'values': ( { 'default': 'nulls_unequal',
                          'inversion': '4.1',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'nulls_equal',
                                      'nulls_unequal',
                                      'nulls_ignored'],
                          'inversion': '5.0',
                          'type': 'dropdownbox'}),
            'versions': ( ((4, 1, 15), (5, 0, 14)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam-recover',
            'description': u'自動MyISAMリカバリモードを設定',
            'name': 'myisam-recover',
            'values': ( { 'choice': [ 'DEFAULT',
                                      'BACKUP',
                                      'FORCE',
                                      'QUICK'],
                          'default': 'OFF',
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ((5, 5, 3), (6, 0, 14)))},
          { 'caption': 'myisam-block-size',
            'description': u'MyISAM索引ページのブロックサイズ',
            'name': 'myisam-block-size',
            'values': ( { 'default': '1024',
                          'maximum': '16384',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_max_sort_file_size',
            'description': u"指定した値より作業ファイルが大きくなる場合はファーストソート索引メソッドを使わない",
            'name': 'myisam_max_sort_file_size',
            'values': ({ 'default': '2147483648', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_data_pointer_size',
            'description': u'MyISAMテーブルで利用するデフォルトポイントの大きさ',
            'name': 'myisam_data_pointer_size',
            'values': ( { 'default': '4',
                          'maximum': '8',
                          'minimum': '2',
                          'outversion': '5.0.5',
                          'type': 'numeric'},
                        { 'default': '6',
                          'inversion': '5.0.6',
                          'maximum': '7',
                          'minimum': '2',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_repair_threads',
            'description': u'MyISAMテーブルを修復するのに使うスレッド数。1に設定した場合は並列修復は無効',
            'name': 'myisam_repair_threads',
            'values': ( { 'bitsize': '32',
                          'default': '1',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'myisam_mmap_size',
            'description': u'圧縮MyISAMファイルをメモリマップに使う災害のメモる容量',
            'name': 'myisam_mmap_size',
            'values': ( { 'bitsize': '32',
                          'default': '4294967295',
                          'maximum': '4294967295',
                          'minimum': '7',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '18446744073709547520',
                          'maximum': '18446744073709547520',
                          'minimum': '7',
                          'type': 'numeric'}),
            'versions': ( ( (5, 0, 90),
                            (5, 1, 43),
                            (5, 5, 1),
                            (6, 0, 14)),
                          ((5, 0), (5, 1), (5, 5), (5, 6), (6, 0)),
                          ())})))),
  ( u'性能',
    ( ( u'一般',
        ( { 'caption': 'safe-mode',
            'deprecated': (5, 0),
            'description': u'最適化ステージをスキップ（テスト用）',
            'name': 'safe-mode',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'table_open_cache',
            'description': u'すべてのスレッドで開いているテーブル数',
            'name': 'table_open_cache',
            'values': ( { 'default': '64',
                          'maximum': '524288',
                          'minimum': '64',
                          'type': 'numeric'},
                        { 'default': '400',
                          'inversion': '5.4.0',
                          'maximum': '524288',
                          'minimum': '64',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '400',
                          'inversion': '5.4.2',
                          'maximum': '524288',
                          'minimum': '400',
                          'type': 'numeric'},
                        { 'default': '64',
                          'inversion': '6.0.0',
                          'maximum': '524288',
                          'minimum': '64',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 3),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'table_definition_cache',
            'description': u'定義キャッシュに保存できるテーブル定義数',
            'name': 'table_definition_cache',
            'values': ( { 'default': '128',
                          'maximum': '524288',
                          'minimum': '1',
                          'outversion': '5.1.24',
                          'type': 'numeric'},
                        { 'default': '256',
                          'inversion': '5.1.25',
                          'maximum': '524288',
                          'minimum': '256',
                          'type': 'numeric'},
                        { 'default': '400',
                          'inversion': '5.4.0',
                          'maximum': '524288',
                          'minimum': '400',
                          'type': 'numeric'},
                        { 'default': '128',
                          'inversion': '6.0.0',
                          'maximum': '524288',
                          'minimum': '1',
                          'outversion': '6.0.5',
                          'type': 'numeric'},
                        { 'default': '256',
                          'inversion': '6.0.6',
                          'maximum': '524288',
                          'minimum': '256',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 3),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())})),
      ( u'クエリーキャッシュ',
        ( { 'caption': 'query_cache_size',
            'description': u'古いクエリー結果を保管するのに確保するメモリ',
            'name': 'query_cache_size',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_cache_wlock_invalidate',
            'description': u'書き込みLOCKのクエリーキャッシュ内をクエリーを不正にする',
            'name': 'query_cache_wlock_invalidate',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_cache_min_res_unit',
            'description': u'結果用の領域を確保する最小の大きさの単位（最後の単位は結果データすべてを書き終わった後にトリムされます）',
            'name': 'query_cache_min_res_unit',
            'values': ( { 'bitsize': '32',
                          'default': '4096',
                          'maximum': '4294967295',
                          'minimum': '512',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '4096',
                          'maximum': '18446744073709547520',
                          'minimum': '512',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-same-server-id',
            'description': u'レプリケーションの場合、1に設定した場合は、このサーバidのイベントはスキップしない',
            'name': 'replicate-same-server-id',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_cache_limit',
            'description': u"これより大きな結果はキャッシュしない",
            'name': 'query_cache_limit',
            'values': ( { 'bitsize': '32',
                          'default': '1048576',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1048576',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'query_cache_type',
            'description': u'クエリーキャッシュタイプ',
            'name': 'query_cache_type',
            'values': ( { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'最適化',
        ( { 'caption': 'optimizer_switch',
            'description': u'どの最適化を利用するかの制御を有効にする',
            'name': 'optimizer_switch',
            'optype': { 'inversion': '5.1.34'},
            'values': ( { 'choice': [ 'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}'],
                          'outversion': '5.2.3',
                          'type': 'set'},
                        { 'choice': [ 'no_semijoin',
                                      'no_materialization'],
                          'default': "''",
                          'inversion': '5.2.4',
                          'type': 'set'},
                        { 'choice': [ 'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}'],
                          'inversion': '5.4.2',
                          'outversion': '5.5.2',
                          'type': 'set'},
                        { 'choice': [ 'engine_condition_pushdown={on|off}',
                                      'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}'],
                          'inversion': '5.5.3',
                          'type': 'set'},
                        { 'choice': [ 'no_firstmatch',
                                      'no_loosescan',
                                      'no_materialization',
                                      'no_semijoin'],
                          'default': "''",
                          'inversion': '6.0.0',
                          'outversion': '6.0.10',
                          'type': 'set'},
                        { 'choice': [ 'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}',
                                      'semijoin={on|off}',
                                      'firstmatch={on|off}',
                                      'loosescan={on|off}',
                                      'materialization={on|off}'],
                          'inversion': '6.0.11',
                          'outversion': '6.0.13',
                          'type': 'set'},
                        { 'choice': [ 'index_merge={on|off}',
                                      'index_merge_intersection={on|off}',
                                      'index_merge_sort_union={on|off}',
                                      'index_merge_union={on|off}',
                                      'semijoin={on|off}',
                                      'firstmatch={on|off}',
                                      'loosescan={on|off}',
                                      'materialization={on|off}',
                                      'engine_condition_pushdown={on|off}',
                                      'index_condition_pushdown={on|off}',
                                      'mrr={on|off}',
                                      'mrr_cost_based={on|off}'],
                          'inversion': '6.0.14',
                          'type': 'set'}),
            'versions': ( ((5, 1, 34), (5, 2, 4), (5, 4, 2)),
                          ( (5, 1),
                            (5, 2),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'optimizer_prune_level',
            'description': u'検索の最適化用の空間から有力でないプランを削除する方法を制御する',
            'name': 'optimizer_prune_level',
            'values': ( { 'default': '1',
                          'off': '0',
                          'on': '1',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 1),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'optimizer_search_depth',
            'description': u'クエリー最適化の検索の最大深さ',
            'name': 'optimizer_search_depth',
            'values': ( { 'default': '62', 'type': 'numeric'},
                        { 'default': '62',
                          'maximum': '63',
                          'minimum': '0',
                          'outversion': '5.5.99',
                          'type': 'numeric'},
                        { 'default': '62',
                          'inversion': '5.6',
                          'maximum': '62',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '62',
                          'inversion': '6.0.0',
                          'maximum': '63',
                          'minimum': '0',
                          'outversion': '6.0.13',
                          'type': 'numeric'},
                        { 'default': '62',
                          'inversion': '6.0.14',
                          'maximum': '62',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((5, 0, 1),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'Performanceスキーマ',
        ( { 'caption': 'performance_schema_max_thread_instances',
            'description': u'スレッドオブジェクトの最大数',
            'name': 'performance_schema_max_thread_instances',
            'optype': { 'format': 'performance_schema_max_thread_instances=#'},
            'values': ({ 'default': '1000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_file_classes',
            'description': u'ファイルの最大数',
            'name': 'performance_schema_max_file_classes',
            'optype': { 'format': 'performance_schema_max_file_classes=#'},
            'values': ({ 'default': '50', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema',
            'description': u'パフォーマンススキーマを有効にするか',
            'name': 'performance_schema',
            'optype': { 'format': 'performance_schema=#'},
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_setup_objects_size',
            'description': u'setup_objectsの行数',
            'name': 'performance_schema_setup_objects_size',
            'optype': { 'format': 'performance_schema_setup_objects_size=#'},
            'values': ({ 'default': '100', 'type': 'numeric'},),
            'versions': (((5, 6, 1),), ((5, 6),), ())},
          { 'caption': 'performance_schema_max_file_instances',
            'description': u'ファイルオブジェクトの最大数',
            'name': 'performance_schema_max_file_instances',
            'optype': { 'format': 'performance_schema_max_file_instances=#'},
            'values': ({ 'default': '10000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_file_handles',
            'description': u'開かれたファイルオブジェクトの最大数',
            'name': 'performance_schema_max_file_handles',
            'optype': { 'format': 'performance_schema_max_file_handles=#'},
            'values': ({ 'default': '32768', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_setup_actors_size',
            'description': u'setup_actorsの行数',
            'name': 'performance_schema_setup_actors_size',
            'optype': { 'format': 'performance_schema_setup_actors_size=#'},
            'values': ({ 'default': '100', 'type': 'numeric'},),
            'versions': (((5, 6, 1),), ((5, 6),), ())},
          { 'caption': 'performance_schema_events_waits_history_size',
            'description': u'events_waits_historyの行数',
            'name': 'performance_schema_events_waits_history_size',
            'optype': { 'format': 'performance_schema_events_waits_history_size=#'},
            'values': ({ 'default': '10', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_table_handles',
            'description': u'T開かれたテーブルオブジェクトの最大数',
            'name': 'performance_schema_max_table_handles',
            'optype': { 'format': 'performance_schema_max_table_handles=#'},
            'values': ({ 'default': '100000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_thread_classes',
            'description': u'スレッドの最大数',
            'name': 'performance_schema_max_thread_classes',
            'optype': { 'format': 'performance_schema_max_thread_classes=#'},
            'values': ({ 'default': '50', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_mutex_instances',
            'description': u'mutexオブジェクトの最大数',
            'name': 'performance_schema_max_mutex_instances',
            'optype': { 'format': 'performance_schema_max_mutex_instances=#'},
            'values': ({ 'default': '1000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_rwlock_classes',
            'description': u'rwlockの最大数',
            'name': 'performance_schema_max_rwlock_classes',
            'optype': { 'format': 'performance_schema_max_rwlock_classes=#'},
            'values': ({ 'default': '20', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_table_instances',
            'description': u'テーブルオブジェクトの最大数',
            'name': 'performance_schema_max_table_instances',
            'optype': { 'format': 'performance_schema_max_table_instances=#'},
            'values': ({ 'default': '50000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_events_waits_history_long_size',
            'description': u'events_waits_history_longの行数',
            'name': 'performance_schema_events_waits_history_long_size',
            'optype': { 'format': 'performance_schema_events_waits_history_long_size=#'},
            'values': ({ 'default': '10000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_rwlock_instances',
            'description': u'rwlockオブジェクトの最大数',
            'name': 'performance_schema_max_rwlock_instances',
            'optype': { 'format': 'performance_schema_max_rwlock_instances=#'},
            'values': ({ 'default': '1000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_cond_instances',
            'description': u'条件オブジェクトの最大数',
            'name': 'performance_schema_max_cond_instances',
            'optype': { 'format': 'performance_schema_max_cond_instances=#'},
            'values': ({ 'default': '1000', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_cond_classes',
            'description': u'条件の最大数',
            'name': 'performance_schema_max_cond_classes',
            'optype': { 'format': 'performance_schema_max_cond_classes=#'},
            'values': ({ 'default': '80', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'performance_schema_max_mutex_classes',
            'description': u'mutexの最大数',
            'name': 'performance_schema_max_mutex_classes',
            'optype': { 'format': 'performance_schema_max_mutex_classes=#'},
            'values': ({ 'default': '200', 'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())})))),
  ( u'ログファイル',
    ( ( u'ログ',
        ( { 'caption': 'log-isam',
            'description': u'MyISAMの変更すべてをファイルに書き出す',
            'name': 'log-isam',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log',
            'deprecated': (5, 1, 29),
            'description': u'ログ接続とファイルへのクエリー',
            'name': 'log',
            'values': ({ 'default': 'OFF', 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-error',
            'description': u'エラーログファイル',
            'name': 'log-error',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-slow-queries',
            'deprecated': (5, 1, 29),
            'description': u'スロークエリーログを使うか。デフォルトではhostname-slow.logに書出します。他スロークエリーログを利用する場合は有効にする必要がある',
            'name': 'log-slow-queries',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'general-log',
            'description': u'標準ログを有効／無効にする',
            'name': 'general-log',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 12),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'log-bin',
            'description': u'バイナリログを有効にする',
            'name': 'log-bin',
            'values': ({ 'default': 'OFF', 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'Binlog',
        ( { 'caption': 'max-binlog-dump-events',
            'description': u'mysql-testがレプリケーションのデバッグ及びテストを使う設定',
            'name': 'max-binlog-dump-events',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog-do-db',
            'description': u'特定のデータベースほのバイナリログの制限する',
            'name': 'binlog-do-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog-format',
            'description': u'バイナリログの形式',
            'name': 'binlog-format',
            'optype': { 'format': 'binlog-format=format'},
            'values': ( { 'choice': ['ROW', 'STATEMENT'],
                          'default': 'STATEMENT',
                          'inversion': '5.1.5',
                          'outversion': '5.1.7',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'STATEMENT',
                          'inversion': '5.1.8',
                          'outversion': '5.1.11',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'MIXED',
                          'inversion': '5.1.12',
                          'outversion': '5.1.28',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'MIXED',
                          'inversion': '5.1.14-ndb-6.1.0',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'MIXED',
                          'inversion': '5.1.16-ndb-6.2.0',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'MIXED',
                          'inversion': '5.1.19-ndb-6.3.0',
                          'type': 'dropdownbox'},
                        { 'choice': ['ROW', 'STATEMENT', 'MIXED'],
                          'default': 'STATEMENT',
                          'inversion': '5.1.29',
                          'type': 'dropdownbox'}),
            'versions': ( ((5, 1, 5),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'max_binlog_size',
            'description': u'指定した大きさ以上になるとバイナリログはローテートされる',
            'name': 'max_binlog_size',
            'values': ( { 'default': '1073741824',
                          'maximum': '1073741824',
                          'minimum': '4096',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-bin-index',
            'description': u'最後のバイナリログファイルの名前を保管するファイル',
            'name': 'log-bin-index',
            'values': ({ 'default': 'OFF', 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'binlog-row-event-max-size',
            'description': u'バイナリログの最大イベントの大きさ',
            'name': 'binlog-row-event-max-size',
            'values': ( { 'bitsize': '32',
                          'default': '1024',
                          'maximum': '4294967295',
                          'minimum': '256',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1024',
                          'maximum': '18446744073709547520',
                          'minimum': '256',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 5),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'sync_binlog',
            'description': u'nイベント毎にバイナリログをディスクに同期FLUSHする',
            'name': 'sync_binlog',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 3), (5, 0, 1)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-bin-trust-routine-creators',
            'deprecated': (5, 0, 16),
            'description': u'（非推奨）代わりにlog-bin-trust-function-creatorsを使うことを推奨する',
            'name': 'log-bin-trust-routine-creators',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 6),),
                          ( (5, 0),
                            (5, 1),
                            (5, 2),
                            (5, 4),
                            (5, 5),
                            (5, 6)),
                          ((5, 2, 5), (5, 5, 3)))},
          { 'caption': 'binlog-ignore-db',
            'description': u'マスタに指定されたデータベースへの更新はバイナリログに出力しないように指示する',
            'name': 'binlog-ignore-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-bin-trust-function-creators',
            'description': u'0の場合（デフォルト）、--log-binが指定された場合はSUPER権限を付与されたユーザかつ作成する関数がバイナリログを壊さない場合のみ、がストアド関数を作成することができる',
            'name': 'log-bin-trust-function-creators',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 16),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sporadic-binlog-dump-fail',
            'description': u'レプリケーションのデバッグとテスト用のmysql-testが使う設定',
            'name': 'sporadic-binlog-dump-fail',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'Slow query log options',
        ( { 'caption': 'log-slow-admin-statements',
            'description': u'スローログが有効な場合は、遅いOPTIMIZE、ANALYZE、ALTERや他管理文をログする',
            'name': 'log-slow-admin-statements',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 13),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-slow-slave-statements',
            'description': u'スレーブが実行した遅い文をスロークエリーログに出力する',
            'name': 'log-slow-slave-statements',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 21), (6, 0, 4)),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'slow_query_log_file',
            'description': u'スロークエリーログファイルの名前',
            'name': 'slow_query_log_file',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 1, 12),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'long_query_time',
            'description': u'実行時間がlong_query_time秒以上のすべてのクエリーをファイルに出力する',
            'name': 'long_query_time',
            'values': ( { 'default': '10',
                          'minimum': '1',
                          'outversion': '5.0.20',
                          'type': 'numeric'},
                        { 'default': '10',
                          'inversion': '5.1.21',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '10',
                          'minimum': '1',
                          'outversion': '6.0.3',
                          'type': 'numeric'},
                        { 'default': '10',
                          'inversion': '6.0.4',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slow-query-log',
            'description': u'スロークエリーログを有効／無効にする',
            'name': 'slow-query-log',
            'optype': { 'inversion': '5.1.29'},
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 12),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())})),
      ( 'Advanced log options',
        ( { 'caption': 'log-short-format',
            'description': u"詳細情報を更新及びスロークエリーログに出力しない",
            'name': 'log-short-format',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'general_log_file',
            'description': u'標準クエリーログファイル名',
            'name': 'general_log_file',
            'optype': { 'inversion': '5.1.29'},
            'values': ({ 'default': 'host_name.log', 'type': 'filename'},),
            'versions': ( ((5, 1, 12),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'log-tc',
            'description': u'トランザクションコーディネータログへのパス（バイナリログが無効で、複数のストレージエンジンを跨るトランザクションの場合に利用）',
            'name': 'log-tc',
            'values': ({ 'default': 'tc.log', 'type': 'filename'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'min-examined-row-limit',
            'description': u'指定された行以下の行を検索するクエリーはスロークエリーログに出力しない',
            'name': 'min-examined-row-limit',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 21), (6, 0, 4)),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'log-warnings',
            'description': u'警告をログファイルに出力する',
            'disabledby': 'skip-log-warnings',
            'name': 'log-warnings',
            'values': ( { 'bitsize': '32',
                          'default': '1',
                          'inversion': '4.1.3',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1',
                          'inversion': '4.1.3',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-tc-size',
            'description': u'トランザクションコーディネータログの大きさ（KB）',
            'name': 'log-tc-size',
            'values': ( { 'bitsize': '32',
                          'default': '24576',
                          'maximum': '4294967295',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '24576',
                          'maximum': '18446744073709547520',
                          'type': 'numeric'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-queries-not-using-indexes',
            'description': u'索引を使わないクエリーをスロークエリーログに出力する',
            'name': 'log-queries-not-using-indexes',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'expire_logs_days',
            'description': u'0以外に設定された場合は、バイナリログはexpire_logs_days日以降に削除されます。削除は起動時、バイナリログロテーションの時に削除させることができます',
            'name': 'expire_logs_days',
            'values': ( { 'default': '0',
                          'maximum': '99',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-output',
            'description': u'一般クエリーログとスロークエリーログの出力先。文法：log-output[=値[,値...]]　値にはTABLE、FILE又はNONE',
            'name': 'log-output',
            'values': ( { 'choice': ['TABLE', 'FILE', 'NONE'],
                          'default': 'FILE',
                          'type': 'set'},),
            'versions': ( ((5, 1, 6),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())})))),
  ( u'セキュリティ',
    ( ( u'セキュリティ',
        ( { 'caption': 'local-infile',
            'description': u'LOAD DATA LOCAL INFILEを有効／無効にする（1又は0）',
            'name': 'local-infile',
            'values': ( { 'default': 'true',
                          'off': '0',
                          'on': '1',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-grant-tables',
            'description': u'GRANT TABLEなしで開始。すべてのユーザにすてべのテーブルへFULL ACCESS権限を付与します',
            'name': 'skip-grant-tables',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'des-key-file',
            'description': u'des_encrypt()からキーを読み込む。指定したファイルからdes_encryptから',
            'name': 'des-key-file',
            'optype': { 'format': 'des-key-file=file_name'},
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'read_only',
            'description': u'すべての非作業テーブルを読取り専用にする',
            'name': 'read_only',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'secure-auth',
            'description': u'旧（バージョン4.1より前）のパスワードを無効にする',
            'name': 'secure-auth',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'safemalloc-mem-limit',
            'description': u'メモリ不足をシミュレーション するシムレーショ',
            'name': 'safemalloc-mem-limit',
            'values': ({ 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ((5, 5, 6),))},
          { 'caption': 'safe-user-create',
            'description': u"mysql.userテーブルに書込み権限をもっていないユーザは、新しいユーザを作成できないようにする",
            'name': 'safe-user-create',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'secure-file-priv',
            'description': u'指定してディレクトリはの LOAD_FILE()、LOAD DATA、SELECT ... INTO OUTFILEの出力を制限する',
            'name': 'secure-file-priv',
            'optype': { 'format': 'secure-file-priv=path'},
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 0, 38), (5, 1, 17)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'old-passwords',
            'description': u'古い暗号化メソッドを使う（4.0以前のクライアントを使う場合に必要）',
            'name': 'old-passwords',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'safe-show-database',
            'deprecated': (4, 0, 2),
            'description': u'非推奨。代わりにGRANT SHOW DATABASESを利用することを推奨します',
            'name': 'safe-show-database',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'allow-suspicious-udfs',
            'description': u'xxx_init()及びxxx_deinit()が無い、１つのシンボルxxx()のみのUDFを許可する',
            'name': 'allow-suspicious-udfs',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 10), (5, 0, 3)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-show-database',
            'description': u'SHOW DATABASEの実行を禁止する',
            'name': 'skip-show-database',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( 'SSL',
        ( { 'caption': 'ssl-cipher',
            'description': u'使うSSLサイファ（--sslを有効にする）',
            'name': 'ssl-cipher',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl',
            'description': u'SSL接続を有効にする（他フラグを有効にすると有効になる）',
            'disabledby': 'skip-ssl',
            'name': 'ssl',
            'values': ( { 'default': 'false',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl-verify-server-cert',
            'description': u'クライアントサーバホスト名をサーバ認証のコモンネームと検証する',
            'name': 'ssl-verify-server-cert',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( ((5, 1, 11),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'ssl-capath',
            'description': u'CAディレクトリ（OpenSSLドキュメントを確認。--sslも有効になります）',
            'name': 'ssl-capath',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl-ca',
            'description': u'PEM形式のCAファイル（OpenSSLドキュメントを確認。--sslも有効になります）',
            'name': 'ssl-ca',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-ssl',
            'description': u"SSLは使わない",
            'name': 'skip-ssl',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl-cert',
            'description': u'PEM形式のX509 cert(--sslを意味する)',
            'name': 'ssl-cert',
            'values': ({ 'type': 'filename'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'ssl-key',
            'description': u'PEM形式のX509キー(--sslを意味する)',
            'name': 'ssl-key',
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 0, 23), (5, 1, 11)),
                          ( (4, 0),
                            (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})))),
  ( 'InnoDB',
    ( ( u'一般',
        ( { 'caption': 'innodb_replication_delay',
            'description': u'スレーブサーバレプリケーションスレッドディレイ',
            'name': 'innodb_replication_delay',
            'values': ( { 'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_checksums',
            'description': u'InnoDBチェックサム検証を有効にする',
            'name': 'innodb_checksums',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_use_legacy_cardinality_algorithm',
            'description': u'旧InnoDBのcardinality計算アルゴリズムを使うか',
            'name': 'innodb_use_legacy_cardinality_algorithm',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 0, 82), (5, 1, 35)), ((5, 0), (5, 1)), ())},
          { 'caption': 'innodb_autoextend_increment',
            'description': u'データファイルの自動拡張単位（MB）',
            'name': 'innodb_autoextend_increment',
            'values': ( { 'default': '8',
                          'maximum': '1000',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '64',
                          'inversion': '5.4.0',
                          'maximum': '1000',
                          'minimum': '1',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '8',
                          'inversion': '5.4.3',
                          'maximum': '1000',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 5),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_stats_on_metadata',
            'description': u'メタデータ文の場合、InnoDBテーブル統計を更新するか',
            'name': 'innodb_stats_on_metadata',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 17), (5, 5, 4)),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'innodb_stats_sample_pages',
            'description': u'索引分布統計に使う索引ページ数',
            'name': 'innodb_stats_sample_pages',
            'values': ( { 'default': '8',
                          'maximum': '2**64-1',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_autoinc_lock_mode',
            'description': u'InnoDBのauto-incrementロックモードを設定',
            'name': 'innodb_autoinc_lock_mode',
            'values': ( { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 22),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'innodb_old_blocks_time',
            'description': u'InnoDBバッファプールの古い側にあるブロックが新しい側に移動するまでの時間（ミリ秒）',
            'name': 'innodb_old_blocks_time',
            'values': ( { 'default': '0',
                          'maximum': '2**32-1',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((5, 1, 41),), ((5, 1), (5, 5), (5, 6)), ())},
          { 'caption': 'innodb_use_sys_malloc',
            'description': u'InnoDBがOS又は独自のメモリアロケータを使うか',
            'name': 'innodb_use_sys_malloc',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_table_locks',
            'description': u'LOCK TABLESにInnoDBロックを有効にする',
            'name': 'innodb_table_locks',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_spin_wait_delay',
            'description': u'スピンロックのポール間隔の最大ディレイ',
            'name': 'innodb_spin_wait_delay',
            'values': ( { 'default': '6',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'ignore-builtin-innodb',
            'description': u'ビルトインInnoDBを無視する',
            'name': 'ignore-builtin-innodb',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( ((5, 1, 33),),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_thread_sleep_delay',
            'description': u'InnoDBキューに戻されるまでのInnoDBスレッドがスリープする時間(usec)。0の設定した場合は、スリープを無効にする',
            'name': 'innodb_thread_sleep_delay',
            'values': ( { 'default': '0',
                          'inversion': '5.0.8',
                          'maximum': '4294967295',
                          'minimum': '1000',
                          'outversion': '5.0.18',
                          'type': 'numeric'},
                        { 'default': '0',
                          'inversion': '5.0.19',
                          'maximum': '4294967295',
                          'minimum': '1000',
                          'outversion': '5.0.20',
                          'type': 'numeric'},
                        { 'default': '8',
                          'inversion': '5.0.21',
                          'type': 'numeric'},
                        { 'default': '10000',
                          'inversion': '5.1.0',
                          'type': 'numeric'},
                        { 'default': '10000',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb-status-file',
            'description': u'innodb_status.[pid]ファイルにSHOW INNODB STATUS出力を有効にする',
            'name': 'innodb-status-file',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_max_purge_lag',
            'description': u'キューをパージする最大の長さ(0 = 無制限)',
            'name': 'innodb_max_purge_lag',
            'values': ( { 'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 6),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_file_format_check',
            'description': u'InnoDBがファイル形式互換性チェックを行うか',
            'name': 'innodb_file_format_check',
            'values': ( { 'default': 'Antelope',
                          'outversion': '5.1.41',
                          'type': 'string'},
                        { 'default': 'Barracuda',
                          'inversion': '5.1.42',
                          'type': 'string'},
                        { 'default': 'Antelope',
                          'outversion': '5.5.0',
                          'type': 'string'},
                        { 'default': 'Barracuda',
                          'inversion': '5.5.4',
                          'type': 'string'},
                        { 'default': 'on',
                          'inversion': '5.5.5',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'}),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_file_format',
            'description': u'新しいInnoDBテーブルの形式',
            'name': 'innodb_file_format',
            'values': ( { 'default': 'Antelope',
                          'inversion': '5.1.38',
                          'type': 'string'},
                        { 'choice': ['Antelope', 'Barracuda'],
                          'default': 'Barracuda',
                          'inversion': '5.5.0',
                          'outversion': '5.5.6',
                          'type': 'string'},
                        { 'choice': ['Antelope', 'Barracuda'],
                          'default': 'Antelope',
                          'inversion': '5.5.7',
                          'type': 'string'},
                        { 'choice': ['Antelope', 'Barracuda'],
                          'default': 'Antelope',
                          'inversion': '5.6.1',
                          'type': 'string'}),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_strict_mode',
            'description': u'例外時に警告の代わりにInnoDBはエラーを返すか',
            'name': 'innodb_strict_mode',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'autocommit',
            'description': u'オートコミットモード',
            'name': 'autocommit',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_old_blocks_pct',
            'description': u'旧ブロック用に確保するInnoDBバッファプールのパーセント',
            'name': 'innodb_old_blocks_pct',
            'values': ( { 'default': '37',
                          'maximum': '95',
                          'minimum': '5',
                          'type': 'numeric'},),
            'versions': (((5, 1, 41),), ((5, 1), (5, 5), (5, 6)), ())},
          { 'caption': 'timed_mutexes',
            'description': u'mutexの時間を測定するか(InnoDB mutexesのみに対応)',
            'name': 'timed_mutexes',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_adaptive_hash_index',
            'description': u'InnoDBハッシュ索引を有効／無効にする',
            'name': 'innodb_adaptive_hash_index',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 52), (5, 1, 24), (6, 0, 5)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_read_io_threads',
            'description': u'読み取りプリフェッチリクエストのバックグラウンドI/Oスレッド数',
            'name': 'innodb_read_io_threads',
            'values': ( { 'default': '4',
                          'maximum': '64',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 38),),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_doublewrite',
            'description': u'InnoDB doublewriteバッファを有効にする',
            'name': 'innodb_doublewrite',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_locks_unsafe_for_binlog',
            'description': u'next-keyロックを利用しないように強制する。行レベルロックのみを使う',
            'name': 'innodb_locks_unsafe_for_binlog',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 4),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_adaptive_flushing',
            'description': u'ダーティページのInnoDBの適応フラッシュを制御',
            'name': 'innodb_adaptive_flushing',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_sync_spin_loops',
            'description': u'InnoDB mutexのspin-loop数',
            'name': 'innodb_sync_spin_loops',
            'values': ( { 'default': '20',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '30',
                          'inversion': '5.4.2',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_read_ahead_threshold',
            'description': u'InnoDBリニアリードアヘッドのセンシビリティ',
            'name': 'innodb_read_ahead_threshold',
            'values': ( { 'default': '56',
                          'maximum': '64',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_change_buffering',
            'description': u'InnoDBがINSERTバッファをするか',
            'name': 'innodb_change_buffering',
            'values': ( { 'choice': ['inserts', 'none'],
                          'default': 'inserts',
                          'outversion': '5.5.3',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'inserts',
                                      'deletes',
                                      'purges',
                                      'changes',
                                      'all',
                                      'none'],
                          'default': 'all',
                          'inversion': '5.5.4',
                          'type': 'dropdownbox'}),
            'versions': ( ((5, 1, 38), (5, 4, 2)),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_concurrency_tickets',
            'description': u'チケットが取得してから同じSQLクエリーにInnoDBにスレッドは入ることが可能な回数',
            'name': 'innodb_concurrency_tickets',
            'values': ( { 'default': '500',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_support_xa',
            'description': u'InnoDBのXA 2フェーズコミットを有効にする',
            'name': 'innodb_support_xa',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_io_capacity',
            'description': u'1秒間の最大I/O処理数',
            'name': 'innodb_io_capacity',
            'values': ( { 'bitsize': '32',
                          'default': '200',
                          'maximum': '2**32-1',
                          'minimum': '100',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '200',
                          'maximum': '2**64-1',
                          'minimum': '100',
                          'type': 'numeric'}),
            'versions': ( ((5, 1, 38),),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())},
          { 'caption': 'innodb_commit_concurrency',
            'description': u'超並列環境でのパフォーマンスを改善する',
            'name': 'innodb_commit_concurrency',
            'values': ( { 'default': '0',
                          'maximum': '1000',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 12),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_rollback_on_timeout',
            'description': u'トランザクションタイムアウトした場合は最後の文だけでなく、トランザクションすべてをロールバックする',
            'name': 'innodb_rollback_on_timeout',
            'values': (),
            'versions': ( ((5, 0, 32), (5, 1, 15)),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_write_io_threads',
            'description': u'バッファキャッシュからディスクにダーティページをバックグランドで書き出すI/Oスレッド数',
            'name': 'innodb_write_io_threads',
            'values': ( { 'default': '4',
                          'maximum': '64',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 1, 38),),
                          ((5, 1), (5, 4), (5, 5), (5, 6)),
                          ())})),
      ( u'InnoDB',
        ( { 'caption': 'innodb',
            'description': u'InnoDBを有効にする（MySQLのバージョンが対応している場合）',
            'name': 'innodb',
            'values': ( { 'off': '0',
                          'on': '1',
                          'outversion': '5.1.35',
                          'type': 'boolean'},
                        { 'choice': ['OFF', 'ON', 'FORCE'],
                          'inversion': '5.1.36',
                          'type': 'dropdownbox'},
                        { 'inversion': '5.4.0',
                          'off': '0',
                          'on': '1',
                          'outversion': '5.4.1',
                          'type': 'boolean'},
                        { 'choice': ['OFF', 'ON', 'FORCE'],
                          'inversion': '5.4.2',
                          'type': 'dropdownbox'},
                        { 'inversion': '6.0.0',
                          'off': '0',
                          'on': '1',
                          'type': 'boolean'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},)),
      ( u'メモリ',
        ( { 'caption': 'innodb_buffer_pool_awe_mem_mb',
            'description': u'Windows AWEが使われる場合、AWEメモリからInnoDBバッファプールに割り当てる大きさ（MB）',
            'name': 'innodb_buffer_pool_awe_mem_mb',
            'values': ( { 'default': '0',
                          'maximum': '63000',
                          'minimum': '0',
                          'platform': 'windows',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ((5, 1, 13),))},
          { 'caption': 'innodb_buffer_pool_size',
            'description': u'InnoDBがテーブル用にデータ及び索引をキャッシュするためのメモリバッファの大きさ',
            'name': 'innodb_buffer_pool_size',
            'values': ( { 'bitsize': '32',
                          'default': '134217728',
                          'maximum': '2**32-1',
                          'minimum': '1048576',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '134217728',
                          'maximum': '2**64-1',
                          'minimum': '1048576',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_additional_mem_pool_size',
            'description': u'InnoDBがデータ辞書情報及び他内部構造使を保存するのに使うメモリプールの大きさ',
            'name': 'innodb_additional_mem_pool_size',
            'values': ( { 'default': '1048576',
                          'maximum': '4294967295',
                          'minimum': '524288',
                          'type': 'numeric'},
                        { 'default': '8388608',
                          'inversion': '5.4.0',
                          'maximum': '4294967295',
                          'minimum': '2097152',
                          'type': 'numeric'},
                        { 'default': '1048576',
                          'inversion': '6.0.0',
                          'maximum': '4294967295',
                          'minimum': '524288',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_buffer_pool_instances',
            'description': u'',
            'name': 'innodb_buffer_pool_instances',
            'values': ( { 'default': '1',
                          'maximum': '64',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': (((5, 5, 4),), ((5, 5),), ())})),
      ( 'Datafiles',
        ( { 'caption': 'innodb_file_per_table',
            'description': u'InnoDBテーブル毎にデータベースディレクトリ.ibdファイルを作成する',
            'name': 'innodb_file_per_table',
            'values': ( { 'default': 'off',
                          'inversion': '4.1.1',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},
                        { 'default': 'on',
                          'inversion': '5.5.0',
                          'off': 'off',
                          'on': 'on',
                          'outversion': '5.5.6',
                          'type': 'boolean'},
                        { 'default': 'off',
                          'inversion': '5.5.7',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},
                        { 'default': 'off',
                          'inversion': '5.6.1',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'}),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_data_file_path',
            'description': u'各ファイルへのパスとその大きさ',
            'name': 'innodb_data_file_path',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_data_home_dir',
            'description': u'InnoDBテーブルスペースの共有部分',
            'name': 'innodb_data_home_dir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'ログファイル',
        ( { 'caption': 'innodb_log_buffer_size',
            'description': u'InnoDBがディスクへログファイルを書き出すのに使うバッファの大きさ',
            'name': 'innodb_log_buffer_size',
            'values': ( { 'default': '1048576',
                          'maximum': '4294967295',
                          'minimum': '1048576',
                          'type': 'numeric'},
                        { 'default': '16777216',
                          'inversion': '5.4.0',
                          'maximum': '4294967295',
                          'minimum': '2097152',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '16777216',
                          'inversion': '5.4.2',
                          'maximum': '4294967295',
                          'minimum': '262144',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '8388608',
                          'inversion': '5.4.3',
                          'maximum': '4294967295',
                          'minimum': '262144',
                          'type': 'numeric'},
                        { 'default': '1048576',
                          'inversion': '6.0.0',
                          'maximum': '4294967295',
                          'minimum': '1048576',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_log_arch_dir',
            'deprecated': (5, 0, 24),
            'description': u'フールログのアーカイブ先',
            'name': 'innodb_log_arch_dir',
            'values': ({ 'type': 'filename'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ((5, 1, 21),))},
          { 'caption': 'innodb_log_archive',
            'description': u'未使用',
            'name': 'innodb_log_archive',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ((5, 1, 18),))},
          { 'caption': 'innodb_mirrored_log_groups',
            'description': u'データベース用に保管する同じ内容のロググループの数',
            'name': 'innodb_mirrored_log_groups',
            'values': ( { 'default': '1',
                          'maximum': '10',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_log_file_size',
            'description': u'ロググループの各ログファイルの大きさ',
            'name': 'innodb_log_file_size',
            'values': ( { 'default': '5242880',
                          'maximum': '4294967295',
                          'minimum': '1048576',
                          'type': 'numeric'},
                        { 'default': '134217728',
                          'inversion': '5.4.0',
                          'maximum': '4294967295',
                          'minimum': '33554432',
                          'outversion': '5.4.1',
                          'type': 'numeric'},
                        { 'default': '134217728',
                          'inversion': '5.4.2',
                          'maximum': '4294967295',
                          'minimum': '108576',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '5242880',
                          'inversion': '5.4.3',
                          'maximum': '4294967295',
                          'minimum': '108576',
                          'type': 'numeric'},
                        { 'default': '5242880',
                          'inversion': '6.0.0',
                          'maximum': '4294967295',
                          'minimum': '1048576',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_flush_method',
            'description': u'どのメソッドでデータをFLUSHするか',
            'name': 'innodb_flush_method',
            'values': ( { 'default': 'async_unbuffered',
                          'platform': 'windows',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'fdatasync',
                                      'O_DSYNC',
                                      'O_DIRECT'],
                          'default': 'fdatasync',
                          'outversion': '5.1.23',
                          'platform': 'linux',
                          'type': 'dropdownbox'},
                        { 'choice': ['O_DSYNC', 'O_DIRECT'],
                          'default': 'fdatasync',
                          'inversion': '5.1.24',
                          'platform': 'linux',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'fdatasync',
                                      'O_DSYNC',
                                      'O_DIRECT'],
                          'default': 'fdatasync',
                          'outversion': '5.1.23',
                          'platform': 'hpux',
                          'type': 'dropdownbox'},
                        { 'choice': ['O_DSYNC', 'O_DIRECT'],
                          'default': 'fdatasync',
                          'inversion': '5.1.24',
                          'platform': 'hpux',
                          'type': 'dropdownbox'},
                        { 'choice': [ 'fdatasync',
                                      'O_DSYNC',
                                      'O_DIRECT'],
                          'default': 'fdatasync',
                          'outversion': '5.1.23',
                          'platform': 'solaris',
                          'type': 'dropdownbox'},
                        { 'choice': ['O_DSYNC', 'O_DIRECT'],
                          'default': 'fdatasync',
                          'inversion': '5.1.24',
                          'platform': 'solaris',
                          'type': 'dropdownbox'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_log_files_in_group',
            'description': u'ロググループのInnoDBログファイルの数',
            'name': 'innodb_log_files_in_group',
            'values': ( { 'default': '2',
                          'maximum': '100',
                          'minimum': '2',
                          'type': 'numeric'},
                        { 'default': '3',
                          'inversion': '5.4.0',
                          'maximum': '100',
                          'minimum': '3',
                          'outversion': '5.4.2',
                          'type': 'numeric'},
                        { 'default': '2',
                          'inversion': '5.4.3',
                          'maximum': '100',
                          'minimum': '2',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_log_group_home_dir',
            'description': u'InnoDBログファイルのパス',
            'name': 'innodb_log_group_home_dir',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_flush_log_at_trx_commit',
            'description': u'0の場合は１秒毎に書き出しとFLUSHする、1の場合はコミット毎に書き出しとFLUSHする、2の場合はコミット毎に書き出しして、1秒ごとにFLUSHする',
            'name': 'innodb_flush_log_at_trx_commit',
            'values': ( { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb-safe-binlog',
            'deprecated': (5, 0, 3),
            'description': u'InnoDBをリカバリーした後に、最後のロールバックしないトランザクション後にバイナリログを削除する',
            'name': 'innodb-safe-binlog',
            'values': ({ 'off': '0', 'on': '1', 'type': 'boolean'},),
            'versions': (((4, 1, 3),), ((4, 1), (5, 0)), ((5, 0, 3),))})),
      ( 'Various',
        ( { 'caption': 'innodb_fast_shutdown',
            'description': u'InnoDBエンジンのシャットダウンを早くする',
            'name': 'innodb_fast_shutdown',
            'values': ( { 'choice': ['0', '1', '2'],
                          'default': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_force_recovery',
            'description': u'データベースのディスクイメージが破壊した場合のために、データを保存する',
            'name': 'innodb_force_recovery',
            'values': ( { 'choice': ['0', '1', '2', '3', '4', '5', '6'],
                          'default': '0',
                          'type': 'dropdownbox'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_use_native_aio',
            'description': u'非同期I/Oサブシステムを無効にするか',
            'name': 'innodb_use_native_aio',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 5, 4),), ((5, 5), (5, 6)), ())},
          { 'caption': 'innodb_thread_concurrency',
            'description': u'InnoDB内の最大スレッド数を設定します。0に設定するとスレッド数は変動しません',
            'name': 'innodb_thread_concurrency',
            'values': ( { 'default': '8',
                          'maximum': '1000',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '20',
                          'inversion': '5.0.9',
                          'maximum': '1000',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '8',
                          'inversion': '5.0.19',
                          'maximum': '1000',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '0',
                          'inversion': '5.4.0',
                          'maximum': '1000',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '8',
                          'inversion': '6.0.0',
                          'maximum': '1000',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_max_merged_io',
            'description': u'指定された値のバックグラウンドI/Oリクエストがある場合は、リクエストを結合してより大きなI/Oリクエストを作成する',
            'name': 'innodb_max_merged_io',
            'values': ({ 'default': '64', 'type': 'numeric'},),
            'versions': ((), ((5, 4),), ((5, 4, 2),))},
          { 'caption': 'innodb_extra_dirty_writes',
            'description': u'ダーティページの比率が最大のダーティパーセントより低い場合にダーティバッファページをFLUSHするか',
            'name': 'innodb_extra_dirty_writes',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ((), ((5, 4),), ((5, 4, 2),))},
          { 'caption': 'innodb_lock_wait_timeout',
            'description': u'ロールバックする前に、InnoDBトランザクションはロックを待つ時間（秒）',
            'name': 'innodb_lock_wait_timeout',
            'values': ( { 'default': '50',
                          'maximum': '1073741824',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_file_format_max',
            'description': u'共有テーブルスペースのファイル形式タグ',
            'name': 'innodb_file_format_max',
            'values': ( { 'choice': ['Antelope', 'Barracuda'],
                          'default': 'Antelope',
                          'type': 'string'},),
            'versions': (((5, 5, 5),), ((5, 5), (5, 6)), ())},
          { 'caption': 'innodb_purge_batch_size',
            'description': u'パージ処理をトリガーするInnoDB redoログの数',
            'name': 'innodb_purge_batch_size',
            'values': ( { 'default': '20',
                          'maximum': '5000',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': (((5, 5, 4),), ((5, 5), (5, 6)), ())},
          { 'caption': 'innodb_purge_threads',
            'description': u'InnoDBパージ処理を別のスレッドで行うか指定。デフォルトでは、InnoDBマスタスレッドで行われます',
            'name': 'innodb_purge_threads',
            'values': ( { 'default': '0',
                          'maximum': '1',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((5, 5, 4),), ((5, 5), (5, 6)), ())},
          { 'caption': 'innodb_file_io_threads',
            'description': u'InnoDBのファイルI/Oスレッド数',
            'name': 'innodb_file_io_threads',
            'values': ( { 'default': '4',
                          'maximum': '64',
                          'minimum': '4',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1), (6, 0)), ())},
          { 'caption': 'innodb_max_dirty_pages_pct',
            'description': u'バッファプールにダーティページを許す比率（パーセント）',
            'name': 'innodb_max_dirty_pages_pct',
            'values': ( { 'default': '90',
                          'maximum': '100',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '75',
                          'inversion': '5.4.0',
                          'maximum': '99',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '90',
                          'inversion': '6.0.0',
                          'maximum': '100',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_open_files',
            'description': u'InnoDBが同時に開ける最大のファイル数',
            'name': 'innodb_open_files',
            'values': ( { 'default': '300',
                          'maximum': '4294967295',
                          'minimum': '10',
                          'type': 'numeric'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'innodb_thread_concurrency_timer_based',
            'description': u'並列スレッドを処理するのにロックフリー方式を使うか',
            'name': 'innodb_thread_concurrency_timer_based',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ((), ((5, 4),), ((5, 4, 2),))})))),
  ( 'NDB',
    ( ( '',
        ( { 'caption': 'ndb-connectstring',
            'description': u'クラスタ設定を分散する管理サーバ',
            'name': 'ndb-connectstring',
            'values': ({ 'type': 'string'},),
            'versions': ((), ((5, 1),), ())},
          { 'caption': 'ndb_report_thresh_binlog_mem_usage',
            'description': u'binlog状態を警告する利用可能なメモリのしきりい値',
            'name': 'ndb_report_thresh_binlog_mem_usage',
            'values': ( { 'default': '10',
                          'maximum': '10',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1), (6, 0)), ())},
          { 'caption': 'ndb-nodeid',
            'description': u'このMySQLサーバ用のMySQLクラスタノードID',
            'name': 'ndb-nodeid',
            'values': ( { 'inversion': '5.0.45',
                          'maximum': '63',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'inversion': '5.1.5',
                          'maximum': '255',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': (((5, 0, 45), (5, 1, 15)), ((5, 0), (5, 1)), ())},
          { 'caption': 'ndb_index_stat_enable',
            'description': u'クエリーの最適化を行うためにNDB索引統計を使う',
            'name': 'ndb_index_stat_enable',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (6, 0)),
                          ((5, 1, 19),))},
          { 'caption': 'ndb-mgmd-host',
            'description': u'管理サーバに接続するホスト（必要に応じてポート番号）',
            'name': 'ndb-mgmd-host',
            'values': ({ 'default': 'localhost:1186', 'type': 'string'},),
            'versions': ((), ((5, 0), (5, 1)), ())},
          { 'caption': 'skip-ndbcluster',
            'description': u'NDBクラスタエンジンを無効にする',
            'name': 'skip-ndbcluster',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ((), ((5, 1), (6, 0)), ())},
          { 'caption': 'ndb-cluster-connection-pool',
            'description': u'クラスタでMySQLが使う接続数',
            'name': 'ndb-cluster-connection-pool',
            'values': ( { 'default': '1',
                          'maximum': '63',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': (((5, 1, 19),), ((5, 1),), ())},
          { 'caption': 'ndb-wait-connected',
            'description': u'MySQLサーバがMySQLクライアントから受け入れる前にクラスタ管理とデータノードとの接続を待つを待つ時間（秒）',
            'name': 'ndb-wait-connected',
            'values': ( { 'default': '0',
                          'maximum': '31536000',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((5, 1, 16),), ((5, 1),), ())},
          { 'caption': 'ndb_index_stat_update_freq',
            'description': u'統計キャッシュではなく、データノードをクエリーする頻度',
            'name': 'ndb_index_stat_update_freq',
            'values': ( { 'default': '20',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (6, 0)),
                          ((5, 1, 14),))},
          { 'caption': 'ndb_cache_check_time',
            'description': u'MySQLクエリーキャッシュがクラスタSQLノードをチェックする間隔（ミリ秒）',
            'name': 'ndb_cache_check_time',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ())},
          { 'caption': 'ndb_log_empty_epochs',
            'description': u'有効に設定された場合は、--log-slave-updatesが有効に設定されたにも関わらず、ndb_apply_status及びndb_binlog_indexテーブルに変更を書き込まない',
            'name': 'ndb_log_empty_epochs',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 1, 31),), ((5, 1),), ())},
          { 'caption': 'ndb_extra_logging',
            'description': u'MySQLエラーログのMySQLクラスタスキーマ、接続、データ分散イベントのログ出力を制御する',
            'name': 'ndb_extra_logging',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': (((5, 1, 6),), ((5, 1),), ())},
          { 'caption': 'ndb_optimized_node_selection',
            'description': u'SQLノードがどのようにしてトランザクションコーディネータとして使うクラスタデータノードを選択するかを決める',
            'name': 'ndb_optimized_node_selection',
            'values': ( { 'default': 'on',
                          'inversion': '4.1.9',
                          'off': 'off',
                          'on': 'on',
                          'outversion': '5.1.22-ndb-6.33',
                          'type': 'boolean'},
                        { 'default': '3',
                          'inversion': '5.1.22-ndb-6.3.4',
                          'maximum': '3',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': (((4, 1, 9),), ((4, 1), (5, 0), (5, 1)), ())},
          { 'caption': 'ndb_index_stat_cache_entries',
            'description': u'開始キーと終了キーの数を計算し、統計の粒度を設定します',
            'name': 'ndb_index_stat_cache_entries',
            'values': ( { 'default': '32',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (6, 0)),
                          ((5, 1, 14),))},
          { 'caption': 'ndb_use_transactions',
            'description': u'クエリーのパフォーマンスを改善するために、SELECT COUNT(*)クエリーの実行計画に、NDBを強制的にレコード数を使うようにする',
            'name': 'ndb_use_transactions',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 18),),
                          ((4, 1), (5, 0), (5, 1), (6, 0)),
                          ())},
          { 'caption': 'ndb_force_send',
            'description': u'他スレッドを待たずに、バッファを直接NDBに送信する',
            'name': 'ndb_force_send',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': (((4, 1, 8),), ((4, 1), (5, 0), (5, 1)), ())},
          { 'caption': 'ndbcluster',
            'description': u'NDBクラスタを有効にする（利用しているMySQLがサポートしている場合のみ）',
            'disabledby': 'skip-ndbcluster',
            'name': 'ndbcluster',
            'values': ( { 'default': 'false',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1)), ())},
          { 'caption': 'ndb-wait-setup',
            'description': u'MySQLサーバがNDBエンジンセットアップが完了するのを待つ時間（秒）',
            'name': 'ndb-wait-setup',
            'values': ( { 'default': '15',
                          'maximum': '31536000',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((5, 1, 39),), ((5, 1),), ())},
          { 'caption': 'ndb-batch-size',
            'description': u'NDBトランザクションバッチに使う大きさ（バイト）',
            'name': 'ndb-batch-size',
            'values': ( { 'default': '32768',
                          'maximum': '31536000',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((5, 1, 23),), ((5, 1),), ())},
          { 'caption': 'ndb-log-update-as-write',
            'description': u'ログをマスタの更新（OFF）又は書込み（ON）に切り替える',
            'name': 'ndb-log-update-as-write',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 1, 19),), ((5, 1),), ())},
          { 'caption': 'ndb_log_updated_only',
            'description': u'完全行（ON）をログ又は更新のみ（OFF）をログします',
            'name': 'ndb_log_updated_only',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 1, 19),), ((5, 1),), ())},
          { 'caption': 'ndb_report_thresh_binlog_epoch_slip',
            'description': u'binlog状態に通達するまでのepochのしきり値',
            'name': 'ndb_report_thresh_binlog_epoch_slip',
            'values': ( { 'default': '3',
                          'maximum': '256',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ((), ((4, 1), (5, 0), (5, 1), (6, 0)), ())},
          { 'caption': 'ndb_autoincrement_prefetch_sz',
            'description': u'NDBオートインクリメントプレフェッチサイズ',
            'name': 'ndb_autoincrement_prefetch_sz',
            'values': ( { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.0.54',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.0.56',
                          'maximum': '256',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.22-ndb-6.2.9',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.1.23-ndb-6.2.10',
                          'maximum': '256',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.22-ndb-6.3.6',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.1.23-ndb-6.3.7',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.39-ndb-6.3.30',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.1.41-ndb-6.3.31',
                          'maximum': '65536',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.39-ndb-7.0.10',
                          'type': 'numeric'},
                        { 'default': '32',
                          'inversion': '5.1.41-ndb-7.0.11',
                          'maximum': '256',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '32',
                          'maximum': '256',
                          'minimum': '1',
                          'outversion': '5.1.22',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '5.1.23',
                          'maximum': '256',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 8),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),)),
  ( u'トランザクション',
    ( ( u'その他',
        ( { 'caption': 'completion_type',
            'description': u'デフォルトの完了タイプ',
            'name': 'completion_type',
            'values': ( { 'choice': ['0', '1', '2'],
                          'default': '0',
                          'inversion': '5.0.3',
                          'outversion': '5.5.2',
                          'type': 'numeric'},
                        { 'choice': [ 'NO_CHAIN',
                                      'CHAIN',
                                      'RELEASE',
                                      '0',
                                      '1',
                                      '2'],
                          'default': 'NO_CHAIN',
                          'inversion': '5.5.3',
                          'type': 'dropdownbox'},
                        { 'choice': ['0', '1', '2'],
                          'default': '0',
                          'inversion': '6.0.0',
                          'outversion': '6.0.14',
                          'type': 'numeric'},
                        { 'choice': [ 'NO_CHAIN',
                                      'CHAIN',
                                      'RELEASE',
                                      '0',
                                      '1',
                                      '2'],
                          'default': 'NO_CHAIN',
                          'inversion': '6.0.14',
                          'type': 'dropdownbox'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},)),)),
  ( u'ネットワーク',
    ( ( u'一般',
        ( { 'caption': 'socket',
            'description': u'接続用に使うソケットファイル',
            'name': 'socket',
            'values': ( { 'default': '/tmp/mysql.sock',
                          'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},)),
      ( u'データ／メモリサイズ',
        ( { 'caption': 'max_allowed_packet',
            'description': u'サーバから送受信する最大のパケット長',
            'name': 'max_allowed_packet',
            'values': ( { 'default': '1048576',
                          'maximum': '1073741824',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'net_buffer_length',
            'description': u'ソケットとTCP/IP通信のバッファ長',
            'name': 'net_buffer_length',
            'values': ( { 'default': '16384',
                          'maximum': '1048576',
                          'minimum': '1024',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'タイムアウト',
        ( { 'caption': 'net_read_timeout',
            'description': u'読み取りを中断する前に接続からデータを待つ時間（秒）',
            'name': 'net_read_timeout',
            'values': ( { 'default': '30',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'wait_timeout',
            'description': u'サーバが接続を終了する前にアクティビティを待つ時間（秒）',
            'name': 'wait_timeout',
            'values': ( { 'default': '28800',
                          'maximum': '31536000',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '28800',
                          'maximum': '2147483',
                          'minimum': '1',
                          'platform': 'windows',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'net_write_timeout',
            'description': u'書き込みを中断するまでに、接続にブロックを書き込むまでに待つ時間（秒）',
            'name': 'net_write_timeout',
            'values': ( { 'default': '60',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'connect_timeout',
            'description': u"mysqldサーバが「bad handshake」を返す前にパケットを待つ時間（秒）",
            'name': 'connect_timeout',
            'values': ( { 'default': '5',
                          'minimum': '2',
                          'outversion': '5.0.51',
                          'type': 'numeric'},
                        { 'default': '10',
                          'inversion': '5.0.52',
                          'type': 'numeric'},
                        { 'default': '5',
                          'outversion': '5.1.22',
                          'type': 'numeric'},
                        { 'default': '10',
                          'inversion': '5.1.23',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'interactive_timeout',
            'description': u'対話式接続中に、サーバが通信を閉じるまで通信を待つ時間（秒）',
            'name': 'interactive_timeout',
            'values': ( { 'default': '28800',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'詳細',
        ( { 'caption': 'net_retry_count',
            'description': u'コミュニケーションポートが中断された場合は、指定された回数まで再接続を試す',
            'name': 'net_retry_count',
            'values': ( { 'bitsize': '32',
                          'default': '10',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '10',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_connections',
            'description': u'同時に接続できるクライアントの最大数',
            'name': 'max_connections',
            'values': ( { 'default': '100',
                          'outversion': '5.1.14',
                          'type': 'numeric'},
                        { 'default': '151',
                          'inversion': '5.1.15',
                          'maximum': '16384',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'default': '151',
                          'inversion': '5.1.17',
                          'maximum': '100000',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_user_connections',
            'description': u'１ユーザの最大アクティブ接続数（0=無制限）',
            'name': 'max_user_connections',
            'values': ( { 'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'max_connect_errors',
            'description': u'ホストから指定された以上の中断された場合は、ホストをブロックする',
            'name': 'max_connect_errors',
            'values': ( { 'bitsize': '32',
                          'default': '10',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '10',
                          'maximum': '18446744073709547520',
                          'minimum': '1',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'名前解決',
        ( { 'caption': 'skip-name-resolve',
            'description': u"ホスト名を解決しない。すべてのホスト名はIPアドレスか「localhost」である",
            'name': 'skip-name-resolve',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'skip-host-cache',
            'description': u"ホスト名をキャッシュしない",
            'name': 'skip-host-cache',
            'values': ({ 'off': 'del', 'on': 'name', 'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})))),
  ( u'レプリケーション',
    ( ( u'一般',
        ( { 'caption': 'init-rpl-role',
            'description': u'レプリケーションロールを設定（未使用）',
            'name': 'init-rpl-role',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (6, 0)),
                          ())},
          { 'caption': 'server-id',
            'description': u'レプリケーションパートナコミュニティ内でサーバインスタンスを識別するID.レプリケーションを有効にするには、0より大きな値を設定してください。',
            'name': 'server-id',
            'values': ( { 'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'マスタ',
        ( { 'caption': 'show-slave-auth-info',
            'description': u'このマスタでSHOW SLAVE HOSTSを実行した場合にユーザ名とパスワードを表示する',
            'name': 'show-slave-auth-info',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'auto_increment_increment',
            'description': u'AUTO_INCREMENT列を指定した値で増やす',
            'name': 'auto_increment_increment',
            'values': ( { 'default': '1',
                          'maximum': '65535',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 2),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'auto_increment_offset',
            'description': u'AUTO_INCREMENT列に足すオフセット',
            'name': 'auto_increment_offset',
            'values': ( { 'default': '1',
                          'maximum': '65535',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 2),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'master-bind',
            'description': u'複数のネットワーク接続をもつスレーブがマスタに接続する時に使うネットワークインターフェース',
            'name': 'master-bind',
            'values': ({ 'type': 'string'},),
            'versions': ( ((5, 1, 22),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())})),
      ( u'一般スレーブ',
        ( { 'caption': 'slave-net-timeout',
            'description': u'マスタ／スレーブ接続で、読込みを中断するまでにデータを待つ時間（秒）',
            'name': 'slave-net-timeout',
            'values': ( { 'default': '3600',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'disconnect-slave-event-count',
            'description': u'mysql-testがレプリケーションのデバッグ及びテスト用に使う設定',
            'name': 'disconnect-slave-event-count',
            'values': ({ 'default': '0', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'abort-slave-event-count',
            'description': u'mysql-testがレプリケーションのデバッグ及びテスト用に使う設定',
            'name': 'abort-slave-event-count',
            'values': ( { 'default': '0',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave-skip-errors',
            'description': u'クエリー結果が指定した一覧に記載されているエラーの場合は、スレーブスレッドはレプリケーションを継続する',
            'name': 'slave-skip-errors',
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave_allow_batching',
            'description': u'レプリケーションスレーブのバッチ更新を有効／無効にする',
            'name': 'slave_allow_batching',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((5, 1, 19),), ((5, 1),), ())},
          { 'caption': 'skip-slave-start',
            'description': u'設定した場合は、スレーブは自動起動しません',
            'name': 'skip-slave-start',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave_transaction_retries',
            'description': u'スレーブSQLスレッドがトランザクション中にデッドロック及びロックタイムアウトが発生した場合に、再実行する回数',
            'name': 'slave_transaction_retries',
            'values': ( { 'bitsize': '32',
                          'default': '10',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '10',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( ((4, 1, 11), (5, 0, 3)),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-slave-updates',
            'description': u'スレーブに、SQLスレッドが行った更新を独自のバイナリログに出力させる',
            'name': 'log-slave-updates',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave-load-tmpdir',
            'description': u'LOAD DATA INFILE文をレプリケーションする場合に、スレーブが作成する作業用ファイルの場所',
            'name': 'slave-load-tmpdir',
            'values': ({ 'default': '/tmp', 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'slave_compressed_protocol',
            'description': u'マスタ／スレーブプロトコルを圧縮する',
            'name': 'slave_compressed_protocol',
            'values': ( { 'default': 'off',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'スレーブレプリケーションオブジェクト',
        ( { 'caption': 'replicate-ignore-db',
            'description': u'スレーブSQLスレッドを指定したデータベースにレプリケーションしないようにする',
            'name': 'replicate-ignore-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-wild-do-table',
            'description': u'スレーブスレッドは、指定されたワイルドカードパターンに一致したテーブルのレプリケーションを制限します',
            'name': 'replicate-wild-do-table',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-ignore-table',
            'description': u'スレーブSQLスレッドを指定したテーブルにレプリケーションしないようにする',
            'name': 'replicate-ignore-table',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-do-db',
            'description': u'スレーブSQLスレッドに指定したデータベースへのレプリケーションを制限させます',
            'name': 'replicate-do-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-do-table',
            'description': u'スレーブSQLスレッドの特定テーブルへのレプリケーションを制限する',
            'name': 'replicate-do-table',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-rewrite-db',
            'description': u'データベースの更新を元と異なる名前で行う',
            'name': 'replicate-rewrite-db',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'replicate-wild-ignore-table',
            'description': u'スレーブスレッドは、指定されたワイルドカードパターンと一致したテーブルをレプリケーションしません',
            'name': 'replicate-wild-ignore-table',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'スレーブID',
        ( { 'caption': 'report-port',
            'description': u'スレーブがマスタに登録するときに報告するポート番号',
            'name': 'report-port',
            'values': ({ 'default': '3306', 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'report-user',
            'description': u'スレーブサーバがマスタサーバに報告するアカウント名',
            'name': 'report-user',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'report-host',
            'description': u'スレーブがマスタに登録するときに報告するホスト名及びIPアドレス',
            'name': 'report-host',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'report-password',
            'description': u'スレーブサーバがマスタサーバに報告するアカウントパスワード',
            'name': 'report-password',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'リレーログ',
        ( { 'caption': 'max_relay_log_size',
            'description': u'0以外の場合は、リレーログが指定された大きさになった場合はローテートする',
            'name': 'max_relay_log_size',
            'values': ( { 'default': '0',
                          'maximum': '1073741824',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay-log-index',
            'description': u'最後のリレーログ一覧を保管しているファイルの名前と場所',
            'name': 'relay-log-index',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay_log_info_file',
            'description': u'スレーブがリレーログに関しての情報を記憶するファイルの名前',
            'name': 'relay_log_info_file',
            'values': ({ 'default': 'relay-log.info', 'type': 'string'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay_log_purge',
            'description': u'リレーログをパージするか',
            'name': 'relay_log_purge',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( ((4, 1, 1),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay_log_space_limit',
            'description': u'すべてのリレーログで使う最大の領域',
            'name': 'relay_log_space_limit',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'relay-log',
            'description': u'リレーログに使う場所とベース名',
            'name': 'relay-log',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})),
      ( u'スレーブデフォルト接続値',
        ( { 'caption': 'master-ssl-capath',
            'deprecated': (5, 1, 17),
            'description': u'マスタのSSL CAぱす。master-sslが有効な場合のみに利用される',
            'name': 'master-ssl-capath',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl-ca',
            'deprecated': (5, 1, 17),
            'description': u'マスタのSSL CAファイル。master-sslが有効な場合のみに利用される',
            'name': 'master-ssl-ca',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl-cert',
            'deprecated': (5, 1, 17),
            'description': u'マスタのSSLサーティふぃケートファイル名。master-sslが有効な場合のみに利用される',
            'name': 'master-ssl-cert',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-port',
            'deprecated': (5, 1, 17),
            'description': u'マスタがレッスンしているポート番号',
            'name': 'master-port',
            'values': ({ 'default': '3306', 'type': 'numeric'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl-cipher',
            'deprecated': (5, 1, 17),
            'description': u'マスタのSSLサイファ。master-sslを有効にした場合のみ有効',
            'name': 'master-ssl-cipher',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-host',
            'deprecated': (5, 1, 17),
            'description': u'レプリケーションのマスタホスト名又はIPアドレス',
            'name': 'master-host',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-retry-count',
            'description': u'スレーブがマスタに接続できない場合に、再接続を試す回数',
            'name': 'master-retry-count',
            'values': ( { 'bitsize': '32',
                          'default': '86400',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '86400',
                          'maximum': '18446744073709551615',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'master-connect-retry',
            'deprecated': (5, 1, 17),
            'description': u'マスタで落ちた場合、又は接続が切断された場合に、スレーブスレッドがマスタへ再接続するまでに待つ時間（秒）',
            'name': 'master-connect-retry',
            'values': ({ 'default': '60', 'type': 'numeric'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-user',
            'deprecated': (5, 1, 17),
            'description': u'スレーブスレッドがマスタに接続するのに使うユーザ名。ユーザはFILE権限が必要です。マスタユーザが設定されていない場合は、ユーザtestが使われます。master.infoから情報を読み取れる場合は、その情報を優先して使います',
            'name': 'master-user',
            'values': ({ 'default': 'test', 'type': 'string'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl-key',
            'deprecated': (5, 1, 17),
            'description': u'マスタSSLキーファイル名。master-sslを有効にした場合のみ有効',
            'name': 'master-ssl-key',
            'values': ({ 'type': 'filename'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-ssl',
            'deprecated': (5, 1, 17),
            'description': u'スレーブがSSLを使ってマスタに接続することを可能にする',
            'name': 'master-ssl',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-password',
            'deprecated': (5, 1, 17),
            'description': u'スレーブスレッドがマスタに接続するのに使うパスワード',
            'name': 'master-password',
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)),
                          ((5, 5, 3),))},
          { 'caption': 'master-info-file',
            'description': u"マスタとI/Oレプリケーションスレッドがマスタのbinlogのmaster.infoどこにあるのかを記録したファイルの名前と場所",
            'name': 'master-info-file',
            'optype': { 'format': 'master-info-file=file_name'},
            'values': ({ 'default': 'master.info', 'type': 'filename'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())})))),
  ( u'その他',
    ( ( u'非ソート',
        ( { 'caption': 'exit-info',
            'description': u'デバッグに使う。自分の判断で使ってください',
            'name': 'exit-info',
            'values': ({ 'type': 'numeric'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sync_relay_log',
            'description': u'n回以降にリレーログをディスクに同期する',
            'name': 'sync_relay_log',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': (((6, 0, 10),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'mutex-deadlock-detector',
            'description': u'不正なmutex利用Yを検出する',
            'name': 'mutex-deadlock-detector',
            'values': ( { 'default': 'true',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': (((6, 0, 9),), ((6, 0),), ())},
          { 'caption': 'enable-locking',
            'deprecated': (4, 0, 3),
            'description': u'非推奨設定。代わりに--external-lockingを利用してください',
            'name': 'enable-locking',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'backup_elevation',
            'description': u'BACKUP DATABASE権限の昇格を有効／無効にする',
            'name': 'backup_elevation',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'sync_master_info',
            'description': u'指定したイベント毎にmaster.infoをディスクに同期する',
            'name': 'sync_master_info',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': (((6, 0, 11),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'restore_precheck',
            'description': u'RESTOREコマンドがリストアする前に権限チェックを行うか',
            'name': 'restore_precheck',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'multi_range_count',
            'description': u'範囲選択中にレンジをテーブルハンドラーに送るレンジの最大数',
            'name': 'multi_range_count',
            'values': ( { 'default': '256',
                          'maximum': '4294967295',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 3),),
                          ((5, 0), (5, 1), (5, 2)),
                          ((5, 2, 4), (6, 0, 3)))},
          { 'caption': 'large-pages',
            'description': u'大きなページをサポートする',
            'name': 'large-pages',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'platform': 'linux',
                          'type': 'boolean'},),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sync_relay_log_info',
            'description': u'指定されたイベント数毎にリレー情報ファイルをディスクに同期する',
            'name': 'sync_relay_log_info',
            'values': ( { 'bitsize': '32',
                          'default': '0',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '0',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': (((6, 0, 11),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'restore_elevation',
            'description': u'RESTORE権限の昇格を有効／無効にする',
            'name': 'restore_elevation',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'backup_progress_log_file',
            'description': u'MySQLバックアップ進捗ログファイルの名前',
            'name': 'backup_progress_log_file',
            'values': ( { 'default': 'backup_progress.log',
                          'type': 'filename'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'init_connect',
            'description': u'新しい接続毎に実行する文',
            'name': 'init_connect',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'sql-bin-update-same',
            'description': u'バージョン5.0から更新ログの利用は非推奨です。代わりにバイナリログを使ってください',
            'name': 'sql-bin-update-same',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1),), ())},
          { 'caption': 'log-long-format',
            'deprecated': (4, 1),
            'description': u'更新ログに詳細情報も出力する。この設定は非推奨です。代わりに--log-short-formatを使ってください',
            'name': 'log-long-format',
            'values': (),
            'versions': ((), ((4, 1),), ())},
          { 'caption': 'backup_progress_log',
            'description': u'MySQLバックアップ進捗ログを有効／無効にするか',
            'name': 'backup_progress_log',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'backup_history_log',
            'description': u'MySQLバックアップ履歴ログを有効／無効にするか',
            'name': 'backup_history_log',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'debug',
            'description': u'出力デバッグログ',
            'name': 'debug',
            'values': ( { 'default': "'d:t:o,/tmp/mysqld.trace'",
                          'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'log-backup-output',
            'description': u'MySQLバックアップ履歴及び進捗ログの出力先。文法：log-backup-output[=値[,値...]]、値はTABLE、FILE、又はNONE',
            'name': 'log-backup-output',
            'values': ( { 'choice': ['TABLE', 'FILE', 'NONE'],
                          'default': 'TABLE',
                          'type': 'set'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'lc-messages',
            'description': u'エラーメッセージのロケール',
            'name': 'lc-messages',
            'values': ({ 'type': 'string'},),
            'versions': (((6, 0, 14),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'server-id-bits',
            'description': u'実際にサーバを識別するためのserver_idの有効ビット数を指定する。NDB APIアプリケーションは余ったビットにアプリケーションデータを入れることができる。server_idは指定された値の2乗よりも小さくなければならない',
            'name': 'server-id-bits',
            'values': ( { 'default': '32',
                          'maximum': '32',
                          'minimum': '7',
                          'type': 'numeric'},),
            'versions': (((5, 1, 47),), ((5, 1),), ())},
          { 'caption': 'div_precision_increment',
            'description': u"割り算「/」の小数点を指定された数で増やす",
            'name': 'div_precision_increment',
            'values': ( { 'default': '4',
                          'maximum': '30',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 6),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'engine-condition-pushdown',
            'deprecated': (5, 5, 3),
            'description': u'ストレージエンジンにクエリー条件をプッシュする',
            'name': 'engine-condition-pushdown',
            'values': ( { 'default': 'off',
                          'inversion': '5.0.3',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},
                        { 'default': 'on',
                          'inversion': '5.1.0',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'}),
            'versions': ( ((5, 0, 3),),
                          ( (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'restore_disables_events',
            'description': u'RESTOREはリストアイベントを無効にするか',
            'name': 'restore_disables_events',
            'values': ( { 'default': 'on',
                          'off': 'off',
                          'on': 'on',
                          'type': 'boolean'},),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'relay_log_recovery',
            'description': u'機動時にマスタから自動的にリレーログファイルからの復旧を有効にする',
            'name': 'relay_log_recovery',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': (((6, 0, 11),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'old-protocol',
            'description': u'旧サーバの振る舞い',
            'name': 'old-protocol',
            'values': ( { 'default': 'false',
                          'off': 'false',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1),), ((4, 1, 1),))},
          { 'caption': 'join_cache_level',
            'description': u'joinバッファがどのように使われるか',
            'name': 'join_cache_level',
            'values': ( { 'default': '1',
                          'maximum': '8',
                          'minimum': '0',
                          'type': 'numeric'},),
            'versions': (((6, 0, 9),), ((6, 0),), ((6, 0, 14),))},
          { 'caption': 'init_slave',
            'description': u'スレーブがマスタに接続した時に実行されるコマンド',
            'name': 'init_slave',
            'values': ({ 'type': 'string'},),
            'versions': ( ((4, 1, 2),),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'table_lock_wait_timeout',
            'description': u'未使用',
            'name': 'table_lock_wait_timeout',
            'values': ( { 'default': '50',
                          'maximum': '1073741824',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 0, 10),),
                          ((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)),
                          ((5, 5, 3), (6, 0, 14)))},
          { 'caption': 'sync-bdb-logs',
            'deprecated': None,
            'description': u'BerkeleyDBログを動機的にFLUSHする。デフォルトで有効',
            'disabledby': 'skip-sync-bdb-logs',
            'name': 'sync-bdb-logs',
            'values': ( { 'default': 'true',
                          'off': 'disabledby',
                          'on': 'true',
                          'type': 'boolean'},),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'lc-messages-dir',
            'description': u'エラーメッセージのディレクトリ',
            'name': 'lc-messages-dir',
            'values': ({ 'type': 'dirname'},),
            'versions': (((6, 0, 14),), ((5, 5), (5, 6), (6, 0)), ())},
          { 'caption': 'backup_history_log_file',
            'description': u'MySQLバックアップ履歴ログファイルの名前',
            'name': 'backup_history_log_file',
            'values': ( { 'default': 'backup_history.log',
                          'type': 'filename'},),
            'versions': (((6, 0, 8),), ((5, 6), (6, 0)), ())},
          { 'caption': 'warnings',
            'deprecated': (5, 0),
            'description': u'非推奨。代わりに--log-warningsを使ってください',
            'name': 'warnings',
            'values': ( { 'bitsize': '32',
                          'default': '1',
                          'maximum': '4294967295',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'bitsize': '64',
                          'default': '1',
                          'maximum': '18446744073709547520',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': ((), ((4, 1), (5, 0)), ())},
          { 'caption': 'secure-backup-file-priv',
            'description': u'１つのディレクトリにのみBACKUP DATABASEとRESTOREを許可する',
            'name': 'secure-backup-file-priv',
            'values': ({ 'type': 'string'},),
            'versions': (((6, 1, 11),), ((5, 6), (6, 0)), ())},
          { 'caption': 'lock_wait_timeout',
            'description': u'メタデータロックのタイムアウト',
            'name': 'lock_wait_timeout',
            'values': ( { 'default': '31536000',
                          'maximum': '31536000',
                          'minimum': '1',
                          'type': 'numeric'},),
            'versions': ( ((5, 5, 3), (6, 0, 14)),
                          ((5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'slave_type_conversions',
            'description': u'レプリケーションスレーブの型変換を制御する。値は0以上のALL_LOSSYとALL_NON_LOSSYのlistである。マスタ-スレーブ間で型変換を行わないようにするには空文字列を指定してください',
            'name': 'slave_type_conversions',
            'values': ( { 'choice': [ 'ALL_LOSSY',
                                      'ALL_NON_LOSSY',
                                      'ALL_LOSSY,ALL_NON_LOSSY'],
                          'default': '',
                          'type': 'set'},),
            'versions': ( ((5, 1, 44), (5, 5, 3), (6, 0, 14)),
                          ((5, 1), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'backupdir',
            'description': u'デフォルトのバックアップイメージファイルディレクトリ',
            'name': 'backupdir',
            'values': ({ 'type': 'filename'},),
            'versions': (((6, 0, 7),), ((5, 6), (6, 0)), ())},
          { 'caption': 'bootstrap',
            'description': u'mysqlインストールスクリプトで利用',
            'name': 'bootstrap',
            'values': (),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'time_zone',
            'description': u'現在のタイムゾーン',
            'name': 'time_zone',
            'optype': { 'format': 'default_time_zone'},
            'values': ({ 'type': 'string'},),
            'versions': ( (),
                          ( (4, 1),
                            (5, 0),
                            (5, 1),
                            (5, 4),
                            (5, 5),
                            (5, 6),
                            (6, 0)),
                          ())},
          { 'caption': 'event-scheduler',
            'description': u'イベントスケジュラを有効／無効にする。この設定及び値は、MySQL 5.1.11及び5.1.12で大幅に変わりました',
            'name': 'event-scheduler',
            'values': ( { 'choice': ['ON', 'OFF', 'DISABLED'],
                          'default': 'OFF',
                          'type': 'dropdownbox'},),
            'versions': ( ((5, 1, 6),),
                          ((5, 1), (5, 4), (5, 5), (5, 6), (6, 0)),
                          ())},
          { 'caption': 'record_buffer',
            'deprecated': (4, 0, 3),
            'description': u'read_buffer_sizeのアリアス',
            'name': 'record_buffer',
            'optype': { 'outversion': '4.0.3'},
            'values': ( { 'default': '131072',
                          'maximum': '4294967295',
                          'minimum': '8200',
                          'type': 'numeric'},),
            'versions': ((), (), ())},
          { 'caption': 'mysql-backup',
            'description': u'MySQLバックアップ機能を有効にする',
            'name': 'mysql-backup',
            'values': (),
            'versions': (((6, 0, 14),), ((5, 6), (6, 0)), ())},
          { 'caption': 'optimizer_join_cache_level',
            'description': u'JOINバッファの使い方',
            'name': 'optimizer_join_cache_level',
            'values': ( { 'default': '4',
                          'maximum': '4',
                          'minimum': '0',
                          'type': 'numeric'},
                        { 'default': '1',
                          'inversion': '6.0.14',
                          'maximum': '8',
                          'minimum': '0',
                          'type': 'numeric'}),
            'versions': (((5, 6, 1), (6, 0, 14)), ((5, 6), (6, 0)), ())},
          { 'caption': 'set-variable',
            'deprecated': (5, 0),
            'description': u'変数の値を変更する（非推奨）',
            'name': 'set-variable',
            'values': ({ 'type': 'string'},),
            'versions': ((), ((4, 1), (5, 0)), ())})),)))
