#coding: UTF-8

# Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; version 2 of the
# License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301  USA

class Option:
  def __init__(self, var, versions, description):
    self.var = var
    self.versions = versions
    self.description = description

  def __repr__(self):
    s = []
    for attr in dir(self):
      if attr[0] == '_':
        continue
      else:
        s.append("'" + attr + "':" + str(getattr(self, attr)))
    return '(' + (','.join(s)) + ')'



vars_list = {
'status' : {
     'Binlog' : (
        Option(var='Binlog_cache_disk_use' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 一時バイナリログキャッシュの代わりに一時ファイルを使うトランザクションの数 ')
       ,Option(var='Binlog_cache_use' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 一時バイナリログキャッシュを使うトランザクションの数 ')
       ,Option(var='Com_show_binlog_events' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW BINLOG EVENTS文の数 ')
       ,Option(var='Com_show_binlogs' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW BINLOGS文の数 ')
     ) # End of section Binlog
     ,'Replication' : (
        Option(var='Com_change_master' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' CHANGE MASTER文の数 ')
       ,Option(var='Com_load_master_data' ,versions=((4, 1),) ,description=u' LOAD MASTER DATA文の数 ')
       ,Option(var='Com_load_master_table' ,versions=((4, 1),) ,description=u' LOAD MASTER TABLE文の数 ')
       ,Option(var='Com_show_master_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW MASTER STATUS文の数 ')
       ,Option(var='Com_show_new_master' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW NEW MASTER文の数 ')
       ,Option(var='Com_show_slave_hosts' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW SLAVE HOSTS文の数 ')
       ,Option(var='Com_show_slave_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW SLAVE STATUS文の数 ')
       ,Option(var='Com_slave_start' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SLAVE START文の数 ')
       ,Option(var='Com_slave_stop' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SLAVE STOP文の数 ')
       ,Option(var='Rpl_semi_sync_master_clients' ,versions=((5, 5), (6, 0, 8)) ,description=u' セミ同期スレーブの数 ')
       ,Option(var='Rpl_semi_sync_master_net_avg_wait_time' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_net_wait_time' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_net_waits' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_no_times' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_no_tx' ,versions=((5, 5), (6, 0, 8)) ,description=u' 正常に処理できなかったコミットの回数 ')
       ,Option(var='Rpl_semi_sync_master_status' ,versions=((5, 5), (6, 0, 8)) ,description=u'セミ同期レプリケーションがマスタに適用するか')
       ,Option(var='Rpl_semi_sync_master_timefunc_failures' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_tx_avg_wait_time' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_tx_wait_time' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_tx_waits' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_wait_pos_backtraverse' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_wait_sessions' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='Rpl_semi_sync_master_yes_tx' ,versions=((5, 5), (6, 0, 8)) ,description=u' 正常に終了したコミットの回数 ')
       ,Option(var='Rpl_semi_sync_slave_status' ,versions=((5, 5), (6, 0, 8)) ,description=u'セミ同期レプリケーションがスレーブに適用するか')
       ,Option(var='Rpl_status' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' フェイルセーフレプリケーションの状態（未実装） ')
       ,Option(var='Slave_heartbeat_period' ,versions=((5, 1, 22), (5, 5), (6, 0, 4)) ,description=u' レプリケーションのスレーブのハートビートカンカン（秒） ')
       ,Option(var='Slave_open_temp_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' スレーブSQLスレッドは現在開いている作業用テーブルの数 ')
       ,Option(var='Slave_received_heartbeats' ,versions=((5, 1, 22), (5, 5), (6, 0, 4)) ,description=u' 前回のリセットからレプリケーションのスレーブが受けたハートビートの回数 ')
       ,Option(var='Slave_retried_transactions' ,versions=((5, 0, 4), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' サーバが起動してからレプリケーションSQLスレッドがトランザクションを試した合計回数 ')
       ,Option(var='Slave_running' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' レプリケーションスレーブとしてのこのサーバの状態（スレーブI／Oスレッド状態） ')
     ) # End of section Replication
     ,'Ndb' : (
        Option(var='Handler_discover' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' テーブルが発見された回数 ')
       ,Option(var='Ndb_cluster_connection_pool' ,versions=((5, 1, 19),) ,description=u' クラスタするMySQL接続の数 ')
       ,Option(var='Ndb_cluster_node_id' ,versions=((5, 0), (5, 1), (6, 0)) ,description=u' サーバがMySQLクラスタノードの場合、クラスタノードのID ')
       ,Option(var='Ndb_cluster_node_id' ,versions=((5, 0, 45), (5, 1, 15)) ,description=u' このMySQLサーバのMySQLクラスタノードID ')
       ,Option(var='Ndb_config_from_host' ,versions=((5, 0, 23), (5, 1, 12), (6, 0)) ,description=u' The host name or IP address of the Cluster management server. Formerly Ndb_connected_host ')
       ,Option(var='Ndb_config_from_port' ,versions=((5, 0, 23), (5, 1, 12), (6, 0)) ,description=u' The port for connecting to the Cluster management server. Formerly Ndb_connected_port ')
       ,Option(var='Ndb_conflict_fn_max' ,versions=((5, 1, 22), (5, 4), (5, 5), (6, 0)) ,description=u' If the server is part of a MySQL Cluster involved in cluster replication, the value of this variable indicates the number of times that conflict resolution based on "greater timestamp wins" has been applied ')
       ,Option(var='Ndb_conflict_fn_old' ,versions=((5, 1, 22), (5, 4), (5, 5), (6, 0)) ,description=u' If the server is part of a MySQL Cluster involved in cluster replication, the value of this variable indicates the number of times that "same timestamp wins" conflict resolution has been applied ')
       ,Option(var='Ndb_execute_count' ,versions=((5, 1, 22),) ,description=u' Provides the number of round trips to the NDB kernel made by operations ')
       ,Option(var='Ndb_number_of_data_nodes' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=u' If the server is part of a MySQL Cluster, the value of this variable is the number of data nodes in the cluster ')
       ,Option(var='Ndb_pruned_scan_count' ,versions=((5, 1, 32), (5, 1, 32)) ,description=u' The number of scans executed by NDB since the cluster was last started where partition pruning could be used ')
       ,Option(var='Ndb_scan_count' ,versions=((5, 1, 32), (5, 1, 32)) ,description=u' The total number of scans executed by NDB since the cluster was last started ')
     ) # End of section Ndb
     ,'Server' : (
        Option(var='Aborted_clients' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' クライアントが正常に接続を終了しなかったために中断した接続の数 ')
       ,Option(var='Aborted_connects' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' MySQLサーバ接続の失敗数 ')
       ,Option(var='Bytes_received' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' すべてのクライアントから受信したバイト量 ')
       ,Option(var='Bytes_sent' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' すべてのクライアントに送信にバイト量 ')
       ,Option(var='Com_admin_commands' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' アドミンコマンドの数 ')
       ,Option(var='Com_alter_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ALTER DATABASE文の数 ')
       ,Option(var='Com_alter_db_upgrade' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_alter_db_upgrade ')
       ,Option(var='Com_alter_event' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ALTER EVENT文の数 ')
       ,Option(var='Com_alter_function' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ALTER FUNCTION文の数 ')
       ,Option(var='Com_alter_procedure' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_alter_procedure ')
       ,Option(var='Com_alter_server' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_alter_server ')
       ,Option(var='Com_alter_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ALTER TABLE文の数 ')
       ,Option(var='Com_alter_tablespace' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_alter_tablespace ')
       ,Option(var='Com_analyze' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ANALYZE 文の数 ')
       ,Option(var='Com_assign_to_keycache' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_assign_to_keycache ')
       ,Option(var='Com_backup' ,versions=((6, 0),) ,description=u' BACKUP DATABASE文の数 ')
       ,Option(var='Com_backup_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' BACKUP TABLE文の数 ')
       ,Option(var='Com_begin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' BEGIN文の数 ')
       ,Option(var='Com_binlog' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_binlog ')
       ,Option(var='Com_call_procedure' ,versions=((5, 0, 44), (5, 1, 19), (5, 4), (5, 5), (6, 0)) ,description=u' ストアプロシージャの呼び出し回数 ')
       ,Option(var='Com_change_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' CHANGE DATABASEの数 ')
       ,Option(var='Com_check' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' CHECK文の数 ')
       ,Option(var='Com_checksum' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' CHECKSUM文の数 ')
       ,Option(var='Com_commit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' COMMIT文の数 ')
       ,Option(var='Com_create_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' CREATE DATABASE文の数 ')
       ,Option(var='Com_create_event' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' CREATE EVENT文の数 ')
       ,Option(var='Com_create_function' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' CREATE FUNCTION文の数 ')
       ,Option(var='Com_create_index' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' CREATE INDEX文の数 ')
       ,Option(var='Com_create_procedure' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_create_procedure ')
       ,Option(var='Com_create_server' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_create_server ')
       ,Option(var='Com_create_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' CREATE TABLE文の数 ')
       ,Option(var='Com_create_trigger' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_create_trigger ')
       ,Option(var='Com_create_udf' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_create_udf ')
       ,Option(var='Com_create_user' ,versions=((5, 0, 30), (5, 1), (5, 4), (6, 0)) ,description=u' CREATE USER文の数 ')
       ,Option(var='Com_create_view' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_create_view ')
       ,Option(var='Com_dealloc_sql' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DEALLOCATE PREPARE文の数 ')
       ,Option(var='Com_delete' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DELETE文の数 ')
       ,Option(var='Com_delete_multi' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 複数のテーブルDELETE文の数 ')
       ,Option(var='Com_do' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DO文の数 ')
       ,Option(var='Com_drop_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DROP DATABASE文の数 ')
       ,Option(var='Com_drop_event' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DROP EVENT文の数  ')
       ,Option(var='Com_drop_function' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DROP FUNCTION文の数 ')
       ,Option(var='Com_drop_index' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DROP INDEX文の数 ')
       ,Option(var='Com_drop_procedure' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_drop_procedure ')
       ,Option(var='Com_drop_server' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_drop_server ')
       ,Option(var='Com_drop_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DROP TABLE文の数 ')
       ,Option(var='Com_drop_trigger' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_drop_trigger ')
       ,Option(var='Com_drop_user' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DROP USER文の数 ')
       ,Option(var='Com_drop_view' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_drop_view ')
       ,Option(var='Com_empty_query' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_empty_query ')
       ,Option(var='Com_execute_sql' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' EXECUTE文の数 ')
       ,Option(var='Com_flush' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' FLUSH文の数 ')
       ,Option(var='Com_grant' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' GRANT文の数 ')
       ,Option(var='Com_ha_close' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' HANDLER CLOSE文の数 ')
       ,Option(var='Com_ha_open' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' HANDLER OPEN文の数 ')
       ,Option(var='Com_ha_read' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' HANDLER READ文の数 ')
       ,Option(var='Com_help' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' HELP文の数 ')
       ,Option(var='Com_insert' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' INSERT文の数 ')
       ,Option(var='Com_insert_select' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' INSERT SELECT文の数 ')
       ,Option(var='Com_install_plugin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_install_plugin ')
       ,Option(var='Com_kill' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' KILL文の数 ')
       ,Option(var='Com_load' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' LOAD文の数 ')
       ,Option(var='Com_load_master_data' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_load_master_data ')
       ,Option(var='Com_load_master_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_load_master_table ')
       ,Option(var='Com_lock_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' LOCK TABLES文の数 ')
       ,Option(var='Com_optimize' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' OPTIMIZE文の数 ')
       ,Option(var='Com_preload_keys' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' PRELOAD KEYS文の数 ')
       ,Option(var='Com_prepare_sql' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' PREPARE文の数 ')
       ,Option(var='Com_purge' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' PURGE文の数 ')
       ,Option(var='Com_purge_before_date' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' PURGE BEFORE DATE文の数 ')
       ,Option(var='Com_release_savepoint' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_release_savepoint ')
       ,Option(var='Com_rename_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' RENAME TABLE文の数 ')
       ,Option(var='Com_rename_user' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_rename_user ')
       ,Option(var='Com_repair' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' REPAIR文の数 ')
       ,Option(var='Com_replace' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' REPLACE文の数 ')
       ,Option(var='Com_replace_select' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' REPLACE SELECT文の数 ')
       ,Option(var='Com_reset' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' RESET文の数 ')
       ,Option(var='Com_restore' ,versions=((6, 0),) ,description=u' RESTORE DATABASE文の数 ')
       ,Option(var='Com_restore_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' RESTORE TABLE文の数 ')
       ,Option(var='Com_revoke' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' REVOKE文の数 ')
       ,Option(var='Com_revoke_all' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' REVOKE ALL文の数 ')
       ,Option(var='Com_rollback' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ROLLBACK文の数 ')
       ,Option(var='Com_rollback_to_savepoint' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_rollback_to_savepoint ')
       ,Option(var='Com_savepoint' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SAVEPOINT文の数 ')
       ,Option(var='Com_select' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SELECT文の数 ')
       ,Option(var='Com_set_option' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SET OPTION文の数 ')
       ,Option(var='Com_show_authors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_show_authors ')
       ,Option(var='Com_show_charsets' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW CHARSET文の数 ')
       ,Option(var='Com_show_collations' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW COLLATION文の数 ')
       ,Option(var='Com_show_column_types' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW COLUMN TYPES文の数 ')
       ,Option(var='Com_show_contributors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_show_contributors ')
       ,Option(var='Com_show_create_db' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW CREATE DATABASE文の数 ')
       ,Option(var='Com_show_create_event' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW CREATE EVENT文の数 ')
       ,Option(var='Com_show_create_func' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_show_create_func ')
       ,Option(var='Com_show_create_proc' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_show_create_proc ')
       ,Option(var='Com_show_create_table' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW CREATE TABLE文の数 ')
       ,Option(var='Com_show_create_trigger' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_show_create_trigger ')
       ,Option(var='Com_show_databases' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW DATABASES文の数 ')
       ,Option(var='Com_show_engine_logs' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW ENGINE LOGS文の数 ')
       ,Option(var='Com_show_engine_mutex' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW ENGINE MUTEX文の数 ')
       ,Option(var='Com_show_engine_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW ENGINE STATUS文の数 ')
       ,Option(var='Com_show_errors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW ERRORS文の数 ')
       ,Option(var='Com_show_events' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW EVENTS文の数 ')
       ,Option(var='Com_show_fields' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW FIELDS文の数 ')
       ,Option(var='Com_show_function_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_show_function_status ')
       ,Option(var='Com_show_grants' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW GRANTS文の数 ')
       ,Option(var='Com_show_keys' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW KEYS文の数 ')
       ,Option(var='Com_show_logs' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW LOGS文の数 ')
       ,Option(var='Com_show_open_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW OPEN TABLES文の数 ')
       ,Option(var='Com_show_plugins' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW PLUGINS文の数 ')
       ,Option(var='Com_show_privileges' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW PRIVILEGES文の数 ')
       ,Option(var='Com_show_procedure_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_show_procedure_status ')
       ,Option(var='Com_show_processlist' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW PROCESSLIST文の数 ')
       ,Option(var='Com_show_profile' ,versions=((5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=u' SHOW PROFILE文の数 ')
       ,Option(var='Com_show_profiles' ,versions=((5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=u' SHOW PROFILES文の数 ')
       ,Option(var='Com_show_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW STATUS文の数 ')
       ,Option(var='Com_show_storage_engines' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW STORAGE ENGINES文の数 ')
       ,Option(var='Com_show_table_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_show_table_status ')
       ,Option(var='Com_show_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW TABLES文の数 ')
       ,Option(var='Com_show_triggers' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW TRIGGERS文の数 ')
       ,Option(var='Com_show_variables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW VARIABLES文の数 ')
       ,Option(var='Com_show_warnings' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW WARNINGS文の数 ')
       ,Option(var='Com_stmt_close' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' STATEMENT CLOSE文の数 ')
       ,Option(var='Com_stmt_execute' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' STATEMENT EXECUTE文の数 ')
       ,Option(var='Com_stmt_fetch' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' STATEMENT FETCH文の数 ')
       ,Option(var='Com_stmt_prepare' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' STATEMENT PREPARE文の数 ')
       ,Option(var='Com_stmt_reprepare' ,versions=((5, 1, 25), (5, 4), (5, 5), (6, 0, 6)) ,description=u' 自動的にプリペア文を再プリペアする ')
       ,Option(var='Com_stmt_reset' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' STATEMENT RESET文の数 ')
       ,Option(var='Com_stmt_send_long_data' ,versions=((4, 1, 13), (5, 0, 8), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' STATEMENT SEND LONG DATA文の数 ')
       ,Option(var='Com_truncate' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' TRUNCATE文の数 ')
       ,Option(var='Com_uninstall_plugin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Com_uninstall_plugin ')
       ,Option(var='Com_unlock_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' UNLOCK TABLES文の数 ')
       ,Option(var='Com_update' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' UPDATE文の数 ')
       ,Option(var='Com_update_multi' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' multiple UPDATE文の数 ')
       ,Option(var='Com_xa_commit' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' XA COMMIT文の数 ')
       ,Option(var='Com_xa_end' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' XA END文の数 ')
       ,Option(var='Com_xa_prepare' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' XA PREPARE文の数 ')
       ,Option(var='Com_xa_recover' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' XA RECOVER文の数  ')
       ,Option(var='Com_xa_rollback' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' XA ROLLBACK文の数 ')
       ,Option(var='Com_xa_start' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' XA START文の数 ')
       ,Option(var='Compression' ,versions=((5, 0, 16), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' クライアントが圧縮クライアント/サーバプロトコルを使用しているか ')
       ,Option(var='Connections' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 試した接続の回数 ')
       ,Option(var='Created_tmp_disk_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' サーバが実行中に自動的にディスクに書き込んだ作業テーブルの数 ')
       ,Option(var='Created_tmp_files' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' mysqldが作成した作業ファイルの数 ')
       ,Option(var='Created_tmp_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' mysqldが作成された作業用テーブルの数 ')
       ,Option(var='Delayed_errors' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' INSERT DELAYEDで書かれて、エラーが発生した行数 ')
       ,Option(var='Delayed_insert_threads' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 使われているINSERT DELAYEDスレッドの数 ')
       ,Option(var='Delayed_writes' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' INSERT DELAYED行が掛かれた回数 ')
       ,Option(var='Flush_commands' ,versions=((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' FLUSH文が実行された回数 ')
       ,Option(var='Handler_commit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 内部COMMIT文の数 ')
       ,Option(var='Handler_delete' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' テーブルから行が柵状された回数 ')
       ,Option(var='Handler_prepare' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ２フェーズコミット処理の準備フェーズのカウンタ ')
       ,Option(var='Handler_read_first' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 索引の先頭の項目が読まれた回数 ')
       ,Option(var='Handler_read_key' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キーを基に行の読込みが要求された回数 ')
       ,Option(var='Handler_read_next' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キー順の次の行を読み込むリクエストの回数 ')
       ,Option(var='Handler_read_prev' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キー順の前の行を読み込むリクエストの回数 ')
       ,Option(var='Handler_read_rnd' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 固定位置で行を読み込むリクエストの回数 ')
       ,Option(var='Handler_read_rnd_next' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' データファイルの次の行を読み込むリクエストの回数 ')
       ,Option(var='Handler_rollback' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ストレージエンジンにロールバックするためにリクエストの回数 ')
       ,Option(var='Handler_savepoint' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ストレージエンジンにサーブポイントを要求した回数 ')
       ,Option(var='Handler_savepoint_rollback' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ストレージエンジンにサーブポイントまでロールバックするリクエストの回数 ')
       ,Option(var='Handler_update' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' テーブルの行を更新するリクエストの回数 ')
       ,Option(var='Handler_write' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' テーブルに行を挿入するリクエストの回数 ')
       ,Option(var='Key_blocks_not_flushed' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 変更されてまだディスクへフラッシュされていないキーキャッシュのキーブロックの数 ')
       ,Option(var='Key_blocks_unused' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キーキャッシュの未使用のブロック数 ')
       ,Option(var='Key_blocks_used' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キーキャッシュで使用されているブロック数 ')
       ,Option(var='Key_read_requests' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キャッシュからキー母ロックを読むリクエストの回数 ')
       ,Option(var='Key_reads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 物理的にディスクからキーブロックが読み込まれた回数 ')
       ,Option(var='Key_write_requests' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キーブロックをキャッシュに書き込むリクエストの回数 ')
       ,Option(var='Key_writes' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 物理的にキーブロックをディスクから書き込んだ回数 ')
       ,Option(var='Last_query_cost' ,versions=((5, 0, 1), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' クエリーオプタマイザの計算による最後にコンパイルしたクエリーの総合コスト ')
       ,Option(var='Max_used_connections' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' サーバが起動してから最大に同時接続数 ')
       ,Option(var='Not_flushed_delayed_rows' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' INSERT DELAYキューで書込みをまっている行の数 ')
       ,Option(var='Open_files' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 開いているファイルの数 ')
       ,Option(var='Open_streams' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 開いていうるストリームの数（主にログで利用） ')
       ,Option(var='Open_table_definitions' ,versions=((5, 1, 3), (5, 4), (5, 5), (6, 0)) ,description=u' テーブルキャッシュの.frmファイルの数 ')
       ,Option(var='Open_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 開いているテーブルの数 ')
       ,Option(var='Opened_files' ,versions=((5, 1, 21), (5, 4), (5, 5), (6, 0)) ,description=u' my_open()で開かれたファイルの数 ')
       ,Option(var='Opened_table_definitions' ,versions=((5, 1, 24), (5, 4), (5, 5), (6, 0, 4)) ,description=u' キャッシュされた.frmファイルの数 ')
       ,Option(var='Opened_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 開かれたテーブルの数 ')
       ,Option(var='Prepared_stmt_count' ,versions=((4, 1, 23), (5, 0, 32), (5, 1, 14), (5, 4), (6, 0)) ,description=u' 現在のプリペア文の数 ')
       ,Option(var='Qcache_free_blocks' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キューキャッシュのフリーメモリブロックの数 ')
       ,Option(var='Qcache_free_memory' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' クエリーキャッシュ用に使えるメモリ量 ')
       ,Option(var='Qcache_hits' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' クエリーキャッシュヒットの数 ')
       ,Option(var='Qcache_inserts' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' クエリーキャッシュ挿入の数 ')
       ,Option(var='Qcache_lowmem_prunes' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キャッシュのメモリ不足のために、クエリーキャッシュから削除されたクエリーの数 ')
       ,Option(var='Qcache_not_cached' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キャッシュされないクエリーの数（キャッシュできない又はquery_cache_type設定のためにキャッシュされない） ')
       ,Option(var='Qcache_queries_in_cache' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' クエリーキャッシュに登録されたクエリーの数 ')
       ,Option(var='Qcache_total_blocks' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' クエリーキャッシュのブロックの総数 ')
       ,Option(var='Queries' ,versions=((5, 0, 76), (5, 1, 31), (5, 4), (5, 5), (6, 0, 10)) ,description=u' サーバが実行したSQL文の回数 ')
       ,Option(var='Questions' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' クライアントがサーバに送信した文の数 ')
       ,Option(var='Select_full_join' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 索引を使わないために、テーブルスキャンをしたJOINの数 ')
       ,Option(var='Select_full_range_join' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 参照テーブルのレンジ検索を行ったJOINの数 ')
       ,Option(var='Select_range' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 最初のテーブルのレンジを使ったJOINの回数 ')
       ,Option(var='Select_range_check' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 各行の後にキーの利用を確認するキーを使わずにJOINの数 ')
       ,Option(var='Select_scan' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 最初のテーブルに完全スキャンしたJOINの数 ')
       ,Option(var='Slow_launch_threads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 作成するのに slow_launch_time秒以上、掛かったスレッドの数 ')
       ,Option(var='Slow_queries' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' long_query_time（秒）より時間が掛かったクエリーの数 ')
       ,Option(var='Sort_range' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' レンジを使ったソートした回数 ')
       ,Option(var='Sort_rows' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ソート行の数 ')
       ,Option(var='Sort_scan' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' テーブルスキャンでソートした数 ')
       ,Option(var='Ssl_accept_renegotiates' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 接続するために交渉した回数 ')
       ,Option(var='Ssl_accepts' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 許可したSSL接続の回数 ')
       ,Option(var='Ssl_callback_cache_hits' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' コールバックキャッシュヒットの回数 ')
       ,Option(var='Ssl_cipher' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 丸剤のSSL暗号 ')
       ,Option(var='Ssl_cipher_list' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 可能なSSL暗号一覧 ')
       ,Option(var='Ssl_client_connects' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLマスタにSSL接続を試した回数 ')
       ,Option(var='Ssl_connect_renegotiates' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSL対応のマスタに接続を試す回数 ')
       ,Option(var='Ssl_ctx_verify_depth' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLコンテキスト認証の深さ（テストするサーティフィケートの数） ')
       ,Option(var='Ssl_ctx_verify_mode' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLコンテキスト認証モード ')
       ,Option(var='Ssl_default_timeout' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLタイムアウトの既定値 ')
       ,Option(var='Ssl_finished_accepts' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' サーバへ正常に接続したSSL接続の数 ')
       ,Option(var='Ssl_finished_connects' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSL対応のマスタに正常接続したスレーブ接続の数 ')
       ,Option(var='Ssl_session_cache_hits' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLセッションキャッシュヒットの回数 ')
       ,Option(var='Ssl_session_cache_misses' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The SSLセッションキャッシュミスの回数 ')
       ,Option(var='Ssl_session_cache_mode' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLセッションキャッシュモード ')
       ,Option(var='Ssl_session_cache_overflows' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLセッションキャッシュオーバフローの数 ')
       ,Option(var='Ssl_session_cache_size' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLセッションキャッシュの大きさ ')
       ,Option(var='Ssl_session_cache_timeouts' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLセッションタイムアウトの回数 ')
       ,Option(var='Ssl_sessions_reused' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' キャッシュから再利用されたSSL接続数 ')
       ,Option(var='Ssl_used_session_cache_entries' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 使われたSSLセッションキャッシュの数 ')
       ,Option(var='Ssl_verify_depth' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' レプリケーションSSL接続の認証の深さ ')
       ,Option(var='Ssl_verify_mode' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSL接続の認証モード ')
       ,Option(var='Ssl_version' ,versions=((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SSLバージョン番号 ')
       ,Option(var='Table_locks_immediate' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' テーブルロックが即時に取得された回数 ')
       ,Option(var='Table_locks_waited' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' テーブルロックが即時に取得せず、待つ必要があった回数 ')
       ,Option(var='Tc_log_max_pages_used' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ログのメモリマップ実装が、内部XAトランザクション用にmysqldがトランザクションコーディネータを行う場合、このパラメータはサーバが起動してからのログの最大ページ数を示す ')
       ,Option(var='Tc_log_page_size' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' XAリカバリーログのメモリマップ実装のページサイズ ')
       ,Option(var='Tc_log_page_waits' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' リカバリログのメモリマップ実装の、サーバがトランザクションをコミットできずログの空ページを待つ必要があった場合に加算された値 ')
       ,Option(var='Threads_cached' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' スレッドキャッシュにあるスレッド数 ')
       ,Option(var='Threads_connected' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 開いている接続の数 ')
       ,Option(var='Threads_created' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 接続用に作成されたスレッドの数 ')
       ,Option(var='Threads_running' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' スリープしていないスレッドの数 ')
       ,Option(var='Uptime' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' サーバが起動している時間（秒） ')
       ,Option(var='Uptime_since_flush_status' ,versions=((5, 0, 35), (5, 1, 23), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=u' 最後のFLUSH STATUSからの時間（秒） ')
     ) # End of section Server
     ,'Merge' : (
        Option(var='Sort_merge_passes' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ソートアルゴリズムが行う必要があるマージの回数 ')
        ,     ) # End of section Merge
     ,'Innodb' : (
        Option(var='Com_show_innodb_status' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' SHOW INNODB STATUS文の数 ')
       ,Option(var='Com_show_ndb_status' ,versions=((4, 1), (5, 0), (5, 1), (6, 0)) ,description=u' SHOW NDB STATUS文の数 ')
       ,Option(var='Innodb_buffer_pool_pages_data' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' データがあるページ数（ダーティとクリーン） ')
       ,Option(var='Innodb_buffer_pool_pages_dirty' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ダーティページの数 ')
       ,Option(var='Innodb_buffer_pool_pages_flushed' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' バッファページのpage-flushリクエスト数 ')
       ,Option(var='Innodb_buffer_pool_pages_free' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 空いているバッファプールページの数 ')
       ,Option(var='Innodb_buffer_pool_pages_latched' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBバッファプールにあるラッチページの数 ')
       ,Option(var='Innodb_buffer_pool_pages_misc' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 管理用に割り当てられたため、ビジーなページの数 ')
       ,Option(var='Innodb_buffer_pool_pages_total' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ページの総合バッファプールサイズ ')
       ,Option(var='Innodb_buffer_pool_read_ahead' ,versions=((5, 1, 42), (5, 5)) ,description=u' InnoDB read-aheadスレッドが読み込んだページ数 ')
       ,Option(var='Innodb_buffer_pool_read_ahead_evicted' ,versions=((5, 1, 42), (5, 5)) ,description=u' アクセスされずに捨てられた先行読込みページの数 ')
       ,Option(var='Innodb_buffer_pool_read_ahead_rnd' ,versions=((5, 0, 2), (5, 1), (5, 4), (6, 0)) ,description=u' InnoDBが起こした，即時先行呼び読込みの回数 ')
       ,Option(var='Innodb_buffer_pool_read_ahead_seq' ,versions=((5, 0, 2), (5, 1), (5, 4), (6, 0)) ,description=u' InnoDBが起こした、シーケンシャルア先行読込みの回数 ')
       ,Option(var='Innodb_buffer_pool_read_requests' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnDBが行った論理読込みリクエストの回数 ')
       ,Option(var='Innodb_buffer_pool_reads' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBがバッファプールから行えなく、１ページから行った論理読込みの回数 ')
       ,Option(var='Innodb_buffer_pool_wait_free' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ページをフラッシュするために待った回数 ')
       ,Option(var='Innodb_buffer_pool_write_requests' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' バッファプールに書き込んだ回数 ')
       ,Option(var='Innodb_data_fsyncs' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 実行されたfsync()処理の回数 ')
       ,Option(var='Innodb_data_pending_fsyncs' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 保留されているfsync()処理の回数 ')
       ,Option(var='Innodb_data_pending_reads' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 保留されている読込み回数 ')
       ,Option(var='Innodb_data_pending_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 保留されている書込み回数 ')
       ,Option(var='Innodb_data_read' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 読み込んだデータ量（バイト） ')
       ,Option(var='Innodb_data_reads' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' データ読込みご合計 ')
       ,Option(var='Innodb_data_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' データ書き込むの合計 ')
       ,Option(var='Innodb_data_written' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 書き込んだデータの量（バイト） ')
       ,Option(var='Innodb_dblwr_pages_written' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 二書き込まれた重書き込みページの回数 ')
       ,Option(var='Innodb_dblwr_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 実行された二重書込みの回数 ')
       ,Option(var='Innodb_have_atomic_builtins' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' アトミック命令が使えるか ')
       ,Option(var='Innodb_have_sync_atomic' ,versions=((5, 4),) ,description=u' アトミック命令が使えるか ')
       ,Option(var='Innodb_heap_enabled' ,versions=((5, 4),) ,description=u' InnoDBメモリヒープが有効か ')
       ,Option(var='Innodb_log_waits' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ログファイルが小さすぎてフラッシュがされるまだ待った回数 ')
       ,Option(var='Innodb_log_write_requests' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ログ書込みのリクエスト回数 ')
       ,Option(var='Innodb_log_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ログファイルに物理書込みの回数 ')
       ,Option(var='Innodb_os_log_fsyncs' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ログファイルにfsync()書込みを行った回数 ')
       ,Option(var='Innodb_os_log_pending_fsyncs' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 保留されているログファイルのfsync()処理の回数 ')
       ,Option(var='Innodb_os_log_pending_writes' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 保留さらえているログファイルの書込み回数 ')
       ,Option(var='Innodb_os_log_written' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ログファイルに書き込んだバイト数 ')
       ,Option(var='Innodb_page_size' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' compiled-in InnoDBページのサイズ ')
       ,Option(var='Innodb_pages_created' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 作成されたページ数 ')
       ,Option(var='Innodb_pages_read' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 読み込んだページ数 ')
       ,Option(var='Innodb_pages_written' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 書き込んだページ数 ')
       ,Option(var='Innodb_row_lock_current_waits' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 現在、待っている行ロックの数 ')
       ,Option(var='Innodb_row_lock_time' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 行排他を取得するための合計時間（ミリ秒） ')
       ,Option(var='Innodb_row_lock_time_avg' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 行排他を取得するまでの平均時間（ミリ秒） ')
       ,Option(var='Innodb_row_lock_time_max' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 行の排他を取得するまでの最大時間（ミリ秒） ')
       ,Option(var='Innodb_row_lock_waits' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 行排他のために待たされた回数 ')
       ,Option(var='Innodb_rows_deleted' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBテーブルから削除された行数 ')
       ,Option(var='Innodb_rows_inserted' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBテーブルに挿入した行数 ')
       ,Option(var='Innodb_rows_read' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBテーブルから読み込んだ行数 ')
       ,Option(var='Innodb_rows_updated' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBテーブルで更新された行数 ')
       ,Option(var='Innodb_wake_ups' ,versions=((5, 4),) ,description=u' 起こることがないウェークアップの回数 ')
     ) # End of section Innodb
   } # End of class status
 ,'system' : {
     'General' : (
        Option(var='engine_condition_pushdown' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 対応したクエリー条件をストレージエンジンにプッシュする ')
       ,Option(var='falcon_support_xa' ,versions=((6, 0, 4),) ,description=u' Falconテーブルの２フェーズコミットを有効にする ')
       ,Option(var='rand_seed1' ,versions=((4, 0, 5), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Used to support replication of the RAND() function ')
       ,Option(var='rand_seed2' ,versions=((4, 0, 5), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Used to support replication of the RAND() function ')
       ,Option(var='sync_master_info' ,versions=((5, 5), (6, 0, 11)) ,description=u' Synchronize master.info to disk after every #th event. ')
       ,Option(var='sync_relay_log' ,versions=((5, 5), (6, 0, 10)) ,description=u' Synchronize relay log to disk after every #th event. ')
       ,Option(var='sync_relay_log_info' ,versions=((5, 5), (6, 0, 11)) ,description=u' Synchronize relay.info file to disk after every #th event. ')
       ,Option(var='transaction_allow_batching' ,versions=((5, 1, 23),) ,description=u' Allows batching of statements within a transaction. ')
     ) # End of section General
     ,'Binlog' : (
        Option(var='binlog_cache_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' The size of the cache to hold the SQL statements for the binary log during a transaction ')
       ,Option(var='binlog_format' ,versions=((5, 1, 5), (5, 4), (5, 5), (6, 0)) ,description=' Specifies the format of the binary log ')
       ,Option(var='max_binlog_cache_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Can be used to restrict the total size used to cache a multi-transaction query ')
       ,Option(var='max_binlog_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=' Binary log will be rotated automatically when the size exceeds this value ')
     ) # End of section Binlog
     ,'Isam' : (
        Option(var='isam' ,versions=((4, 1),) ,description=' Obsolete. ISAM storage engine is no longer supported ')
       ,Option(var='skip-isam' ,versions=((4, 1, 1),) ,description=' Disable the ISAM storage engine ')
     ) # End of section Isam
     ,'Ssl' : (
        Option(var='have_openssl' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=' Whether mysqld supports SSL connections ')
       ,Option(var='have_ssl' ,versions=((5, 0, 38), (5, 1, 17), (5, 4), (6, 0)) ,description=' Whether mysqld supports SSL connections ')
       ,Option(var='ssl_ca' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' CA file in PEM format (check OpenSSL docs, implies --ssl) ')
       ,Option(var='ssl_capath' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' CA directory (check OpenSSL docs, implies --ssl) ')
       ,Option(var='ssl_cert' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' X509 cert in PEM format (implies --ssl) ')
       ,Option(var='ssl_cipher' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' SSL cipher to use (implies --ssl) ')
       ,Option(var='ssl_key' ,versions=((4, 0), (4, 1), (5, 0, 23), (5, 1, 11), (5, 4), (5, 5), (6, 0)) ,description=' X509 key in PEM format (implies --ssl) ')
     ) # End of section Ssl
     ,'Bdb' : (
        Option(var='bdb-data-direct' ,versions=((5, 1, 4),) ,description=u' bdb-data-direct ')
       ,Option(var='bdb-lock-detect' ,versions=((4, 1), (5, 0)) ,description=u' Berkeley DB排他感知 ')
       ,Option(var='bdb-log-direct' ,versions=((5, 1, 4),) ,description=u' bdb-log-direct ')
       ,Option(var='bdb-shared-data' ,versions=((4, 1), (5, 0)) ,description=u' Berkeley DBをマルチプロセスモードで起動 ')
       ,Option(var='bdb-tmpdir' ,versions=((4, 1), (5, 0)) ,description=u' Berkeley DB作業ファイル名 ')
       ,Option(var='bdb_cache_size' ,versions=((4, 1), (5, 0)) ,description=u' The buffer that is allocated to cache index and rows for BDB tables ')
       ,Option(var='bdb_home' ,versions=((4, 1), (5, 0)) ,description=u' Berkeley DBホームディレクトリ ')
       ,Option(var='bdb_log_buffer_size' ,versions=((4, 1), (5, 0)) ,description=u' BDBテーブルの索引と行をキャッシュするために割り当てられたバッファの大きさ ')
       ,Option(var='bdb_logdir' ,versions=((4, 1), (5, 0)) ,description=u' Berkeley DBログファイルディレクトリ ')
       ,Option(var='bdb_max_lock' ,versions=((4, 1), (5, 0)) ,description=u' The maximum number of locks that can be active for a BDB table ')
       ,Option(var='have_bdb' ,versions=((4, 1), (5, 0)) ,description=u' Berkeley DB対応か ')
       ,Option(var='skip-sync-bdb-logs' ,versions=((4, 1), (5, 0)) ,description=u' Disables synchronous BDB log flushes ')
       ,Option(var='sync_bdb_logs' ,versions=((4, 1), (5, 0)) ,description=u' Synchronously flush Berkeley DB logs. Enabled by default ')
     ) # End of section Bdb
     ,'Ndb' : (
        Option(var='have_ndbcluster' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Whether mysqld supports NDB Cluster tables (set by --ndbcluster option) ')
       ,Option(var='ndb-wait-setup' ,versions=((5, 1, 39), (5, 1, 39), (5, 1, 39)) ,description=u' Time (in seconds) for the MySQL server to wait for NDB engine setup to complete. ')
       ,Option(var='ndb_autoincrement_prefetch_sz' ,versions=((4, 1, 8), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' NDB auto-increment prefetch size ')
       ,Option(var='ndb_batch_size' ,versions=((5, 1, 23),) ,description=u' The size (in bytes) to use for NDB transaction batches ')
       ,Option(var='ndb_cache_check_time' ,versions=((4, 1), (5, 0), (5, 1)) ,description=u' The number of milliseconds between checks of cluster SQL nodes made by the MySQL query cache ')
       ,Option(var='ndb_extra_logging' ,versions=((5, 1, 6),) ,description=u' Controls logging of MySQL Cluster schema, connection, and data distribution events in the MySQL error log ')
       ,Option(var='ndb_force_send' ,versions=((4, 1, 8), (5, 0), (5, 1)) ,description=u' Forces sending of buffers to NDB immediately, without waiting for other threads ')
       ,Option(var='ndb_log_empty_epochs' ,versions=((5, 1, 31), (5, 1, 31)) ,description=u' When used, causes epochs in which there were no changes to be written to the ndb_apply_status and ndb_binlog_index tables even when --log-slave-updates is enabled. ')
       ,Option(var='ndb_log_orig' ,versions=((5, 1, 22),) ,description=u' Log originating server id and epoch in mysql.ndb_binlog_index table. ')
       ,Option(var='ndb_log_update_as_write' ,versions=((5, 1, 19), (5, 1, 22)) ,description=u' Toggles logging of updates on the master between updates (OFF) and writes (ON) ')
       ,Option(var='ndb_log_updated_only' ,versions=((5, 1, 19),) ,description=u' Log complete rows (ON) or updates only (OFF) ')
       ,Option(var='ndb_optimization_delay' ,versions=((5, 1, 23),) ,description=u' Sets the number of milliseconds to wait between processing sets of rows by OPTIMIZE TABLE on NDB tables. ')
       ,Option(var='ndb_table_no_logging' ,versions=((5, 1, 23),) ,description=u' NDB tables are not checkpointed to disk (although table schema files are created) ')
       ,Option(var='ndb_table_temporary' ,versions=((5, 1, 23),) ,description=u' NDB tables are not persistent on disk: no schema files are created and the tables are not logged ')
       ,Option(var='ndb_use_copying_alter_table' ,versions=((5, 1, 12),) ,description=u' Use copying ALTER TABLE operations in MySQL Cluster ')
       ,Option(var='ndb_use_exact_count' ,versions=((4, 1, 8), (5, 0), (5, 1)) ,description=u' Use exact row count when planning queries ')
       ,Option(var='ndb_use_transactions' ,versions=((4, 1, 18), (5, 0), (5, 1), (6, 0)) ,description=u' Forces NDB to use a count of records during SELECT COUNT(*) query planning to speed up this type of query ')
       ,Option(var='ndb_wait_connected' ,versions=((5, 1, 16),) ,description=u' Time (in seconds) for the MySQL server to wait for connection to cluster management and data nodes before accepting MySQL client connections. ')
       ,Option(var='slave-allow-batching' ,versions=((5, 1, 19),) ,description=u' Turns update batching on and off for a replication slave ')
     ) # End of section Ndb
     ,'Server' : (
        Option(var='auto_increment_increment' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' AUTO_INCREMENT columns are incremented by this value ')
       ,Option(var='auto_increment_offset' ,versions=((5, 0, 2), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Offset added to AUTO_INCREMENT columns ')
       ,Option(var='autocommit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Sets the autocommit mode ')
       ,Option(var='back_log' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The number of outstanding connection requests MySQL can have ')
       ,Option(var='backup_history_log' ,versions=((5, 6), (6, 0, 8)) ,description=u' Enable or disable MySQL Backup history log ')
       ,Option(var='backup_history_log_file' ,versions=((5, 6), (6, 0, 8)) ,description=u' Name of the MySQL Backup history log file ')
       ,Option(var='backup_progress_log' ,versions=((5, 6), (6, 0, 8)) ,description=u' Enable or disable MySQL Backup progress log ')
       ,Option(var='backup_progress_log_file' ,versions=((5, 6), (6, 0, 8)) ,description=u' Name of the MySQL Backup progress log file ')
       ,Option(var='backup_wait_timeout' ,versions=((6, 0, 7),) ,description=u' Number of seconds DDL statements wait for BACKUP DATABASE or RESTORE before aborting ')
       ,Option(var='backupdir' ,versions=((5, 6), (6, 0, 7)) ,description=u' Default backup image file directory ')
       ,Option(var='basedir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Path to installation directory ')
       ,Option(var='big_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Allow big result sets by saving all temporary sets on file ')
       ,Option(var='character_set' ,versions=((4, 1),) ,description=u' The default character set ')
       ,Option(var='character_set_client' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Current client character set ')
       ,Option(var='character_set_connection' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Current connection character set ')
       ,Option(var='character_set_database' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The character set used by the default database ')
       ,Option(var='character_set_filesystem' ,versions=((5, 0, 19), (5, 1, 6), (5, 4), (5, 5), (6, 0)) ,description=u' Set the file system character set ')
       ,Option(var='character_set_results' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Current result character set ')
       ,Option(var='character_set_server' ,versions=((4, 1, 3), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Set the default character set ')
       ,Option(var='character_set_system' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The character set used by the server for storing identifiers ')
       ,Option(var='character_sets_dir' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Directory where character sets are ')
       ,Option(var='collation_connection' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The collation of the connection ')
       ,Option(var='collation_database' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The collation used by the default database ')
       ,Option(var='collation_server' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Set the default collation ')
       ,Option(var='completion_type' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Default completion type ')
       ,Option(var='connect_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The number of seconds the mysqld server waits for a connect packet before responding with \'Bad handshake\' ')
       ,Option(var='datadir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Path to the database root ')
       ,Option(var='date_format' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The DATE format (For future) ')
       ,Option(var='datetime_format' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The DATETIME/TIMESTAMP format (for future) ')
       ,Option(var='debug' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' デバッグログを出力 ')
       ,Option(var='debug_sync' ,versions=((5, 1, 41), (5, 5), (6, 0, 6)) ,description=u' デバッグの同期を取るためのインターフェース ')
       ,Option(var='default-collation' ,versions=((4, 1),) ,description=u' 既定の列挙体を設定 ')
       ,Option(var='default_week_format' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The default week format used by WEEK() functions ')
       ,Option(var='delayed_insert_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' After inserting delayed_insert_limit rows, the INSERT DELAYED handler will check if there are any SELECT statements pending. If so, it allows these to execute before continuing ')
       ,Option(var='delayed_insert_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' How many seconds an INSERT DELAYED thread should wait for INSERT statements before terminating ')
       ,Option(var='delayed_queue_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' What size queue (in rows) should be allocated for handling INSERT DELAYED ')
       ,Option(var='div_precision_increment' ,versions=((5, 0, 6), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Scale of the result of \'/\' operator will be increased by this many digits ')
       ,Option(var='error_count' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Number of errors ')
       ,Option(var='event_scheduler' ,versions=((5, 1, 6), (5, 4), (5, 5), (6, 0)) ,description=u' Enable/disable and start/stop the event scheduler. Note that this variable underwent significant changes in behavior and permitted values in MySQL 5.1.11 and 5.1.12 ')
       ,Option(var='expire_logs_days' ,versions=((4, 1, 0), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If nonzero, binary logs will be purged after expire_logs_days days; possible purges happen at startup and at binary log rotation ')
       ,Option(var='flush' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Flush tables to disk between SQL commands ')
       ,Option(var='flush_time' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' A dedicated thread is created to flush all tables at the given interval ')
       ,Option(var='ft_boolean_syntax' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' List of operators for MATCH ... AGAINST ( ... IN BOOLEAN MODE) ')
       ,Option(var='ft_max_word_len' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The maximum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable ')
       ,Option(var='ft_min_word_len' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The minimum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable ')
       ,Option(var='ft_query_expansion_limit' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Number of best matches to use for query expansion ')
       ,Option(var='ft_stopword_file' ,versions=((4, 1, 10), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Use stopwords from this file instead of built-in list ')
       ,Option(var='general_log' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=u' Enable|disable general log ')
       ,Option(var='general_log_file' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=u' 一般クエリーログファイルの名前 ')
       ,Option(var='group_concat_max_len' ,versions=((4, 1, 10), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The maximum length of the result of function group_concat ')
       ,Option(var='have_blackhole_engine' ,versions=((4, 1, 11), (5, 0), (5, 1)) ,description=u' mysqldがBLACKHOLEテーブルをサポートしているか ')
       ,Option(var='have_community_features' ,versions=((5, 1, 24), (5, 4)) ,description=u' 文のプロフィリングが有効か ')
       ,Option(var='have_compress' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' zlib圧縮ライブラリが使えるか ')
       ,Option(var='have_crypt' ,versions=((4, 1, 10), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' crypt()システムコールが使えるか ')
       ,Option(var='have_csv' ,versions=((4, 1, 14), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' mysqldがcsvテーブルをサポートしているか ')
       ,Option(var='have_dynamic_loading' ,versions=((5, 1, 10), (5, 4), (6, 0)) ,description=u' mysqldがプラグインの動的ロードに対応しているか ')
       ,Option(var='have_example_engine' ,versions=((4, 1, 14), (5, 0), (5, 1)) ,description=u' mysqldがEXAMPLEテーブルをサポートしているか ')
       ,Option(var='have_federated_engine' ,versions=((5, 0, 6), (5, 1)) ,description=u' mysqldがFEDERATEDテーブルをサポートしているか ')
       ,Option(var='have_geometry' ,versions=((4, 1, 13), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' mysqldがスペーシャルデータ型をサポートしているか ')
       ,Option(var='have_isam' ,versions=((4, 1), (5, 0), (5, 1)) ,description=u' mysqldがISAMテーブルをサポートしているか ')
       ,Option(var='have_partition_engine' ,versions=((5, 1, 1),) ,description=u' mysqldがパーティショニングをサポートしているか ')
       ,Option(var='have_partitioning' ,versions=((5, 1, 6), (5, 4), (6, 0)) ,description=u' mysqldがパーティショニングをサポートしているか ')
       ,Option(var='have_profiling' ,versions=((5, 5), (6, 0, 14)) ,description=u' 文書プロフィーリングが有効か ')
       ,Option(var='have_query_cache' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' クエリーキャッシュをサポートしているか ')
       ,Option(var='have_raid' ,versions=((4, 1), (5, 0), (5, 1)) ,description=u' mysqldがRAIDをサポートしているか ')
       ,Option(var='have_symlink' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' シンボリックリンクが有効であるか ')
       ,Option(var='hostname' ,versions=((5, 0, 38), (5, 1, 17), (5, 4), (5, 5), (6, 0)) ,description=u' サーバホストの名前 ')
       ,Option(var='identity' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This variable is a synonym for the LAST_INSERT_ID variable. It exists for compatibility with other database systems ')
       ,Option(var='ignore_builtin_innodb' ,versions=((5, 1, 33), (5, 4), (5, 5)) ,description=u' 埋め込まれたInnoDBを無視する（InnoDBプラグインを利用できるようにする） ')
       ,Option(var='init_connect' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Statements that are executed for each new connection ')
       ,Option(var='init_file' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 起動する時にこのファイルからSQLコマンドを読み込む ')
       ,Option(var='insert_id' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' AUTO_INCREMENT値を挿入する場合に、INSERT又はALTER TABLEで使う値を設定 ')
       ,Option(var='interactive_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The number of seconds the server waits for activity on an interactive connection before closing it ')
       ,Option(var='join_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 完全JOINの場合に使うバッファの大きさ ')
       ,Option(var='join_cache_level' ,versions=((6, 0, 9),) ,description=u' JOINバッファがどのように利用するか ')
       ,Option(var='keep_files_on_create' ,versions=((5, 0, 48), (5, 1, 21), (5, 4), (5, 5), (6, 0)) ,description=u' Do not overwrite existing .MYD/.MYI files in default database directory ')
       ,Option(var='key_cache_age_threshold' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This characterizes the number of hits a hot block has to be untouched until it is considered aged enough to be downgraded to a warm block. This specifies the percentage ratio of that number of hits to the total number of blocks in key cache ')
       ,Option(var='key_cache_block_size' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The default size of key cache blocks ')
       ,Option(var='key_cache_division_limit' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The minimum percentage of warm blocks in key cache ')
       ,Option(var='language' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' クライアントエラーメッセージの言語。完全パスで指定することが可能 ')
       ,Option(var='large_files_support' ,versions=((5, 0), (5, 1)) ,description=u' 大きいファイルに対応しているか ')
       ,Option(var='large_page_size' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The size of memory pages when large page support is enabled ')
       ,Option(var='large_pages' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 大きいページのサポートを有効にする ')
       ,Option(var='last_insert_id' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 最新のAUTO_INCREMENTの値 ')
       ,Option(var='lc-messages' ,versions=((5, 5),) ,description=u' エラーメッセージのロカール ')
       ,Option(var='lc-messages-dir' ,versions=((5, 5),) ,description=u' The directory where error messages are located ')
       ,Option(var='lc_time_names' ,versions=((4, 1, 21), (5, 0, 25), (5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=u' The locale that controls the language used to display day and month names ')
       ,Option(var='license' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' サーバのライセンスの種類 ')
       ,Option(var='locked_in_memory' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Lock the mysqld process in memory ')
       ,Option(var='locked_in_memory' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Whether mysqld is locked in memory ')
       ,Option(var='log' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Log connections and queries to file ')
       ,Option(var='log_backup_output' ,versions=((5, 6), (6, 0, 8)) ,description=u' The destination for MySQL Backup history and progress log output. Syntax: log-backup-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE ')
       ,Option(var='log_bin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' バイナリログを有効にする ')
       ,Option(var='log_bin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' バイナリログが有効になっているか ')
       ,Option(var='log_bin_trust_function_creators' ,versions=((5, 0, 16), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If equal to 0 (the default), then when --log-bin is used, creation of a stored function is allowed only to users having the SUPER privilege and only if the function created does not break binary logging ')
       ,Option(var='log_bin_trust_routine_creators' ,versions=((5, 0, 6), (5, 1), (5, 2), (5, 4)) ,description=u' （廃止予定）log-bin-trust-function-creatorsを使う ')
       ,Option(var='log_error' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' エラーログファイル ')
       ,Option(var='log_output' ,versions=((5, 1, 6), (5, 4), (5, 5), (6, 0)) ,description=u' The destination for general query log and slow query log output. Syntax: log-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE ')
       ,Option(var='log_queries_not_using_indexes' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Log queries that are executed without benefit of any index to the slow query log if it is open ')
       ,Option(var='log_slow_queries' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Whether or not to log slow queries. Logging defaults to hostname-slow.log file. Must be enabled to activate other slow query log options ')
       ,Option(var='log_warnings' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Log some noncritical warnings to the log file ')
       ,Option(var='long_query_time' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Log all queries that have taken more than long_query_time seconds to execute to file ')
       ,Option(var='low_priority_updates' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' INSERT/DELETE/UPDATE has lower priority than selects ')
       ,Option(var='lower_case_file_system' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This variable describes the case sensitivity of file names on the file system ')
       ,Option(var='lower_case_table_names' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If set to 1 table names are stored in lowercase on disk and table names will be case-insensitive. Should be set to 2 if you are using a case insensitive file system ')
       ,Option(var='max_allowed_packet' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Max packetlength to send/receive from to server ')
       ,Option(var='max_connect_errors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If there is more than this number of interrupted connections from a host this host will be blocked from further connections ')
       ,Option(var='max_connections' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The number of simultaneous clients allowed ')
       ,Option(var='max_delayed_threads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Don\'t start more than this number of threads to handle INSERT DELAYED statements. If set to zero, which means INSERT DELAYED is not used ')
       ,Option(var='max_error_count' ,versions=((4, 1, 0), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Max number of errors/warnings to store for a statement ')
       ,Option(var='max_heap_table_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Don\'t allow creation of heap tables bigger than this ')
       ,Option(var='max_insert_delayed_threads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This variable is a synonym for max_delayed_threads ')
       ,Option(var='max_join_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Joins that are probably going to read more than max_join_size records return an error ')
       ,Option(var='max_length_for_sort_data' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Max number of bytes in sorted records ')
       ,Option(var='max_prepared_stmt_count' ,versions=((4, 1, 19), (5, 0, 21), (5, 1, 10), (5, 4), (5, 5), (6, 0)) ,description=u' Maximum number of prepared statements in the server ')
       ,Option(var='max_relay_log_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If nonzero, relay log will be rotated automatically when the size exceeds this value ')
       ,Option(var='max_seeks_for_key' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Limit assumed max number of seeks when looking up rows based on a key ')
       ,Option(var='max_sort_length' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The number of bytes to use when sorting BLOB or TEXT values ')
       ,Option(var='max_sp_recursion_depth' ,versions=((5, 0, 17), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Maximum stored procedure recursion depth ')
       ,Option(var='max_tmp_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Maximum number of temporary tables a client can keep open at a time ')
       ,Option(var='max_user_connections' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The maximum number of active connections for a single user (0 = no limit) ')
       ,Option(var='max_write_lock_count' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' After this many write locks, allow some read locks to run in between ')
       ,Option(var='min_examined_row_limit' ,versions=((5, 1, 21), (5, 4), (5, 5), (6, 0, 4)) ,description=u' Queries examining fewer than this number of rows are not logged to slow query log ')
       ,Option(var='multi_range_count' ,versions=((5, 0, 3), (5, 1), (5, 2)) ,description=u' The maximum number of ranges to send to a table handler at once during range selects ')
       ,Option(var='named_pipe' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Indicates whether the server supports connections over named pipes ')
       ,Option(var='net_buffer_length' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Buffer length for TCP/IP and socket communication ')
       ,Option(var='net_read_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Number of seconds to wait for more data from a connection before aborting the read ')
       ,Option(var='net_retry_count' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If a read on a communication port is interrupted, retry this many times before giving up ')
       ,Option(var='net_write_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Number of seconds to wait for a block to be written to a connection before aborting the write ')
       ,Option(var='old' ,versions=((5, 1, 18), (5, 4), (5, 5), (6, 0)) ,description=u' Cause the server to revert to certain behaviors present in older versions ')
       ,Option(var='old_alter_table' ,versions=((5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Use old, nonoptimized alter table ')
       ,Option(var='open_files_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If this is not 0, then mysqld will use this value to reserve file descriptors to use with setrlimit() ')
       ,Option(var='optimizer_prune_level' ,versions=((5, 0, 1), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Controls the heuristic(s) applied during query optimization to prune less-promising partial plans from the optimizer search space ')
       ,Option(var='optimizer_search_depth' ,versions=((5, 0, 1), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Maximum depth of search performed by the query optimizer ')
       ,Option(var='optimizer_switch' ,versions=((5, 1, 34), (5, 2, 4), (5, 4, 2), (5, 5), (6, 0)) ,description=u' Enable control over which optimizations to use ')
       ,Option(var='optimizer_use_mrr' ,versions=((5, 2, 4), (6, 0, 3)) ,description=u' How the optimizer reads multiple ranges of index tuples ')
       ,Option(var='partition' ,versions=((5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Enable (or disable) partitioning support ')
       ,Option(var='pid_file' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Process ID file used by mysqld_safe ')
       ,Option(var='plugin_dir' ,versions=((4, 1, 25), (5, 0, 67), (5, 1, 2), (5, 4), (5, 5), (6, 0)) ,description=u' Directory for plugins ')
       ,Option(var='port' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Port number to use for connection ')
       ,Option(var='preload_buffer_size' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The size of the buffer that is allocated when preloading indexes ')
       ,Option(var='prepared_stmt_count' ,versions=((4, 1, 19), (5, 0, 21), (5, 1, 10)) ,description=u' The current number of prepared文の数 ')
       ,Option(var='profiling' ,versions=((5, 0, 37), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=u' Enable or disable statement profiling ')
       ,Option(var='profiling_history_size' ,versions=((5, 0, 37), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=u' How many statements to maintain profiling information for ')
       ,Option(var='protocol_version' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The version of the client/server protocol used by the MySQL server ')
       ,Option(var='pseudo_thread_id' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' For internal server use ')
       ,Option(var='query_alloc_block_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Allocation block size for query parsing and execution ')
       ,Option(var='query_cache_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Don\'t cache results that are bigger than this ')
       ,Option(var='query_cache_min_res_unit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Minimal size of unit in which space for results is allocated (last unit will be trimmed after writing all result data) ')
       ,Option(var='query_cache_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The memory allocated to store results from old queries ')
       ,Option(var='query_cache_type' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Query cache type ')
       ,Option(var='query_cache_wlock_invalidate' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Invalidate queries in query cache on LOCK for write ')
       ,Option(var='query_prealloc_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Persistent buffer for query parsing and execution ')
       ,Option(var='range_alloc_block_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Allocation block size for storing ranges during optimization ')
       ,Option(var='read_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Each thread that does a sequential scan allocates a buffer of this size for each table it scans ')
       ,Option(var='read_only' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Make all nontemporary tables read-only ')
       ,Option(var='read_rnd_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' When reading rows in sorted order after a sort, the rows are read through this buffer to avoid a disk seeks. If not set, then it is set to the value of record_buffer. ')
       ,Option(var='record_buffer' ,versions=() ,description=u' Alias for read_buffer_size ')
       ,Option(var='relay_log_info_file' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The location and name of the file that remembers where the SQL replication thread is in the relay logs ')
       ,Option(var='relay_log_space_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Maximum space to use for all relay logs ')
       ,Option(var='server_id' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Uniquely identifies the server instance in the community of replication partners. Must be set to a value greater than 0 to enable replication. ')
       ,Option(var='shared_memory' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Whether the server allows shared-memory connections ')
       ,Option(var='shared_memory_base_name' ,versions=((4, 1, 0), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' The name of shared memory to use for shared-memory connections ')
       ,Option(var='skip-external-locking' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Skip system (external) locking ')
       ,Option(var='skip_external_locking' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Use system (external) locking ')
       ,Option(var='slow_launch_time' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If creating the thread takes longer than this value (in seconds), the Slow_launch_threads counter will be incremented ')
       ,Option(var='slow_query_log' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=u' Enable|disable slow query log ')
       ,Option(var='slow_query_log_file' ,versions=((5, 1, 12), (5, 4), (5, 5), (6, 0)) ,description=u' Name of the slow query log file ')
       ,Option(var='socket' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Socket file to use for connection ')
       ,Option(var='sort_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Each thread that needs to do a sort allocates a buffer of this size ')
       ,Option(var='sql_auto_is_null' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If set to 1, you can find the last inserted row for a table that contains an AUTO_INCREMENT column by using the following construct: WHERE auto_increment_column IS NULL ')
       ,Option(var='sql_big_selects' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If set to 0, MySQL aborts SELECT statements that are likely to take a very long time to execute ')
       ,Option(var='sql_big_tables' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This variable is 廃止予定, and is mapped to big_tables ')
       ,Option(var='sql_buffer_result' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Forces the result to be put into a temporary table ')
       ,Option(var='sql_log_bin' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Toggle binary logging ')
       ,Option(var='sql_log_off' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If set to 1, no logging is done to the general query log for this client ')
       ,Option(var='sql_log_update' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This variable is 廃止予定, and is mapped to SQL_LOG_BIN ')
       ,Option(var='sql_low_priority_updates' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This variable is 廃止予定, and is mapped to low_priority_updates ')
       ,Option(var='sql_max_join_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This variable is 廃止予定, and is mapped to max_join_size ')
       ,Option(var='sql_mode' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Set the SQL server mode ')
       ,Option(var='sql_notes' ,versions=((4, 1, 11), (5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If set to 1, warnings of Note level are recorded ')
       ,Option(var='sql_quote_show_create' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If set to 1 the server quotes identifiers for SHOW CREATE TABLE and SHOW CREATE DATABASE文の数 ')
       ,Option(var='sql_safe_updates' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If set to 1, MySQL aborts UPDATE or DELETE statements that do not use a key in the WHERE clause or a LIMIT clause ')
       ,Option(var='sql_select_limit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The maximum number of rows to return from SELECT文の数 ')
       ,Option(var='sql_warnings' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This variable controls whether single-row INSERT statements produce an information string if warnings occur ')
       ,Option(var='storage_engine' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The default storage engine ')
       ,Option(var='sync_binlog' ,versions=((4, 1, 3), (5, 0, 1), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Synchronously flush binary log to disk after every #th event ')
       ,Option(var='sync_frm' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Sync .frm to disk on create. Enabled by default ')
       ,Option(var='system_time_zone' ,versions=((4, 1, 3), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The server system time zone ')
       ,Option(var='table_cache' ,versions=((4, 1), (5, 0), (5, 1)) ,description=u' The number of open tables for all threads ')
       ,Option(var='table_definition_cache' ,versions=((5, 1, 3), (5, 4), (6, 0)) ,description=u' The number of table definitions that can be stored in the definition cache. ')
       ,Option(var='table_lock_wait_timeout' ,versions=((5, 0, 10), (5, 1), (5, 4), (6, 0)) ,description=u' Currently unused ')
       ,Option(var='table_open_cache' ,versions=((5, 1, 3), (5, 4), (6, 0)) ,description=u' The number of open tables for all threads ')
       ,Option(var='table_type' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 2), (5, 4)) ,description=u' A synonym for storage_engine ')
       ,Option(var='thread_cache_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' How many threads we should keep in a cache for reuse ')
       ,Option(var='thread_concurrency' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Permits the application to give the threads system a hint for the desired number of threads that should be run at the same time ')
       ,Option(var='thread_handling' ,versions=((5, 1, 17), (5, 4), (6, 0)) ,description=u' The thread-handling model ')
       ,Option(var='thread_pool_size' ,versions=((6, 0, 4),) ,description=u' The size of the thread pool ')
       ,Option(var='thread_stack' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' The stack size for each thread ')
       ,Option(var='time_format' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' The TIME format (for future) ')
       ,Option(var='time_zone' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The current time zone. ')
       ,Option(var='timestamp' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Change the value returned by NOW() ')
       ,Option(var='tmpdir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Path for temporary files ')
       ,Option(var='transaction_alloc_block_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Allocation block size for transactions to be stored in binary log ')
       ,Option(var='transaction_prealloc_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Persistent buffer for transactions to be stored in binary log ')
       ,Option(var='tx_isolation' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' The default transaction isolation level ')
       ,Option(var='updatable_views_with_limit' ,versions=((5, 0, 2), (5, 1), (5, 4), (6, 0)) ,description=u' This variable controls whether updates to a view can be made when the view does not contain all columns of the primary key ')
       ,Option(var='version' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Output version information and exit ')
       ,Option(var='version_comment' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' This variable contains the value of the --with-comment option specified when building MySQL ')
       ,Option(var='version_compile_machine' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' The type of machine or architecture on which MySQL was built ')
       ,Option(var='version_compile_os' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' The type of operating system on which MySQL was built ')
       ,Option(var='wait_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' The number of seconds the server waits for activity on a connection before closing it ')
       ,Option(var='warning_count' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' The number of warnings ')
     ) # End of section Server
     ,'Replication' : (
        Option(var='have_row_based_replication' ,versions=((5, 1, 5),) ,description=u' Shows whether row-based replication is supported ')
       ,Option(var='init_slave' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Command(s) that are executed when a slave connects to a master ')
       ,Option(var='log_slave_updates' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' This option tells the slave to log the updates performed by its SQL thread to its own binary log ')
       ,Option(var='master-bind' ,versions=((5, 1, 22), (5, 4), (5, 5), (6, 0)) ,description=u' The network interface which is to be used for connecting to the master by a replication slave having multiple network connections ')
       ,Option(var='relay_log' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The location and base name to use for relay logs ')
       ,Option(var='relay_log_index' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The location and name to use for the file that keeps a list of the last relay logs ')
       ,Option(var='relay_log_purge' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Determines whether relay logs are purged ')
       ,Option(var='relay_log_recovery' ,versions=((5, 5), (6, 0, 11)) ,description=u' Enables automatic recovery of relay log files from master at startup ')
       ,Option(var='report_host' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Host name or IP of the slave to be reported to the master during slave registration ')
       ,Option(var='report_password' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The account password that a slave server should report to the master server ')
       ,Option(var='report_port' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Port for connecting to slave reported to the master during slave registration ')
       ,Option(var='report_user' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The account name that a slave server should report to the master server ')
       ,Option(var='rpl_recovery_rank' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Not used ')
       ,Option(var='rpl_semi_sync_master_enabled' ,versions=((5, 5), (6, 0, 8)) ,description=u' Whether semisynchronous replication is enabled on master ')
       ,Option(var='rpl_semi_sync_master_reply_log_file_pos' ,versions=((6, 0, 8),) ,description=u' 内部で利用 ')
       ,Option(var='rpl_semi_sync_master_timeout' ,versions=((5, 5), (6, 0, 8)) ,description=u' Number of seconds to wait for slave acknowledgment ')
       ,Option(var='rpl_semi_sync_master_trace_level' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='rpl_semi_sync_master_wait_no_slave' ,versions=((5, 5), (6, 0, 14)) ,description=u' Whether master waits for timeout even with no slaves ')
       ,Option(var='rpl_semi_sync_slave_enabled' ,versions=((5, 5), (6, 0, 8)) ,description=u' Whether semisynchronous replication is enabled on slave ')
       ,Option(var='rpl_semi_sync_slave_trace_level' ,versions=((5, 5), (6, 0, 8)) ,description=u' 内部で利用 ')
       ,Option(var='slave_compressed_protocol' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Use compression on master/slave protocol ')
       ,Option(var='slave_exec_mode' ,versions=((5, 1, 23), (5, 1, 23), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=u' Allows for switching between idempotent mode (key and some other errors suppressed) and strict mode; strict mode is the default, except for MySQL Cluster, where idempotent is always used ')
       ,Option(var='slave_load_tmpdir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The location where the slave should put its temporary files when replicating a LOAD DATA INFILE command ')
       ,Option(var='slave_net_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Number of seconds to wait for more data from a master/slave connection before aborting the read ')
       ,Option(var='slave_skip_errors' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Tells the slave thread to continue replication when a query returns an error from the provided list ')
       ,Option(var='slave_transaction_retries' ,versions=((4, 1, 11), (5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Number of times the slave SQL thread will retry a transaction in case it failed with a deadlock or elapsed lock wait timeout, before giving up and stopping ')
       ,Option(var='sql_slave_skip_counter' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The number of events from the master that a slave server should skip ')
     ) # End of section Replication
     ,'Innodb' : (
        Option(var='foreign_key_checks' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' If set to 1 (the default), foreign key constraints for InnoDB tables are checked. ')
       ,Option(var='have_innodb' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' Whether mysqld supports InnoDB tables ')
       ,Option(var='innodb_adaptive_flushing' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' Control InnoDB adaptive flushing of dirty pages ')
       ,Option(var='innodb_adaptive_hash_index' ,versions=((5, 0, 52), (5, 1, 24), (5, 4), (5, 5), (6, 0, 5)) ,description=u' Enable or disable InnoDB adaptive hash indexes ')
       ,Option(var='innodb_additional_mem_pool_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Size of a memory pool InnoDB uses to store data dictionary information and other internal data structures ')
       ,Option(var='innodb_autoextend_increment' ,versions=((4, 1, 5), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Data file autoextend increment in megabytes ')
       ,Option(var='innodb_autoinc_lock_mode' ,versions=((5, 1, 22), (5, 4), (5, 5), (6, 0)) ,description=u' Set InnoDB auto-increment lock mode ')
       ,Option(var='innodb_buffer_pool_awe_mem_mb' ,versions=((4, 1, 0), (5, 0), (5, 1)) ,description=u' If Windows AWE is used, the size in Megabytes of InnoDB buffer pool allocated from the AWE memory ')
       ,Option(var='innodb_buffer_pool_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The size of the memory buffer InnoDB uses to cache data and indexes of its tables ')
       ,Option(var='innodb_change_buffering' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' Whether InnoDB performs insert buffering. ')
       ,Option(var='innodb_checksums' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Enable InnoDB checksums validation ')
       ,Option(var='innodb_commit_concurrency' ,versions=((5, 0, 12), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Helps in performance tuning in heavily concurrent environments ')
       ,Option(var='innodb_concurrency_tickets' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Number of times a thread is allowed to enter InnoDB within the same SQL query after it has once got the ticket ')
       ,Option(var='innodb_data_file_path' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Path to individual files and their sizes ')
       ,Option(var='innodb_data_home_dir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBテーブルスペースの共有部分 ')
       ,Option(var='innodb_doublewrite' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBの二重バッファを有効にする ')
       ,Option(var='innodb_extra_dirty_writes' ,versions=((5, 4),) ,description=u' ダーティページ率が最大ダーティ率より少ない場合にダーティバッファページをフラッシュするか ')
       ,Option(var='innodb_fast_shutdown' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Speeds up the shutdown process of the InnoDB storage engine ')
       ,Option(var='innodb_file_format' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' 新しいInnoDBテーブルの形式 ')
       ,Option(var='innodb_file_format_check' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' InnoDBがファイル形式フォーマットチェックを行うか ')
       ,Option(var='innodb_file_io_threads' ,versions=((4, 1), (5, 0), (5, 1), (6, 0)) ,description=u' InnoDBのファイルI／Oスレッド数 ')
       ,Option(var='innodb_file_per_table' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 各InnoDBテーブルをデータベースディレクトリの.ibdファイルに保存 ')
       ,Option(var='innodb_flush_log_at_trx_commit' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Set to 0 (write and flush once per second), 1 (write and flush at each commit) or 2 (write at commit, flush once per second) ')
       ,Option(var='innodb_flush_method' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' With which method to flush data ')
       ,Option(var='innodb_force_recovery' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Helps to save your data in case the disk image of the database becomes corrupt ')
       ,Option(var='innodb_io_capacity' ,versions=((5, 1, 38), (5, 4), (5, 5)) ,description=u' The limit on the maximum number of I/O operations per second ')
       ,Option(var='innodb_lock_wait_timeout' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Timeout in seconds an InnoDB transaction may wait for a lock before being rolled back ')
       ,Option(var='innodb_locks_unsafe_for_binlog' ,versions=((4, 1, 4), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Force InnoDB not to use next-key locking. Instead use only row-level locking ')
       ,Option(var='innodb_log_arch_dir' ,versions=((4, 1), (5, 0), (5, 1)) ,description=u' 完全ログのアーカイブ先 ')
       ,Option(var='innodb_log_archive' ,versions=((4, 1), (5, 0), (5, 1)) ,description=u' 未使用 ')
       ,Option(var='innodb_log_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The size of the buffer which InnoDB uses to write log to the log files on disk ')
       ,Option(var='innodb_log_file_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Size of each log file in a log group ')
       ,Option(var='innodb_log_files_in_group' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ロググループのInnoDBログファイル数 ')
       ,Option(var='innodb_log_group_home_dir' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBログファイルへのパス ')
       ,Option(var='innodb_max_dirty_pages_pct' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' バッファプールに可能なダーティページの率 ')
       ,Option(var='innodb_max_merged_io' ,versions=((5, 4),) ,description=u' The maximum number of background I/O requests to merge to issue a larger I/O request ')
       ,Option(var='innodb_max_purge_lag' ,versions=((4, 1, 6), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Desired maximum length of the purge queue (0 = no limit) ')
       ,Option(var='innodb_mirrored_log_groups' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' データベースに同一内容のロググループの数 ')
       ,Option(var='innodb_old_blocks_pct' ,versions=((5, 1, 41), (5, 5)) ,description=u' 古いブロック用に確保するInnoDBブッフぁプールの率 ')
       ,Option(var='innodb_old_blocks_time' ,versions=((5, 1, 41), (5, 5)) ,description=u' How long (in ms) blocks must remain in old end of InnoDB buffer pool before moving to new end ')
       ,Option(var='innodb_open_files' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The maximum number of files that InnoDB keeps open at the same time ')
       ,Option(var='innodb_read_ahead_threshold' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' The sensitivity of InnoDB linear read-ahead ')
       ,Option(var='innodb_read_io_threads' ,versions=((5, 1, 38), (5, 4), (5, 5)) ,description=u' The number of background I/O threads for read prefetch requests ')
       ,Option(var='innodb_replication_delay' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' スレーブサーバレプリケーションスレッのディレイ ')
       ,Option(var='innodb_rollback_on_timeout' ,versions=((5, 0, 32), (5, 1, 15), (5, 4), (5, 5), (6, 0)) ,description=u' Roll back entire transaction on transaction timeout, not just last statement ')
       ,Option(var='innodb_spin_wait_delay' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' The maximum delay between polls for a spin lock ')
       ,Option(var='innodb_stats_on_metadata' ,versions=((5, 1, 17), (5, 4), (5, 5), (6, 0)) ,description=u' Enable or disable InnoDB table statistics updates for metadata文の数 ')
       ,Option(var='innodb_stats_sample_pages' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' The number of index pages to sample for index distribution statistics ')
       ,Option(var='innodb_strict_mode' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' Whether InnoDB returns errors rather than warnings for exceptional conditions ')
       ,Option(var='innodb_support_xa' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Enable InnoDB support for the XA two-phase commit ')
       ,Option(var='innodb_sync_spin_loops' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' spin-loop rounds in InnoDB mutexes ')
       ,Option(var='innodb_table_locks' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Enable InnoDB locking in LOCK TABLES ')
       ,Option(var='innodb_thread_concurrency' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBの最大スレッド数。0に設定された場合はスレッドクロックスロットリングを停止 ')
       ,Option(var='innodb_thread_concurrency_timer_based' ,versions=((5, 4),) ,description=u' ロックフリー方式でスレッドを平行実行されかているか ')
       ,Option(var='innodb_thread_sleep_delay' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' InnoDBキューを載せる前にinnodbスレッドをスリープさせる時間(usec)。0に設定した場合はスリープしない ')
       ,Option(var='innodb_use_legacy_cardinality_algorithm' ,versions=((5, 0, 82), (5, 1, 35)) ,description=u' 旧InnoDB索引多重度計算アルゴリズムを使うか ')
       ,Option(var='innodb_use_sys_malloc' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' InnoDBがOS又は独自のメモリアロケータを使うか ')
       ,Option(var='innodb_version' ,versions=((5, 1, 38), (5, 4, 2), (5, 5)) ,description=u' InnoDBのバージョン ')
       ,Option(var='innodb_write_io_threads' ,versions=((5, 1, 38), (5, 4), (5, 5)) ,description=u' バッファキャッシュのダーティページからディスクに書き込むバックグラウンドI／Oスレッドの数 ')
       ,Option(var='timed_mutexes' ,versions=((5, 0, 3), (5, 1), (5, 4), (6, 0)) ,description=u' ミューテックスの時間を計るか（現在、InnoDBミューテックスに対応） ')
       ,Option(var='unique_checks' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' 1に設定された場合は、InnoDBテーブルの２目の索引のユニークチェックを行う（既定値） ')
     ) # End of section Innodb
     ,'Myisam' : (
        Option(var='bulk_insert_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Size of tree cache used in bulk insert optimization ')
       ,Option(var='concurrent_insert' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' MyISAMの場合は平行してINSERTする ')
       ,Option(var='delay_key_write' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' DELAY_KEY_WRITEのタイプ ')
       ,Option(var='have_rtree_keys' ,versions=((4, 1, 3), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' RTREE索引がある場合はYES、それ以外の場合はNO。（MyISAMテーブルの（MyISAMテーブルのスペーシャル索引に利用される） ')
       ,Option(var='key_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' MyISAMテーブル用の索引ブロックのバッファサイズ。 ')
       ,Option(var='myisam_data_pointer_size' ,versions=((4, 1, 2), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' MyISAMテーブルのポインターサイズの既定値。 ')
       ,Option(var='myisam_max_extra_sort_file_size' ,versions=((4, 1), (5, 0)) ,description=u' 廃止予定のパラメータ ')
       ,Option(var='myisam_max_sort_file_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' この値より作業用ファイルが大きくなる場合は、ファーストソート索引方式を使わない。 ')
       ,Option(var='myisam_recover_options' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The value of the --myisam-recover option ')
       ,Option(var='myisam_repair_threads' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' MyISAMテーブルの修復に使うスレッド数。１に設定された場合は平行修復を無効にします ')
       ,Option(var='myisam_sort_buffer_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' The buffer that is allocated when sorting the index when doing a REPAIR or when creating indexes with CREATE INDEX or ALTER TABLE ')
       ,Option(var='myisam_stats_method' ,versions=((4, 1, 15), (5, 0, 14), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' Specifies how MyISAM index statistics collection code should treat NULLs ')
       ,Option(var='myisam_use_mmap' ,versions=((5, 1, 4), (5, 4), (5, 5), (6, 0)) ,description=u' Use memory mapping for reading and writing MyISAM tables ')
       ,Option(var='tmp_table_size' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)) ,description=u' メモリ上の作業テーブルの大きさが指定され値より多い場合、MySQLは自動的にディスクMyISAMテーブルに変換する ')
     ) # End of section Myisam
     ,'Merge' : (
        Option(var='have_merge_engine' ,versions=((4, 1, 21), (5, 0, 24), (5, 1)) ,description=u' mysqldがマージテーブルをサポートしているか ')
        ,     ) # End of section Merge
     ,'Falcon' : (
        Option(var='falcon_checkpoint_schedule' ,versions=((6, 0, 2),) ,description=u' Sets the frequency that in-memory structures are synchronized to disk ')
       ,Option(var='falcon_checksums' ,versions=((6, 0, 6),) ,description=u' Enable Falcon checksum validation ')
       ,Option(var='falcon_consistent_read' ,versions=((6, 0, 4),) ,description=u' Sets the repeatable read isolation mode ')
       ,Option(var='falcon_debug_mask' ,versions=((6, 0, 2),) ,description=u' エラーの場合にFalconエンジンが標準出力するログ情報を設定 ')
       ,Option(var='falcon_debug_server' ,versions=((6, 0, 2),) ,description=u' デバッグサーバを有効にするか ')
       ,Option(var='falcon_disable_fsync' ,versions=((6, 0, 2),) ,description=u' 定期的なfsync処理を無効にする ')
       ,Option(var='falcon_gopher_threads' ,versions=((6, 0, 4),) ,description=u' ゴーファスレッドの数 ')
       ,Option(var='falcon_index_chill_threshold' ,versions=((6, 0, 2),) ,description=u' データがシリアルログにフラッシュされるまでの索引データの大きさ（メガバイト） ')
       ,Option(var='falcon_initial_allocation' ,versions=((6, 0, 2),) ,description=u' 作成された時のFalconテーブルスペースの大きさ ')
       ,Option(var='falcon_io_threads' ,versions=((6, 0, 3),) ,description=u' 非同期I/Oスレッドの数 ')
       ,Option(var='falcon_large_blob_threshold' ,versions=((6, 0, 4),) ,description=u' BLOBの大きさがこの値より小さい場合は、BLOBページに保管せず、データページに保管する ')
       ,Option(var='falcon_lock_wait_timeout' ,versions=((6, 0, 4),) ,description=u' Falconが１つのトランザクションを他のトランザクションのために待つ時間（秒） ')
       ,Option(var='falcon_max_transaction_backlog' ,versions=((6, 0, 2),) ,description=u' falcon_max_transaction_backlog ')
       ,Option(var='falcon_page_cache_size' ,versions=((6, 0, 2),) ,description=u' テーブルスペースファイルからのページのメモリキャッシュの大きさ（バイト） ')
       ,Option(var='falcon_page_size' ,versions=((6, 0, 2),) ,description=u' テーブルスペースに情報を保管するページの大きさ（バイト） ')
       ,Option(var='falcon_record_chill_threshold' ,versions=((6, 0, 2),) ,description=u' シリアルログにフラッシュする前に保管されるレコードデータ（メガバイト） ')
       ,Option(var='falcon_record_memory_max' ,versions=((6, 0, 2),) ,description=u' キャッシュレコードデータ用に割り当てる最大メモリ（バイト） ')
       ,Option(var='falcon_record_scavenge_floor' ,versions=((6, 0, 2),) ,description=u' スキャベンジの後にレコードキャッシュに残すfalcon_record_scavenge_thresholdの率 ')
       ,Option(var='falcon_record_scavenge_threshold' ,versions=((6, 0, 2),) ,description=u' レコードキャッシュから古いレコードを削除し始めるfalcon_record_memory_maxの率 ')
       ,Option(var='falcon_scavenge_schedule' ,versions=((6, 0, 2),) ,description=u' レコードスカビンジングしきい値 ')
       ,Option(var='falcon_serial_log_buffers' ,versions=((6, 0, 2),) ,description=u' Falconシリアルログに割り当てるメモリウインドウ（１MB毎） ')
       ,Option(var='falcon_serial_log_dir' ,versions=((6, 0, 2),) ,description=u' Falconシリアルログファイルの場所 ')
       ,Option(var='falcon_serial_log_priority' ,versions=((6, 0, 4),) ,description=u' Falconシリアルログの書込みの優先度 ')
       ,Option(var='falcon_use_deferred_index_hash' ,versions=((6, 0, 4),) ,description=u' ディファード索引ハッシュルックアップを使う ')
       ,Option(var='falcon_use_sectorcache' ,versions=((6, 0, 6),) ,description=u' ディスク読込みブロックにセクタキャッシュを利用 ')
       ,Option(var='falcon_use_supernodes' ,versions=((6, 0, 5),) ,description=u' 索引スーパノードを使用 ')
     ) # End of section Falcon
     ,'Security' : (
        Option(var='automatic_sp_privileges' ,versions=((5, 0, 3), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' ストアプロシージャを作成や削除した場合にACLに反映 ')
       ,Option(var='local_infile' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' LOAD DATA INFILE文がLOCALをサポートしているか ')
       ,Option(var='old_passwords' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 旧パスワード（4.0以前と古いクライアント用）を使用 ')
       ,Option(var='safe_show_database' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 廃止予定。代わりにGRANT SHOW DATABASESを使ってくささい ')
       ,Option(var='secure_auth' ,versions=((4, 1, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' 旧パスワード（4.1より前）での認証を許可しない ')
       ,Option(var='secure_backup_file_priv' ,versions=((5, 6), (6, 0), (6, 1, 11)) ,description=u' BACKUP DATABASEとRESTOREのファイルを一つのディレクトリに置く ')
       ,Option(var='secure_file_priv' ,versions=((5, 0, 38), (5, 1, 17), (5, 4), (5, 5), (6, 0)) ,description=u' LOAD_FILE()、 LOAD DATA、SELECT ... INTO OUTFILEのファイルを１つのディレクトリに置く ')
       ,Option(var='skip_networking' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' TCP/IP接続を無効にする ')
       ,Option(var='skip_show_database' ,versions=((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)) ,description=u' \'SHOW DATABASE\' コマンドを無効にする ')
     ) # End of section Security
     ,'Archive' : (
        Option(var='have_archive' ,versions=((4, 1, 13), (5, 0), (5, 1)) ,description=u' mysqldがアーカイブテーブルをサポートしている ')
        ,     ) # End of section Archive
     ,'Maria' : (
        Option(var='maria-block-size' ,versions=((6, 0, 6),) ,description=u' Mariaテーブルのブロックサイズ ')
       ,Option(var='maria-checkpoint-interval' ,versions=((6, 0, 6),) ,description=u' 自動チェックポイントの間隔 ')
       ,Option(var='maria-log-file-size' ,versions=((6, 0, 6),) ,description=u' 各Mariaログファイルの大きさ ')
       ,Option(var='maria-log-purge-type' ,versions=((6, 0, 6),) ,description=u' Mariaログファイルを完全に消去するモード ')
       ,Option(var='maria-page-checksum' ,versions=((6, 0, 6),) ,description=u' ページチェックサムの既定モード ')
       ,Option(var='maria-pagecache-age-threshold' ,versions=((6, 0, 6),) ,description=u' 古いページキャッシュのしきい値 ')
       ,Option(var='maria-pagecache-buffer-size' ,versions=((6, 0, 6),) ,description=u' データと索引ページのバッファの大きさ ')
       ,Option(var='maria-pagecache-division-limit' ,versions=((6, 0, 6),) ,description=u' ページキャッシュのwarmブロックの最低率 ')
       ,Option(var='maria-recover' ,versions=((6, 0, 6),) ,description=u' ログファイルなしでMariaテーブルの復旧する ')
       ,Option(var='maria-repair-threads' ,versions=((6, 0, 6),) ,description=u' テーブル修復の時に使うスレッド数 ')
       ,Option(var='maria-sort-buffer-size' ,versions=((6, 0, 6),) ,description=u' 索引用のソートバッファサイズ ')
       ,Option(var='maria-stats-method' ,versions=((6, 0, 6),) ,description=u' 統計情報取得方法 ')
       ,Option(var='maria-sync-log-dir' ,versions=((6, 0, 6),) ,description=u' ログファイルが拡張又は作成された場合のディレクトリの同期を制御 ')
       ,Option(var='maria_max_sort_file_size' ,versions=((6, 0, 6),) ,description=u' 外部ソートファイルの最大サイズ ')
     ) # End of section Maria
   } # End of class system

} # End of 
