/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.myfaces.portlet.selector;

import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;


/**
 * This class retrieves and returns each page file from portlet.xml. If the portlet is in EDIT mode, this class retrives
 * the page file from edit-view key and returns the value. If HELP mode, it retrives the page file from help-view key
 * and returns the value.
 * 
 * @author <a href="mailto:shinsuke@yahoo.co.jp">Shinsuke Sugaya</a>
 */
public class PortletViewSelector implements DefaultViewSelector
{
    // portlet config parameter from portlet.xml
    private static final String EDIT_VIEW = "edit-view";

    // portlet config parameter from portlet.xml
    private static final String HELP_VIEW = "help-view";

    private String editView;

    private String helpView;

    public void setPortletContext(PortletContext context)
    {
    }

    public String selectViewId(RenderRequest request, RenderResponse response) throws PortletException
    {
        if (request.getPortletMode().equals(PortletMode.EDIT) && editView != null)
        {
            return editView;
        }
        else if (request.getPortletMode().equals(PortletMode.HELP) && helpView != null)
        {
            return helpView;
        }

        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.pal.myfaces.portlet.DefaultViewSelector#setPortletConfig(javax.portlet.PortletConfig)
     */
    public void setPortletConfig(PortletConfig portletConfig)
    {
        this.editView = portletConfig.getInitParameter(EDIT_VIEW);
        this.helpView = portletConfig.getInitParameter(HELP_VIEW);
    }

}
