<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<f:view>
    <f:loadBundle basename="jp.sf.pal.blog.resources.BlogTitleViewResources" var="msgs"/>
    <h:form>
        <h:outputText value="#{titleViewPortlet.msgSuccess}" styleClass="portlet-msg-success" escape="false" rendered="#{titleViewPortlet.isMsgSuccess}"/>
        <h:outputText value="#{titleViewPortlet.msgError}" styleClass="portlet-msg-error" escape="false" rendered="#{titleViewPortlet.isMsgError}"/>
        <h:outputText value="#{titleViewPortlet.msgAlert}" styleClass="portlet-msg-alert" escape="false" rendered="#{titleViewPortlet.isMsgAlert}"/>
        <h:outputText value="#{titleViewPortlet.msgInfo}" styleClass="portlet-msg-info" escape="false" rendered="#{titleViewPortlet.isMsgInfo}"/>
        <h:panelGrid border="0" columns="2">
            <h:outputLabel for="targetUser">
                <h:outputText value="#{msgs['blogtitleview.TargetUserNameLable']}" styleClass="portlet-form-field"/>
            </h:outputLabel>
            <h:inputText id="targetUser" value="#{titleViewEditPage.owner}" size="30" styleClass="portlet-form-field-label"/>

            <h:outputLabel for="sortColumn">
                <h:outputText value="#{msgs['blogtitleview.SortByLabel']}" styleClass="portlet-form-field"/>
            </h:outputLabel>
            <h:selectOneMenu value="#{titleViewEditPage.sortColumn}" styleClass="portlet-form-field-label">
                <f:selectItem itemValue="createdtime" itemLabel="#{msgs['blogtitleview.CreatedDateSelect']}"/>
                <f:selectItem itemValue="updatedtime" itemLabel="#{msgs['blogtitleview.UpdatedDateSelect']}"/>
            </h:selectOneMenu>

            <h:outputLabel for="number">
                <h:outputText value="#{msgs['blogtitleview.TheNumberOfBlogItemLabel']}" styleClass="portlet-form-field"/>
            </h:outputLabel>
            <h:inputText id="number" value="#{titleViewEditPage.pageSize}" size="30" styleClass="portlet-form-field-label" converter="javax.faces.Integer" required="true">
                <f:validateLongRange minimum="1"/>
            </h:inputText>

            <h:outputLabel for="displayedItems">
                <h:outputText value="#{msgs['blogtitleview.DisplayedItemsLabel']}" styleClass="portlet-form-field"/>
            </h:outputLabel>
            <h:selectManyCheckbox id="displayedItems" value="#{titleViewEditPage.displayedItems}" styleClass="portlet-form-field">
                <f:selectItem itemValue="createdtime" itemLabel="#{msgs['blogtitleview.CreatedDateSelect']}"/>
                <f:selectItem itemValue="updatedtime" itemLabel="#{msgs['blogtitleview.UpdatedDateSelect']}"/>
            </h:selectManyCheckbox>
    
            <h:commandButton action="#{titleViewEditPage.save}" value="#{msgs['blogtitleview.SaveButton']}" styleClass="portlet-form-button"/>
            <h:commandButton action="#{titleViewEditPage.reset}" value="#{msgs['blogtitleview.ResetButton']}" styleClass="portlet-form-button"/>
        </h:panelGrid>
    </h:form>
</f:view>
