<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<f:view>
    <f:loadBundle basename="jp.sf.pal.blog.resources.BlogViewResources" var="msgs"/>
    <h:form id="redirectForm">
        <h:inputHidden id="blogid"/>
<script type="text/javascript">
<!--
function redirect() {
    var index = window.location.search.indexOf("?");
    if (index < window.location.search.length) {
        var params = window.location.search.substr(index + 1).split("&");
        var i = 0;
        for (i = 0; i < params.length; i++ ) {
            var pair = params[i].split("=");
            if (pair[0] == "blogid") {
                document.forms['redirectForm'].elements['redirectForm:blogid'].value = pair[1];
                document.forms['redirectForm'].submit();
            }
        }
    }
}
redirect();
// -->
</script>
    </h:form>
    <!-- List View -->
    <h:form rendered='#{viewPage.mode=="ListView"}'>
        <t:dataTable
            id="listView"
            var="blogMsg" 
            value="#{viewPage.blogMessages}" 
            rowClasses="portlet-section-body,portlet-section-alternate" 
            style="width:100%"
            rows="#{viewPortlet.pageSize}"
            >
            <h:column>
                <t:htmlTag value="div" styleClass="portlet-section-header">
                    <h:outputText value="#{blogMsg['0'].title}"/>
                </t:htmlTag>
                <t:htmlTag value="div" style="padding:3px">
                    <h:outputText value="#{blogMsg['0'].formattedMessage}" styleClass="portlet-font" escape="false"/>
                </t:htmlTag>
                <t:htmlTag value="div" styleClass="portlet-section-footer" style="text-align:right">
                    <h:outputFormat value="#{msgs['blogview.PostedByNameAtDate']}">
                        <f:param value="#{blogMsg['0'].owner}"/>
                        <f:param value="#{blogMsg['0'].formattedCreatedtime}"/>
                    </h:outputFormat>
                    <t:htmlTag value="br"/>
                    <h:outputLink value="#{blogMsg['0'].redirectUrl}">
                        <h:outputText value="#{msgs['blogview.LinkToThisArticle']}"/>
                    </h:outputLink>
                </t:htmlTag>
            </h:column>
        </t:dataTable>
        <h:panelGrid columns="1" styleClass="portlet-section-footer" style="width:100%">
            <t:dataScroller
                    for="listView"
                    fastStep="10"
                    pageCountVar="pageCount"
                    pageIndexVar="pageIndex"
                    paginator="true"
                    paginatorMaxPages="9"
                    >
                <f:facet name="first">
                    <t:graphicImage url="/images/arrow-first.gif" border="1" rendered="#{pageIndex!=1}"/>
                </f:facet>
                <f:facet name="last">
                    <t:graphicImage url="/images/arrow-last.gif" border="1" rendered="#{pageIndex<pageCount}"/>
                </f:facet>
                <f:facet name="previous">
                    <t:graphicImage url="/images/arrow-previous.gif" border="1" rendered="#{pageIndex!=1}"/>
                </f:facet>
                <f:facet name="next">
                    <t:graphicImage url="/images/arrow-next.gif" border="1" rendered="#{pageIndex<pageCount}"/>
                </f:facet>
            </t:dataScroller>
            <t:dataScroller
                    for="listView"
                    rowsCountVar="rowsCount"
                    displayedRowsCountVar="displayedRowsCountVar"
                    firstRowIndexVar="firstRowIndex"
                    lastRowIndexVar="lastRowIndex"
                    pageCountVar="pageCount"
                    immediate="true"
                    pageIndexVar="pageIndex"
                    >
                <h:outputFormat value="#{msgs['blogview.FoundDisplayingItemsFromToPage']}" 
                    rendered="#{rowsCount!=0}">
                    <f:param value="#{rowsCount}" />
                    <f:param value="#{displayedRowsCountVar}" />
                    <f:param value="#{firstRowIndex}" />
                    <f:param value="#{lastRowIndex}" />
                    <f:param value="#{pageIndex}" />
                    <f:param value="#{pageCount}" />
                </h:outputFormat>
                <h:outputText value="#{msgs['blogview.NoItems']}" rendered="#{rowsCount==0}"/>
            </t:dataScroller>
        </h:panelGrid>
    </h:form>
    
    <!-- Content View -->
    <h:form rendered='#{viewPage.mode=="ContentView"}'>
        <t:htmlTag value="div" styleClass="portlet-section-header">
            <h:outputText value="#{viewPage.blogMessage.title}"/>
        </t:htmlTag>
        <t:htmlTag value="div" style="padding:3px">
            <h:outputText value="#{viewPage.blogMessage.formattedMessage}" styleClass="portlet-font" escape="false"/>
        </t:htmlTag>
        <t:htmlTag value="div" styleClass="portlet-section-footer" style="text-align:right">
            <h:outputFormat value="#{msgs['blogview.PostedByNameAtDate']}">
                <f:param value="#{viewPage.blogMessage.owner}"/>
                <f:param value="#{viewPage.blogMessage.formattedCreatedtime}"/>
            </h:outputFormat>
        </t:htmlTag>
        <h:panelGrid border="0">
            <h:commandLink action="#{viewPage.listView}" styleClass="portlet-form-button">
                <h:outputText value="#{msgs['blogview.All']}" escape="false"/>
            </h:commandLink>
        </h:panelGrid>
    </h:form>
</f:view>
