<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle
		basename="jp.sf.pal.charttest.resources.ChartTestResources" var="msgs" />

	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<h:panelGrid columns="2">

			<h:outputLabel for="chartType">
				<h:outputText value="#{msgs['inputvalue.ChartType']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:selectOneMenu id="chartType" value="#{chartTestSession.chartType}"
				styleClass="portlet-form-field-label">
				<f:selectItem itemValue="PIE_CHART_3D" itemLabel="Pie chart 3D" />
				<f:selectItem itemValue="PIE_CHART_2D" itemLabel="Pie chart 2D" />
				<f:selectItem itemValue="LINE_CHART" itemLabel="Line chart" />
				<f:selectItem itemValue="STACK_BAR_CHART"
					itemLabel="Stack Bar Chart" />
				<f:selectItem itemValue="BAR_CHART" itemLabel="Bar Chart" />
				<f:selectItem itemValue="BAR_CHART_2D" itemLabel="Bar Chart 2D" />
				<f:selectItem itemValue="AREA_CHART" itemLabel="Area Chart" />
			</h:selectOneMenu>

			<h:outputLabel for="chartTitle">
				<h:outputText value="#{msgs['inputvalue.ChartTitle']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="chartTitle" value="#{chartTestSession.chartTitle}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="title">
				<h:outputText value="#{msgs['inputvalue.Title']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="title" value="#{chartTestSession.title}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="axisXLabel">
				<h:outputText value="#{msgs['inputvalue.AxisXLabel']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="axisXLabel" value="#{chartTestSession.axisXLabel}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="axisYLabel">
				<h:outputText value="#{msgs['inputvalue.AxisYLabel']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="axisYLabel" value="#{chartTestSession.axisYLabel}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="fileType">
				<h:outputText value="#{msgs['inputvalue.FileType']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:selectOneMenu id="fileType" value="#{chartTestSession.fileType}"
				styleClass="portlet-form-field-label">
				<f:selectItem itemValue="jpg" itemLabel="jpg" />
				<f:selectItem itemValue="png" itemLabel="png" />
				<f:selectItem itemValue="svg" itemLabel="svg" />
			</h:selectOneMenu>

			<h:outputLabel for="color">
				<h:outputText value="#{msgs['inputvalue.Color']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="color" value="#{chartTestSession.color}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="width">
				<h:outputText value="#{msgs['inputvalue.Width']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="width" value="#{chartTestSession.width}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="height">
				<h:outputText value="#{msgs['inputvalue.Height']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="height" value="#{chartTestSession.height}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="transparency">
				<h:outputText value="#{msgs['inputvalue.Transparency']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="transparency"
				value="#{chartTestSession.transparency}"
				styleClass="portlet-form-field-label" required="true" />


			<h:outputLabel for="name1">
				<h:outputText value="#{msgs['inputvalue.Name1']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="name1" value="#{chartTestSession.name1}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="name2">
				<h:outputText value="#{msgs['inputvalue.Name2']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="name2" value="#{chartTestSession.name2}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="name3">
				<h:outputText value="#{msgs['inputvalue.Name3']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="name3" value="#{chartTestSession.name3}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="name4">
				<h:outputText value="#{msgs['inputvalue.Name4']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="name4" value="#{chartTestSession.name4}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="name5">
				<h:outputText value="#{msgs['inputvalue.Name5']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="name5" value="#{chartTestSession.name5}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="value1">
				<h:outputText value="#{msgs['inputvalue.Value1']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="value1" value="#{chartTestSession.value1}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="value2">
				<h:outputText value="#{msgs['inputvalue.Value2']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="value2" value="#{chartTestSession.value2}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="value3">
				<h:outputText value="#{msgs['inputvalue.Value3']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="value3" value="#{chartTestSession.value3}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="value4">
				<h:outputText value="#{msgs['inputvalue.Value4']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="value4" value="#{chartTestSession.value4}"
				styleClass="portlet-form-field-label" required="true" />

			<h:outputLabel for="value5">
				<h:outputText value="#{msgs['inputvalue.Value5']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="value5" value="#{chartTestSession.value5}"
				styleClass="portlet-form-field-label" required="true" />

			<f:facet name="footer">
				<h:commandButton action="NAVI_TO_DISPLAYCHART"
					value="#{msgs['inputvalue.Input']}"
					styleClass="portlet-form-button" />
			</f:facet>

		</h:panelGrid>

	</h:form>

</f:view>
