package jp.sf.pal.blog.bean;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.importer.Importer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.util.LocaleUtil;

public class BlogMigrationPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(BlogMigrationPageBean.class);

    private String formattype;

    private UploadedFile uploadedFile;

    public String importFile()
    {
        if (log.isDebugEnabled())
        {
            log.debug("importFile() - start ");
            log.debug("importFile() - getUploadedFile()=" + getUploadedFile());
        }

        try
        {
            if (getUploadedFile() != null
                    && getUploadedFile().getInputStream() != null)
            {
                File importFile = File.createTempFile("export", ".xml");

                BufferedInputStream bis = null;
                BufferedOutputStream bos = null;
                try
                {
                    bis = new BufferedInputStream(getUploadedFile()
                            .getInputStream());
                    bos = new BufferedOutputStream(new FileOutputStream(
                            importFile));

                    byte buf[] = new byte[256];
                    int len;
                    while ((len = bis.read(buf)) != -1)
                    {
                        bos.write(buf, 0, len);
                    }
                }
                catch (FileNotFoundException e)
                {
                    log.error("importFile()", e);

                    //TODO i18n
                    FacesMessageUtil.addErrorMessage("System error occurred.",
                            e.toString());

                    if (log.isDebugEnabled())
                    {
                        log.debug("importFile() - end");
                    }
                    return null;
                }
                catch (IOException e)
                {
                    log.error("importFile()", e);

                    //TODO i18n
                    FacesMessageUtil.addErrorMessage("System error occurred.",
                            e.toString());

                    if (log.isDebugEnabled())
                    {
                        log.debug("importFile() - end");
                    }
                    return null;
                }
                finally
                {
                    try
                    {
                        if (bos != null)
                        {
                            bos.flush();
                            bos.close();
                        }
                    }
                    catch (IOException e)
                    {
                        log.error("importFile()", e);

                        //TODO i18n
                        FacesMessageUtil.addErrorMessage(
                                "System error occurred.", e.toString());

                        if (log.isDebugEnabled())
                        {
                            log.debug("importFile() - end");
                        }
                        return null;
                    }
                    try
                    {
                        if (bis != null)
                        {
                            bis.close();
                        }
                    }
                    catch (IOException e)
                    {
                        log.error("importFile()", e);

                        //TODO i18n
                        FacesMessageUtil.addErrorMessage(
                                "System error occurred.", e.toString());

                        if (log.isDebugEnabled())
                        {
                            log.debug("importFile() - end");
                        }
                        return null;
                    }
                }

                String username = FacesContext.getCurrentInstance()
                        .getExternalContext().getRemoteUser();
                if (username != null)
                {
                    S2Container container = SingletonS2ContainerFactory
                            .getContainer();

                    List list = (List) container
                            .getComponent(BlogConstants.IMPORTER_LIST);
                    Iterator ite = list.iterator();
                    while (ite.hasNext())
                    {
                        Object obj = ite.next();
                        if (obj instanceof Importer)
                        {
                            Importer importer = (Importer) obj;
                            importer.setImportFile(importFile);
                            importer.setOwner(username);
                            importer.start();

                            //TODO i18n
                            FacesMessageUtil
                                    .addInfoMessage("Start importing..");
                        }
                        else
                        {
                            //TODO i18n
                            FacesMessageUtil
                                    .addErrorMessage("Could not find a specified Importer.");
                        }
                    }
                }
                else
                {
                    //TODO i18n
                    FacesMessageUtil.addErrorMessage("Unknown user.");

                    if (log.isDebugEnabled())
                    {
                        log.debug("importFile() - end");
                    }
                    return null;
                }
            }
            else
            {
                // uploaded file is null
                //TODO i18n
                FacesMessageUtil.addErrorMessage("The uploaded file is null.");
            }
        }
        catch (IOException e)
        {
            log.error("importFile()", e);

            //TODO i18n
            FacesMessageUtil.addErrorMessage("The upload process might fail.");
        }

        if (log.isDebugEnabled())
        {
            log.debug("importFile() - end");
        }
        return null;
    }

    /**
     * @return Returns the formattype.
     */
    public String getFormattype()
    {
        if (formattype == null)
        {
            S2Container container = SingletonS2ContainerFactory.getContainer();

            List list = (List) container
                    .getComponent(BlogConstants.IMPORTER_LIST);
            Iterator ite = list.iterator();
            if (ite.hasNext())
            {
                Object obj = ite.next();
                if (obj instanceof Importer)
                {
                    return ((Importer) obj).getFormatType();
                }
            }
            throw new IllegalArgumentException("Importer does not exist.");
        }
        return formattype;
    }

    /**
     * @param formattype The formattype to set.
     */
    public void setFormattype(String format)
    {
        this.formattype = format;
    }

    /**
     * @return Returns the uploadedFile.
     */
    public UploadedFile getUploadedFile()
    {
        return uploadedFile;
    }

    /**
     * @param uploadedFile The uploadedFile to set.
     */
    public void setUploadedFile(UploadedFile uploadedFile)
    {
        this.uploadedFile = uploadedFile;
    }

    public SelectItem[] getFormattypeItems()
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        List list = (List) container.getComponent(BlogConstants.IMPORTER_LIST);
        Iterator ite = list.iterator();
        SelectItem[] items = new SelectItem[list.size()];
        Locale locale = FacesContext.getCurrentInstance().getViewRoot()
                .getLocale();
        int i = 0;
        while (ite.hasNext())
        {
            Object obj = ite.next();
            if (obj instanceof Importer)
            {
                Importer importer = (Importer) obj;
                Map localizedNames = importer.getLocalizedNames();
                Iterator keys = localizedNames.keySet().iterator();
                while (keys.hasNext())
                {
                    String localeString = (String) keys.next();
                    if (LocaleUtil.fallback(locale, LocaleUtil
                            .convert(localeString)) != null)
                    {
                        items[i] = new SelectItem(importer.getFormatType(),
                                (String) localizedNames.get(localeString));
                        i++;
                        break;
                    }
                }
            }
            else
            {
                throw new IllegalArgumentException("Invalid importer: " + obj);
            }
        }
        //TODO i18n
        return items;
    }
}
