/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.portlet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;
import java.util.Iterator;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.util.BlogMessaging;

public class BlogViewPortlet extends BlogGenericPortlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogViewPortlet.class);

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.portlet.BlogGenericPortlet#processAction(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest request, ActionResponse response)
            throws PortletException, IOException
    {
        super.processAction(request, response);
//TODO
        String blogId = null;
        Iterator ite = request.getParameterMap().keySet().iterator();
        while (ite.hasNext())
        {
            String key = ite.next().toString();

            //TODO remove
            if (log.isDebugEnabled())
            {
                log
                        .debug("processAction(ActionRequest, ActionResponse) -  : key="
                                + key);
            }
            if (key.indexOf(BlogConstants.BLOG_REDIRECT_ID) >= 0)
            {
                blogId = request.getParameter(key);
            }
        }
        if (log.isDebugEnabled())
        {
            log
                    .debug("processAction(ActionRequest, ActionResponse) -  : blogId="
                            + blogId);
        }
        if (blogId != null)
        {
            BlogMessaging.publishForView(BlogConstants.BLOG_MESSAGE_ID,
                    new Long(blogId));
        }

    }

}
