<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<f:view>
	<f:loadBundle
		basename="jp.sf.pal.blog.resources.BlogMigrationResources" var="msgs" />
	<h:form enctype="multipart/form-data">
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<t:htmlTag value="div" styleClass="portlet-section-header">
            Import
        </t:htmlTag>
		<h:panelGrid columns="2" border="0">
			<!-- Title -->
			<h:outputLabel for="fileupload">
				<h:outputText value="File:" styleClass="portlet-form-field" />
			</h:outputLabel>
			<t:inputFileUpload id="fileupload"
				value="#{migrationPage.uploadedFile}" storage="file"
				styleClass="portlet-form-field-label" />
			<!-- Format -->
			<h:outputLabel for="format">
				<h:outputText value="Format:" styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:selectOneMenu id="format" value="#{migrationPage.formattype}"
				styleClass="portlet-form-field-label">
				<f:selectItems value="#{migrationPage.formattypeItems}" />
			</h:selectOneMenu>
		</h:panelGrid>
		<!-- Import -->
		<h:panelGrid columns="1" border="0">
			<h:commandButton action="#{migrationPage.importFile}" value="Import"
				styleClass="portlet-form-button" />
		</h:panelGrid>
	</h:form>
</f:view>
