<%--
	Copyright 2005-2006 The Portal Application Laboratory Team.
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License.
	You may obtain a copy of the License at
    	http://www.apache.org/licenses/LICENSE-2.0
	Unless required by applicable law or agreed to in writing, software
	distributed under the License is distributed on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	See the License for the specific language governing permissions and
	limitations under the License.
--%>

<%@ taglib uri='http://java.sun.com/portlet' prefix='portlet'%>
<%@ taglib uri="http://java.sun.com/jstl/fmt" prefix="fmt" %>
<%@ page import="java.util.*"%>

<jsp:useBean id="weather" class="jp.sf.pal.weather.Weather" scope="request" />
<fmt:setBundle basename="jp.sf.pal.weather.resources.WeatherResources" />
<portlet:defineObjects/>

<form action="<portlet:actionURL />" method="POST">
<table width="100%" border="1">
	<tr>
		<td colspan="2" align="center">
		<a href="<jsp:getProperty name="weather" property="link" />" style="font-size:x-small;">
		<jsp:getProperty name="weather" property="title" />
		</a>
		</td>
	</tr>
	<tr>
		<td colspan="2" align="center">
		<span style="font-size:x-small">(
		<fmt:message key="weather.label.Publictime"/>:
		<jsp:getProperty name="weather" property="publictime" />
		)
		</span>
		</td>
	</tr>
	<tr>
		<td align="center" colspan="2">
		<a href="<jsp:getProperty name="weather" property="imgLink" />">
		<img src="<jsp:getProperty name="weather" property="imgUrl" />"
		     alt="<jsp:getProperty name="weather" property="imgTitle" />"
		     width="<jsp:getProperty name="weather" property="imgWidth" />"
		     height="<jsp:getProperty name="weather" property="imgHeight" />"
		     border="0" />
		</a>
		</td>
	</tr>
	<tr>
		<td align="center" colspan="2" style="font-size: x-small;">
		<jsp:getProperty name="weather" property="telop" /></td>
	</tr>
	<tr>
		<td align="center" colspan="2" style="font-size: x-small;">
			<span style="color: red">
			<fmt:message key="weather.label.High" />:
			<jsp:getProperty name="weather" property="tempMaxOutput" /></span>
			&nbsp; &nbsp;
			<span style="color: blue" /><fmt:message key="weather.label.Low" />:
			<jsp:getProperty name="weather" property="tempMinOutput" /></span>
		</td>
	</tr>
	<tr>
		<td align="right" style="font-size: x-small;" width="10%">
		<fmt:message key="weather.label.Overview"/>:</td>
		<td align="left" style="font-size: x-small">
		<jsp:getProperty name="weather" property="description" />
		</td>
	</tr>
	<tr>
		<td align="center" colspan="2">
		<a href="<jsp:getProperty name="weather" property="copyrightLink" />" style="font-size:x-small">
		<jsp:getProperty name="weather" property="copyrightTitle" />
		</a>
		</td>
	</tr>
	<tr>
		<td align="right" width="10%" style="font-size: x-small;">
		<fmt:message key="weather.label.Area"/>:
		</td>
		<td align="center">
		<select name="city">
			<option value="default"><fmt:message key="weather.label.SelectArea"/>	</option>
<%
	Map			cityMap = (Map)renderRequest.getAttribute("city") ;
	String		reqId = (String)renderRequest.getAttribute("id") ;
	Iterator	it = cityMap.keySet().iterator() ;
	while (it.hasNext()) {
		Integer id = (Integer)it.next() ;
		String cityId = id.toString() ;
		String cityName = (String)cityMap.get(id) ;
		String selected = "" ;
		if (reqId.equals(cityId)) {
			selected = "selected" ;
		}
%>
			<option value="<%= cityId %>" <%= selected %>><%= cityName %></option>
<%
	}
%>
		</select>
		</td>
	</tr>
	<tr class="portlet-section-body">
		<td colspan="2" align="center">
		<input type="submit" value="<fmt:message key="weather.label.Submit"/>">
		</td>
	</tr>
</table>
</form>
