/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.googlegadgets;

import java.io.IOException;
import java.util.ResourceBundle;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * This portlet displays Google Gadgets.
 * 
 * @author <a href="mailto:shinsuke@yahoo.co.jp">Shinsuke Sugaya</a>
 */
public class GoogleGadgetsPortlet extends GenericPortlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(GoogleGadgetsPortlet.class);

    public static final String TITLE_KEY = "jp.sf.pal.googlegadgets.title";

    public static final String CODE_KEY = "jp.sf.pal.googlegadgets.code";

    public static final String GADGET_URL_KEY = "jp.sf.pal.googlegadgets.gadgetUrl";

    public static final String MESSAGE = "jp.sf.pal.googlegadgets.message";

    private String defaultCode = "";

    private String defaultGagetUrl = "";

    /* (non-Javadoc)
     * @see javax.portlet.Portlet#init(javax.portlet.PortletConfig)
     */
    public void init(PortletConfig config) throws PortletException
    {
        super.init(config);

        defaultCode = config.getInitParameter(CODE_KEY);
        defaultGagetUrl = config.getInitParameter(GADGET_URL_KEY);
    }

    /* (non-Javadoc)
     * @see javax.portlet.GenericPortlet#doView(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    protected void doView(RenderRequest request, RenderResponse response)
            throws PortletException, IOException
    {
        String viewPage = "/WEB-INF/jsp/view.jsp";
        renderView(request, response, viewPage);
    }

    /* (non-Javadoc)
     * @see javax.portlet.GenericPortlet#doEdit(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    protected void doEdit(RenderRequest request, RenderResponse response)
            throws PortletException, IOException
    {
        String viewPage = "/WEB-INF/jsp/edit.jsp";
        String msg = request.getParameter(MESSAGE);
        if (msg == null)
        {
            msg = "";
        }
        request.setAttribute(MESSAGE, msg);
        request.setAttribute(GADGET_URL_KEY, defaultGagetUrl);

        renderView(request, response, viewPage);
    }

    protected void renderView(RenderRequest request, RenderResponse response,
            String viewPage) throws PortletException, IOException
    {
        response.setContentType("text/html");

        setTitle(request, response);

        PortletContext context = getPortletContext();
        PortletPreferences prefs = request.getPreferences();
        request.setAttribute(CODE_KEY, prefs.getValue(CODE_KEY, defaultCode));
        PortletRequestDispatcher rd = context.getRequestDispatcher(viewPage);
        rd.include(request, response);
    }

    /* (non-Javadoc)
     * @see javax.portlet.Portlet#processAction(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest request, ActionResponse response)
            throws PortletException, IOException
    {
        if (request.getPortletMode().equals(PortletMode.EDIT))
        {
            String value = request.getParameter(CODE_KEY);
            if (value == null)
            {
                value = "";
            }
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(CODE_KEY, value);
            prefs.store();

            ResourceBundle bundle = getPortletConfig().getResourceBundle(
                    request.getLocale());
            response.setRenderParameter(MESSAGE, bundle
                    .getString("GoogleGadgetsPortlet.msg.Updated"));
        }

        return;
    }

    protected void setTitle(RenderRequest request, RenderResponse response)
    {
        //TODO i18n
        response.setTitle(getPortletConfig().getInitParameter(TITLE_KEY));
    }
}
