/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.jstock.dto;

import java.math.BigDecimal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.sf.pal.jstock.bean.StockData;

public class StockDataDto extends StockData {
    
    private static final Log log = LogFactory.getLog(StockDataDto.class);
    
    /**
     * 株価の文字列表現を返す
     * @return
     */
    public String getPriceString() {
        if (this.getPrice() == null) {
            return new String("--");
        } else {
            return this.getPrice().toPlainString();
        }
    }
    
    /**
     * 株価の前日比の文字列表現を返す
     * @return
     */
    public String getChangeString() {
        if (this.getChange() == null) {
            return new String("--");
        } else {
            StringBuffer buf = new StringBuffer();
            if (this.getChange().compareTo(new BigDecimal("0")) >= 0) {
                buf.append("+");
            }
            return buf.append(this.getChange().toPlainString()).toString();
        }
    }
    
    /**
     * 株価が前日より高かったかどうかを返す
     * @return 高かった場合 true
     */
    public boolean isPriceUp() {
        if (this.getChange() == null) {
            return false;
        } else {
            if (this.getChange().compareTo(new BigDecimal("0")) >= 0) {
                return true;
            } else {
                return false;
            }
        }
    }
    
    /**
     * 株価が前日より安かったどうか返す
     * @return 安かった場合 true
     */
    public boolean isPriceDown() {
        if (this.getChange() == null) {
            return true;
        } else {
            if (this.getChange().compareTo(new BigDecimal("0")) >= 0) {
                return false;
            } else {
                return true;
            }
        }
    }
    
}
