<%--
	Copyright 2005-2006 The Portal Application Laboratory Team.
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License.
	You may obtain a copy of the License at
    	http://www.apache.org/licenses/LICENSE-2.0
	Unless required by applicable law or agreed to in writing, software
	distributed under the License is distributed on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	See the License for the specific language governing permissions and
	limitations under the License.
--%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>

<f:loadBundle basename="jp.sf.pal.jstock.resources.JStockResources" var="message" />

<f:view>

	<h:dataTable id="dataTable"
		value="#{reader.stockDataList}"
		var="item"
		style="width:100%"
		rowClasses="portlet-section-body,portlet-section-alternate"
		headerClass="portlet-section-subheader"
		border="1">
		<h:column>
			<f:facet name="header">
				<h:outputText value="#{message['jstock.Name']}"/>
			</f:facet>
			<h:outputText value="#{item.name}"/>
		</h:column>
		<h:column>
			<f:facet name="header">
				<h:outputText value="#{message['jstock.LastTrade']}"/>
			</f:facet>
			<h:outputText value="#{item.priceString}"/>
		</h:column>
		<h:column>
			<f:facet name="header">
				<h:outputText value="#{message['jstock.Change']}"/>
			</f:facet>
			<h:outputText value="#{item.changeString}" rendered="#{item.priceUp}" style="color: red"/>
			<h:outputText value="#{item.changeString}" rendered="#{item.priceDown}" style="color: green"/>
		</h:column>
		<h:column>
			<f:facet name="header">
				<h:outputText value="#{message['jstock.TradeTime']}"/>
			</f:facet>
			<h:outputText value="#{item.time}"/>
		</h:column>
	</h:dataTable>
	
</f:view>