/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.pooptimizer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import jp.sf.pal.facesresponse.io.BufferedResponseStream;
import jp.sf.pal.facesresponse.io.BufferedResponseStreamFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

/**
 * @author shinsuke
 * 
 */
public class OptimizerFilter implements PortletFilter {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(OptimizerFilter.class);

    private static final int BLOCK_SIZE = 4096;

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#destroy()
     */
    public void destroy() {

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#init(org.apache.portals.bridges.portletfilter.PortletFilterConfig)
     */
    public void init(PortletFilterConfig config) throws PortletException {

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#processActionFilter(javax.portlet.ActionRequest,
     *      javax.portlet.ActionResponse,
     *      org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void processActionFilter(ActionRequest request,
            ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("called processActionFilter.");
        }

        // call next processActionFilter
        chain.processActionFilter(request, response);

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#renderFilter(javax.portlet.RenderRequest,
     *      javax.portlet.RenderResponse,
     *      org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void renderFilter(RenderRequest request, RenderResponse response,
            PortletFilterChain chain) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("called renderFilter.");
        }

        // call next rednerFilter
        chain.renderFilter(request, response);

        BufferedResponseStream bufferedResponseStream = BufferedResponseStreamFactory
                .getBufferedResponseStream(request);
        if (bufferedResponseStream != null) {
            if (log.isDebugEnabled()) {
                log
                        .debug("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - bufferedResponseStream="
                                + bufferedResponseStream);
            }

            // just in case, commit it.
            bufferedResponseStream.commit();

            InputStream reader = bufferedResponseStream.getInputStream();
            BufferedWriter writer = new BufferedWriter(bufferedResponseStream
                    .getWriter());

            byte[] bytes = new byte[BLOCK_SIZE];
            try {
                int length = reader.read(bytes);
                String str = new String(bytes, 0, length,
                        bufferedResponseStream.getEncoding());
                int beginBodyIndex = str.indexOf("<body");
                if (beginBodyIndex >= 0) {
                    str = str.substring(beginBodyIndex).replaceFirst(
                            "<body[^>]*>", "");
                    int endBodyIndex = str.indexOf("</body");
                    if (endBodyIndex >= 0) {
                        writer.write(str.substring(0, endBodyIndex));
                    } else {
                        length = reader.read(bytes);
                        while (length != -1) {
                            str = new String(bytes, 0, length,
                                    bufferedResponseStream.getEncoding());
                            endBodyIndex = str.indexOf("</body");
                            if (endBodyIndex >= 0) {
                                writer.write(str.substring(0, endBodyIndex));
                                break;
                            } else {
                                if (length != 0) {
                                    writer.write(str);
                                }
                                length = reader.read(bytes);
                            }
                        }
                    }
                } else {
                    if (length != -1) {
                        writer.write(str);
                    }
                    length = reader.read(bytes);
                    while (length != -1) {
                        str = new String(bytes, 0, length,
                                bufferedResponseStream.getEncoding());
                        if (length != 0) {
                            writer.write(str);
                        }
                        length = reader.read(bytes);
                    }
                }
                writer.flush();
            } finally {
                bytes = null;
            }

            bufferedResponseStream.commit();
        } else {
            if (log.isWarnEnabled()) {
                log.warn("BufferedResponseStream is null.");
            }
        }
    }

}
