/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesdevfilter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import jp.sf.pal.facesdevfilter.FacesDevConstants;
import jp.sf.pal.facesdevfilter.portlet.PortalContextImpl;
import jp.sf.pal.facesdevfilter.portlet.PortletConfigImpl;
import jp.sf.pal.facesdevfilter.portlet.PortletPreferencesImpl;
import jp.sf.pal.facesdevfilter.portlet.PortletSessionImpl;
import jp.sf.pal.facesdevfilter.util.Enumerator;

public class HttpServletPortletRequestWrapper
extends HttpServletRequestWrapper
implements PortletRequest,
ActionRequest,
RenderRequest {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PortletPreferences portletPreferences;

    public HttpServletPortletRequestWrapper(HttpServletRequest request, HttpServletResponse response) {
        super(request);
        this.request = request;
        this.response = response;
    }

    public PortalContext getPortalContext() {
        return new PortalContextImpl();
    }

    public PortletMode getPortletMode() {
        return (PortletMode)this.getSession().getAttribute(FacesDevConstants.PORTLET_MODE);
    }

    public PortletSession getPortletSession() {
        return new PortletSessionImpl(this.request.getSession());
    }

    public PortletSession getPortletSession(boolean create) {
        return new PortletSessionImpl(this.request.getSession(create));
    }

    public PortletPreferences getPreferences() {
        if (this.portletPreferences == null) {
            this.portletPreferences = new PortletPreferencesImpl(this.request.getSession());
        }
        return this.portletPreferences;
    }

    public Enumeration getProperties(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        HashSet v = new HashSet();
        Enumeration props = this.request.getHeaders(name);
        if (props != null) {
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
        }
        return new Enumerator(v.iterator());
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        String prop = this.request.getHeader(name);
        if (prop == null) {
            // empty if block
        }
        return prop;
    }

    public Enumeration getPropertyNames() {
        HashSet v = new HashSet();
        Enumeration props = this.request.getHeaderNames();
        if (props != null) {
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
        }
        return new Enumerator(v.iterator());
    }

    public String getResponseContentType() {
        return "text/html";
    }

    public Enumeration getResponseContentTypes() {
        HashSet<String> responseMimeTypes = new HashSet<String>();
        responseMimeTypes.add("text/html");
        return new Enumerator(responseMimeTypes.iterator());
    }

    public WindowState getWindowState() {
        return (WindowState)this.getSession().getAttribute(FacesDevConstants.WINDOW_STATE);
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        PortletConfigImpl portletConfig = (PortletConfigImpl)this.getSession().getAttribute("javax.portlet.PortletConfig");
        Iterator ite = portletConfig.getPortlet().getPortletModes().iterator();
        while (ite.hasNext()) {
            PortletMode m = (PortletMode)ite.next();
            if (!m.equals(mode)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindowStateAllowed(WindowState state) {
        Enumeration e = this.getPortalContext().getSupportedWindowStates();
        while (e.hasMoreElements()) {
            WindowState s = (WindowState)e.nextElement();
            if (!s.equals(state)) continue;
            return true;
        }
        return false;
    }

    public InputStream getPortletInputStream() throws IOException {
        return this.request.getInputStream();
    }
}

