/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.facesdevfilter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.portlet.ActionRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

import jp.sf.pal.facesdevfilter.FacesDevConstants;
import jp.sf.pal.facesdevfilter.portlet.PortalContextImpl;
import jp.sf.pal.facesdevfilter.portlet.PortletConfigImpl;
import jp.sf.pal.facesdevfilter.portlet.PortletPreferencesImpl;
import jp.sf.pal.facesdevfilter.portlet.PortletSessionImpl;
import jp.sf.pal.facesdevfilter.util.Enumerator;

public class HttpServletPortletRequestWrapper extends HttpServletRequestWrapper
        implements PortletRequest, ActionRequest, RenderRequest {
    private HttpServletRequest request;

    private HttpServletResponse response;

    private PortletPreferences portletPreferences;

    public HttpServletPortletRequestWrapper(HttpServletRequest request,
            HttpServletResponse response) {
        super(request);
        this.request = request;
        this.response = response;
    }

    // PortletRequest
    public PortalContext getPortalContext() {
        return new PortalContextImpl();
    }

    public PortletMode getPortletMode() {
        return (PortletMode) getSession().getAttribute(
                FacesDevConstants.PORTLET_MODE);
    }

    public PortletSession getPortletSession() {
        return new PortletSessionImpl(request.getSession());
    }

    public PortletSession getPortletSession(boolean create) {
        return new PortletSessionImpl(request.getSession(create));
    }

    public PortletPreferences getPreferences() {
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl(request
                    .getSession());
        }
        return portletPreferences;
    }

    public Enumeration getProperties(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }

        Set v = new HashSet();

        // get properties from request header
        Enumeration props = request.getHeaders(name);
        if (props != null) {
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
        }

        // TODO if an additional property exists..

        return new Enumerator(v.iterator());

    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }

        // get properties from request header
        String prop = request.getHeader(name);
        if (prop == null) {
            // TODO if an additional property exists..
        }

        return prop;
    }

    public Enumeration getPropertyNames() {
        Set v = new HashSet();

        // TODO if an additional property exists..

        // get properties from request header
        Enumeration props = request.getHeaderNames();
        if (props != null) {
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
        }

        return new Enumerator(v.iterator());

    }

    public String getResponseContentType() {
        return "text/html";
    }

    public Enumeration getResponseContentTypes() {
        HashSet responseMimeTypes = new HashSet();
        responseMimeTypes.add("text/html");

        return new Enumerator(responseMimeTypes.iterator());
    }

    public WindowState getWindowState() {
        return (WindowState) getSession().getAttribute(
                FacesDevConstants.WINDOW_STATE);
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        PortletConfigImpl portletConfig = (PortletConfigImpl) getSession()
                .getAttribute(FacesDevConstants.PORTLET_CONFIG);
        Iterator ite = portletConfig.getPortlet().getPortletModes().iterator();
        while (ite.hasNext()) {
            PortletMode m = (PortletMode) ite.next();
            if (m.equals(mode)) {
                return true;
            }
        }
        return false;
    }

    public boolean isWindowStateAllowed(WindowState state) {
        Enumeration e = getPortalContext().getSupportedWindowStates();
        while (e.hasMoreElements()) {
            WindowState s = (WindowState) e.nextElement();
            if (s.equals(state)) {
                return true;
            }
        }
        return false;
    }

    // ActionRequest

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.ActionRequest#getPortletInputStream()
     */
    public InputStream getPortletInputStream() throws IOException {
        return request.getInputStream();
    }

    // RenderRequest
}
