/*
 * Copyright 2005-2006 Portal Application Laboratory project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.facesdevfilter.portlet;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

import jp.sf.pal.facesdevfilter.portlet.descriptors.PortletNode;
import jp.sf.pal.facesdevfilter.util.Enumerator;

/**
 * @author shinsuke
 * 
 */
public class PortletConfigImpl implements PortletConfig {
    private ServletContext servletContext;

    private PortletNode portlet;

    public PortletConfigImpl(ServletContext servletCotext, PortletNode portlet) {
        this.portlet = portlet;
        this.servletContext = servletCotext;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletConfig#getInitParameter(java.lang.String)
     */
    public String getInitParameter(String key) {
        return (String) portlet.getInitParams().get(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletConfig#getInitParameterNames()
     */
    public Enumeration getInitParameterNames() {
        return new Enumerator(portlet.getInitParams().keySet().iterator());
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletConfig#getPortletContext()
     */
    public PortletContext getPortletContext() {
        return new PortletContextImpl(servletContext);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletConfig#getPortletName()
     */
    public String getPortletName() {
        return portlet.getPortletName();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletConfig#getResourceBundle(java.util.Locale)
     */
    public ResourceBundle getResourceBundle(Locale locale) {
        return new PortletResourceBundle(portlet, locale);
    }

    /**
     * @return Returns the portlet.
     */
    public PortletNode getPortlet() {
        return portlet;
    }

}
