/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.facesdevfilter.portlet;

import java.util.Enumeration;

import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;

/**
 * 
 * 
 * @author shinsuke
 * 
 */
public class PortletSessionImpl implements PortletSession {

    private HttpSession httpSession;

    public PortletSessionImpl(HttpSession httpSession) {

        this.httpSession = httpSession;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#getAttribute(java.lang.String)
     */
    public Object getAttribute(String name) {
        // NOTE: return an attribute regardless of the scope
        return httpSession.getAttribute(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#getAttribute(java.lang.String, int)
     */
    public Object getAttribute(String name, int scope) {
        // NOTE: return an attribute regardless of the scope
        return httpSession.getAttribute(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#getAttributeNames()
     */
    public Enumeration getAttributeNames() {
        // NOTE: store names including application scope
        return httpSession.getAttributeNames();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#getAttributeNames(int)
     */
    public Enumeration getAttributeNames(int scope) {
        // NOTE: store names including application scope
        return httpSession.getAttributeNames();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#getCreationTime()
     */
    public long getCreationTime() {
        return httpSession.getCreationTime();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#getId()
     */
    public String getId() {
        return httpSession.getId();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#getLastAccessedTime()
     */
    public long getLastAccessedTime() {
        return httpSession.getLastAccessedTime();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#getMaxInactiveInterval()
     */
    public int getMaxInactiveInterval() {
        return httpSession.getMaxInactiveInterval();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#getPortletContext()
     */
    public PortletContext getPortletContext() {
        // TODO Auto-generated method stub
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#invalidate()
     */
    public void invalidate() {
        httpSession.invalidate();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#isNew()
     */
    public boolean isNew() {
        return httpSession.isNew();
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#removeAttribute(java.lang.String)
     */
    public void removeAttribute(String name) {
        // NOTE: remove an attribute regardless of the scope
        httpSession.removeAttribute(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#removeAttribute(java.lang.String, int)
     */
    public void removeAttribute(String name, int scope) {
        // NOTE: remove an attribute regardless of the scope
        httpSession.removeAttribute(name);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#setAttribute(java.lang.String,
     *      java.lang.Object)
     */
    public void setAttribute(String name, Object value) {
        // NOTE: set an attribute regardless of the scope
        httpSession.setAttribute(name, value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#setAttribute(java.lang.String,
     *      java.lang.Object, int)
     */
    public void setAttribute(String name, Object value, int scope) {
        // NOTE: set an attribute regardless of the scope
        httpSession.setAttribute(name, value);
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.PortletSession#setMaxInactiveInterval(int)
     */
    public void setMaxInactiveInterval(int interval) {
        httpSession.setMaxInactiveInterval(interval);
    }

}
