/*
 * Copyright 2004-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.vfs.util;

import java.util.Comparator;

import jp.sf.pal.vfs.helper.FileParameterHelper;

/**
 * @author shinsuke
 * 
 */
public class FileParameterHelperComparator implements Comparator {

    /*
     * (non-Javadoc)
     * 
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    public int compare(Object arg0, Object arg1) {
        if (arg0 instanceof FileParameterHelper
                && arg1 instanceof FileParameterHelper) {
            FileParameterHelper param0 = (FileParameterHelper) arg0;
            FileParameterHelper param1 = (FileParameterHelper) arg1;
            if (param0.getBaseName() != null && param1.getBaseName() != null) {
                return param0.getBaseName().compareTo(param1.getBaseName());
            }
        }
        return 0;
    }

}
