/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.web.navigator;

import jp.sf.pal.vfs.VFSConstants;
import jp.sf.pal.vfs.util.VFSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.seasar.framework.container.S2Container;

import com.marevol.utils.faces.application.FacesMessageUtil;

public class CreateNewFolderPage extends DefaultPage {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(CreateNewFolderPage.class);

    private String newFolder;

    public CreateNewFolderPage(S2Container container) {
        super(container);
    }

    public String create() {
        if (!VFSUtil.checkPath(getUri())) {
            // TODO i18n
            FacesMessageUtil.addErrorMessage("access denied.");
            setUri(VFSUtil.getDefaultUri());
            return VFSConstants.DISPLAY_FOLDER_LIST_PAGE;
        }

        try {
            FileSystemManager fsManager = VFSUtil.getFileSystemManager();
            FileObject newFileObject = fsManager.resolveFile(getUri() + "/"
                    + getNewFolder());
            // TODO add confirmation
            // if (!newFileObject.exists())
            // {
            // TODO should catch exception to check if it's created
            newFileObject.createFolder();

            // TODO I18N
            FacesMessageUtil.addInfoMessage("Created new folder: "
                    + getNewFolder());
            return goDisplayFolderListPage();
            // }
        } catch (FileSystemException e) {
            // TODO I18N
            FacesMessageUtil.addInfoMessage("Failed to create the new folder.",
                    e.toString());
            log.error("Failed to create the new folder.", e);
        }
        return null;
    }

    /**
     * @return Returns the newFolder.
     */
    public String getNewFolder() {
        return newFolder;
    }

    /**
     * @param newFolder
     *            The newFolder to set.
     */
    public void setNewFolder(String newFolder) {
        this.newFolder = newFolder;
    }

}
