/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.vfs.web.navigator;

import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;

import jp.sf.pal.vfs.VFSConstants;
import jp.sf.pal.vfs.util.VFSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;

public class DefaultPage {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(DefaultPage.class);

    private S2Container container;

    public DefaultPage(S2Container container) {
        setContainer(container);
    }

    /**
     * @return the uri
     */
    public String getUri() {
        String uri = (String) FacesContext.getCurrentInstance()
                .getExternalContext().getSessionMap().get(VFSConstants.URI);
        if (uri == null) {
            uri = VFSUtil.getDefaultUri();
        }
        return uri;
    }

    /**
     * @param uri
     *            the uri to set
     */
    public void setUri(String uri) {
        FacesContext.getCurrentInstance().getExternalContext().getSessionMap()
                .put(VFSConstants.URI, uri);
    }

    public String goDisplayFolderListPage() {
        if (log.isDebugEnabled()) {
            log.debug("goToListViewPage()");
        }

        return VFSConstants.DISPLAY_FOLDER_LIST_PAGE;
    }

    public String goWriteNewFileContentPage() {
        if (log.isDebugEnabled()) {
            log.debug("goToNewFilePage()");
        }

        return VFSConstants.WRITE_NEW_FILE_CONTENT_PAGE;
    }

    public String goCreateNewFilePage() {
        if (log.isDebugEnabled()) {
            log.debug("goToNewFilePage()");
        }

        return VFSConstants.CREATE_NEW_FILE_PAGE;
    }

    public String goCreateNewFolderPage() {
        if (log.isDebugEnabled()) {
            log.debug("goToNewFolderPage()");
        }

        return VFSConstants.CREATE_NEW_FOLDER_PAGE;
    }

    public String goUploadFilePage() {
        return VFSConstants.UPLOAD_FILE_PAGE;
    }

    public String getCreateNewFileImage() {
        String path = FacesContext.getCurrentInstance().getExternalContext()
                .getRequestContextPath()
                + "/images/accessories-text-editor.png";
        return FacesContext.getCurrentInstance().getExternalContext()
                .encodeResourceURL(path);
    }

    public String getCreateNewFolderImage() {
        String path = FacesContext.getCurrentInstance().getExternalContext()
                .getRequestContextPath()
                + "/images/folder.png";
        return FacesContext.getCurrentInstance().getExternalContext()
                .encodeResourceURL(path);
    }

    public String getUploadFileImage() {
        String path = FacesContext.getCurrentInstance().getExternalContext()
                .getRequestContextPath()
                + "/images/document-save.png";
        return FacesContext.getCurrentInstance().getExternalContext()
                .encodeResourceURL(path);
    }

    public String getTrashImage() {
        String path = FacesContext.getCurrentInstance().getExternalContext()
                .getRequestContextPath()
                + "/images/user-trash.png";
        return FacesContext.getCurrentInstance().getExternalContext()
                .encodeResourceURL(path);
    }

    public String getOpenParentImage() {
        String path = FacesContext.getCurrentInstance().getExternalContext()
                .getRequestContextPath()
                + "/images/go-up.png";
        return FacesContext.getCurrentInstance().getExternalContext()
                .encodeResourceURL(path);
    }

    /**
     * @return Returns the container.
     */
    public S2Container getContainer() {
        return container;
    }

    /**
     * @param container
     *            The container to set.
     */
    public void setContainer(S2Container container) {
        this.container = container;
    }

    public boolean isRenderCreateNewFile() {
        PortletConfig config = VFSUtil.getPortletConfig();
        if (config != null) {
            String value = config
                    .getInitParameter(VFSConstants.RENDER_CREATE_NEW_FILE);
            if (VFSConstants.TRUE.equalsIgnoreCase(value)) {
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isRenderCreateNewFolder() {
        PortletConfig config = VFSUtil.getPortletConfig();
        if (config != null) {
            String value = config
                    .getInitParameter(VFSConstants.RENDER_CREATE_NEW_FOLDER);
            if (VFSConstants.TRUE.equalsIgnoreCase(value)) {
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isRenderUploadFile() {
        PortletConfig config = VFSUtil.getPortletConfig();
        if (config != null) {
            String value = config
                    .getInitParameter(VFSConstants.RENDER_UPLOAD_FILE);
            if (VFSConstants.TRUE.equalsIgnoreCase(value)) {
                return true;
            }
            return false;
        }
        return true;
    }
}
