/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.dao.impl;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;

import org.seasar.framework.container.S2Container;
import org.seasar.jcr.SessionFactory;

import jp.sf.pal.cms.CMSConstants;
import jp.sf.pal.cms.CMSException;
import jp.sf.pal.cms.dao.ScopeNodeDao;
import jp.sf.pal.cms.dto.ScopeNodeDto;

/**
 * @author shinsuke
 * 
 */
public class ScopeNodeDaoImpl implements ScopeNodeDao {
    private SessionFactory sessionFactory_;

    private S2Container container;

    public ScopeNodeDaoImpl(SessionFactory sessionFactory) {
        sessionFactory_ = sessionFactory;
    }

    public ScopeNodeDto getScopeNode(String scopeName) throws CMSException {
        String q = CMSConstants.PATH_SEPARATOR + CMSConstants.PATH_SEPARATOR
                + CMSConstants.SCOPE_NODE + "[@"
                + CMSConstants.SCOPE_NODE_NAME_ATTR + " = '" + scopeName + "']";
        try {
            Session session = sessionFactory_.getSession();
            Query query = session.getWorkspace().getQueryManager().createQuery(
                    q, Query.XPATH);
            QueryResult result = query.execute();
            NodeIterator ni = result.getNodes();
            if (ni.hasNext()) {
                Node scopeNode = ni.nextNode();
                ScopeNodeDto scopeNodeDto = (ScopeNodeDto) container
                        .getComponent(ScopeNodeDto.class);
                // ScopeNodeDto scopeNodeDto = new ScopeNodeDto();
                scopeNodeDto.setName(scopeNode.getProperty(
                        CMSConstants.SCOPE_NODE_NAME_ATTR).toString());
                return scopeNodeDto;
            }
            return null;
        } catch (InvalidQueryException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (ItemExistsException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (PathNotFoundException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (VersionException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (ConstraintViolationException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (LockException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (ValueFormatException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (AccessDeniedException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (InvalidItemStateException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (NoSuchNodeTypeException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (RepositoryException e) {
            throw new CMSException("Exception: Query=" + q, e);
        }
    }

    public void createScopeNode(String scopeName) throws CMSException {
        String q = CMSConstants.PATH_SEPARATOR + CMSConstants.PATH_SEPARATOR
                + CMSConstants.SCOPE_NODE + "[@"
                + CMSConstants.SCOPE_NODE_NAME_ATTR + " = '" + scopeName + "']";
        try {
            Session session = sessionFactory_.getSession();
            Query query = session.getWorkspace().getQueryManager().createQuery(
                    q, Query.XPATH);
            QueryResult result = query.execute();
            NodeIterator ni = result.getNodes();
            if (!ni.hasNext()) {
                Node rn = session.getRootNode();
                Node scopeNode = rn.addNode(CMSConstants.SCOPE_NODE);
                scopeNode.setProperty(CMSConstants.SCOPE_NODE_NAME_ATTR,
                        scopeName);
                session.save();

            }
        } catch (InvalidQueryException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (ItemExistsException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (PathNotFoundException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (VersionException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (ConstraintViolationException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (LockException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (ValueFormatException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (AccessDeniedException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (InvalidItemStateException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (NoSuchNodeTypeException e) {
            throw new CMSException("Exception: Query=" + q, e);
        } catch (RepositoryException e) {
            throw new CMSException("Exception: Query=" + q, e);
        }
    }

    /**
     * @return Returns the container.
     */
    public S2Container getContainer() {
        return container;
    }

    /**
     * @param container
     *            The container to set.
     */
    public void setContainer(S2Container container) {
        this.container = container;
    }
}
