/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.dto;

import java.util.Calendar;

/**
 * @author shinsuke
 * 
 */
public class ObjectNodeDto {

    protected String scope;

    protected String parentPath;

    protected String name;

    private String oldName;

    protected Calendar lastModifiedTime;

    protected Calendar createdTime;

    protected String nodeType;

    /**
     * 
     */
    public ObjectNodeDto() {
        super();
        setScope("");
        setParentPath("");
        setName("");
        setOldName(null);
        setNodeType("");
    }

    public String toString() {
        return //
        "scope=" + scope + "\n" + //
                "parentPath=" + parentPath + "\n" + //
                "name=" + name + "\n" + //
                "oldName=" + oldName + "\n" + //
                "lastModifiedTime=" + lastModifiedTime + "\n" + //
                "createdTime=" + createdTime + "\n" + //
                "nodeType=" + nodeType + "\n" + //
                "";
    }

    /**
     * @return the lastModifiedTime
     */
    public Calendar getLastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * @param lastModifiedTime
     *            the lastModifiedTime to set
     */
    public void setLastModifiedTime(Calendar lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the nodeType
     */
    public String getNodeType() {
        return nodeType;
    }

    /**
     * @param nodeType
     *            the nodeType to set
     */
    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    /**
     * @return Returns the path.
     */
    public String getParentPath() {
        return parentPath;
    }

    /**
     * @param path
     *            The path to set.
     */
    public void setParentPath(String path) {
        this.parentPath = path;
    }

    /**
     * @return Returns the scope.
     */
    public String getScope() {
        return scope;
    }

    /**
     * @param scope
     *            The scope to set.
     */
    public void setScope(String scope) {
        this.scope = scope;
    }

    /**
     * @return Returns the createdTime.
     */
    public Calendar getCreatedTime() {
        return createdTime;
    }

    /**
     * @param createdTime
     *            The createdTime to set.
     */
    public void setCreatedTime(Calendar createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * @return Returns the oldName.
     */
    public String getOldName() {
        return oldName;
    }

    /**
     * @param oldName
     *            The oldName to set.
     */
    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

}