/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.portlet;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import jp.sf.pal.cms.CMSConstants;
import jp.sf.pal.cms.CMSException;
import jp.sf.pal.cms.dao.PageNodeDao;
import jp.sf.pal.cms.dao.ScopeNodeDao;
import jp.sf.pal.cms.dto.ScopeNodeDto;
import jp.sf.pal.cms.util.CMSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.teeda.core.portlet.FacesPortlet;

public class CMSPortlet extends FacesPortlet {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(CMSPortlet.class);

    private String scopeName;

    /*
     * (non-Javadoc)
     * 
     * @see org.seasar.teeda.core.portlet.FacesPortlet#init()
     */
    public void init() throws PortletException {
        super.init();

        // create scope node
        scopeName = getPortletConfig().getInitParameter(CMSConstants.SCOPE);
        if (scopeName == null) {
            if (log.isDebugEnabled()) {
                log.debug(CMSConstants.SCOPE + " is null. The scope is set to "
                        + CMSConstants.DEFAULT_SCOPE_VALUE + ".");
            }
            scopeName = CMSConstants.DEFAULT_SCOPE_VALUE;
        }
        S2Container container = SingletonS2ContainerFactory.getContainer();
        ScopeNodeDao scopeNodeDao = (ScopeNodeDao) container
                .getComponent(ScopeNodeDao.class);
        try {
            ScopeNodeDto scopeNodeDto = scopeNodeDao.getScopeNode(scopeName);
            if (scopeNodeDto == null) {
                // String importFilename = getPortletConfig().getInitParameter(
                // CMSConstants.IMPORT_FILE);
                // if (importFilename != null) {
                // SessionFactory sessoinFactory = (SessionFactory)
                // container
                // .getComponent(SessionFactory.class);
                // try {
                // importFilename = getPortletContext().getRealPath(
                // importFilename);
                // log.debug("TEST: CMSPortlet 4
                // importFilename="+importFilename);
                // InputStream in = new FileInputStream(importFilename);
                // Session session = sessoinFactory.getSession();
                // session.importXML(CMSConstants.PATH_SEPARATOR, in,
                // ImportUUIDBehavior.IMPORT_UUID_CREATE_NEW);
                // } catch (FileNotFoundException e) {
                // log.error("Could not import: " + importFilename, e);
                // } catch (PathNotFoundException e) {
                // log.error("Could not import: " + importFilename, e);
                // } catch (ItemExistsException e) {
                // log.error("Could not import: " + importFilename, e);
                // } catch (ConstraintViolationException e) {
                // log.error("Could not import: " + importFilename, e);
                // } catch (VersionException e) {
                // log.error("Could not import: " + importFilename, e);
                // } catch (InvalidSerializedDataException e) {
                // log.error("Could not import: " + importFilename, e);
                // } catch (LockException e) {
                // log.error("Could not import: " + importFilename, e);
                // } catch (RepositoryException e) {
                // log.error("Could not import: " + importFilename, e);
                // } catch (IOException e) {
                // log.error("Could not import: " + importFilename, e);
                // }
                // } else {
                // if (log.isDebugEnabled()) {
                // log.debug("The import file is not specified.");
                // }
                // create a scope node
                scopeNodeDao.createScopeNode(scopeName);
                // }
            }
        } catch (CMSException e) {
            throw new PortletException(e);
        }

        PageNodeDao pageNodeDao = (PageNodeDao) container
                .getComponent(PageNodeDao.class);
        try {
            pageNodeDao.initPageNode();
        } catch (CMSException e) {
            throw new PortletException(e);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.seasar.teeda.core.portlet.FacesPortlet#processAction(javax.portlet.ActionRequest,
     *      javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest request, ActionResponse response)
            throws PortletException, IOException {
        request.setAttribute(CMSConstants.SCOPE, scopeName);

        if (request.getPortletMode().equals(PortletMode.VIEW)) {
            String path = request.getParameter(CMSConstants.CONTENT_PATH);
            String target = request.getParameter(CMSConstants.CONTENT_TARGET);
            if (log.isDebugEnabled()) {
                log
                        .debug("processAction(ActionRequest, ActionResponse) - path="
                                + path);
            }
            if (path != null && target != null) {
                request.getPortletSession().setAttribute(
                        CMSConstants.CONTENT_PATH + CMSConstants.KEY_SEPARATOR
                                + target, CMSUtil.normalizedPath(path),
                        PortletSession.APPLICATION_SCOPE);
            }
        } else {
            super.processAction(request, response);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see javax.portlet.GenericPortlet#render(javax.portlet.RenderRequest,
     *      javax.portlet.RenderResponse)
     */
    public void render(RenderRequest request, RenderResponse response)
            throws PortletException, IOException {
        PortletSession portletSession = request.getPortletSession();
        String key = CMSConstants.CONTENT_PATH + CMSConstants.KEY_SEPARATOR
                + response.getNamespace();
        String path = (String) portletSession.getAttribute(key,
                PortletSession.APPLICATION_SCOPE);
        if (path != null) {
            portletSession.setAttribute(CMSConstants.CONTENT_PATH, path);
            portletSession.removeAttribute(key,
                    PortletSession.APPLICATION_SCOPE);
        }
        request.setAttribute(CMSConstants.SCOPE, scopeName);
        super.render(request, response);
    }

}
