/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.rewriter.impl;

import java.io.IOException;

import jp.sf.pal.cms.rewriter.HtmlRewriter;
import jp.sf.pal.cms.rewriter.helpers.RewriteHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * @author shinsuke
 * 
 */
public class HtmlRewriterImpl implements HtmlRewriter {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(HtmlRewriterImpl.class);

    private RewriteHandler rewriteHandler;

    public HtmlRewriterImpl(RewriteHandler rewriteHandler) {
        setRewriteHandler(rewriteHandler);
    }

    public String parse(InputSource inputSource) {
        SAXParser parser = new SAXParser();
        parser.setContentHandler(getRewriteHandler());
        parser.setDTDHandler(getRewriteHandler());
        parser.setEntityResolver(getRewriteHandler());
        parser.setErrorHandler(getRewriteHandler());
        try {
            parser.parse(inputSource);
            return getRewriteHandler().getContent();
        } catch (SAXException e) {
            log.error("XML parser error occurred.", e);
        } catch (IOException e) {
            log.error("I/O error occurred.", e);
        }
        return null;
    }

    /**
     * @return Returns the rewriteHandler.
     */
    public RewriteHandler getRewriteHandler() {
        return rewriteHandler;
    }

    /**
     * @param rewriteHandler
     *            The rewriteHandler to set.
     */
    public void setRewriteHandler(RewriteHandler rewriteHandler) {
        this.rewriteHandler = rewriteHandler;
    }

}
