/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.web.editor;

import javax.faces.context.FacesContext;

import jp.sf.pal.cms.CMSConstants;
import jp.sf.pal.cms.util.CMSUtil;

/**
 * @author shinsuke
 * 
 */
public class CreateNewFilePage {
    private String path;

    private String name;

    public CreateNewFilePage() {
        Object obj = FacesContext.getCurrentInstance().getExternalContext()
                .getSessionMap().get(CMSConstants.PATH);
        if (obj != null) {
            setPath((String) obj);
        } else {
            setPath(CMSConstants.ROOT_FOLDER);
        }
    }

    public String backToList() {
        CMSUtil.clearSession();
        return CMSConstants.DISPLAY_FOLDER_LIST_PAGE;
    }

    public String createTextContent() {
        FacesContext.getCurrentInstance().getExternalContext().getSessionMap()
                .put(CMSConstants.NEW_OBJECT_NAME, getName());
        return CMSConstants.WRITE_TEXT_CONTENT_PAGE;
    }

    public String createHtmlContent() {
        FacesContext.getCurrentInstance().getExternalContext().getSessionMap()
                .put(CMSConstants.NEW_OBJECT_NAME, getName());
        return CMSConstants.WRITE_HTML_CONTENT_PAGE;
    }

    public String upload() {
        FacesContext.getCurrentInstance().getExternalContext().getSessionMap()
                .put(CMSConstants.NEW_OBJECT_NAME, getName());
        return CMSConstants.UPLOAD_FILE_PAGE;
    }

    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return Returns the path.
     */
    public String getPath() {
        return path;
    }

    /**
     * @param path
     *            The path to set.
     */
    public void setPath(String path) {
        this.path = path;
    }

}
