/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.web.editor;

import java.util.Calendar;

import javax.faces.context.FacesContext;

import jp.sf.pal.cms.CMSConstants;
import jp.sf.pal.cms.CMSException;
import jp.sf.pal.cms.dao.FolderNodeDao;
import jp.sf.pal.cms.dto.FolderNodeDto;
import jp.sf.pal.cms.util.CMSUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;

import com.marevol.utils.faces.application.FacesMessageUtil;

/**
 * @author shinsuke
 * 
 */
public class DisplayFolderDetailPage {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(DisplayFolderDetailPage.class);

    private String path;

    private String name;

    private S2Container container;

    public DisplayFolderDetailPage() {
        Object obj = FacesContext.getCurrentInstance().getExternalContext()
                .getSessionMap().get(CMSConstants.PATH);
        if (obj != null) {
            setPath((String) obj);
        } else {
            setPath(CMSConstants.ROOT_FOLDER);
        }

        String name = (String) FacesContext.getCurrentInstance()
                .getExternalContext().getSessionMap().get(
                        CMSConstants.SELECTED_OBJECT_NAME);
        if (name != null) {
            setName(name);
        } else {
            setName("");
            // TODO i18n
            FacesMessageUtil.addErrorMessage("The selected object is null.");
        }
    }

    public String backToList() {
        CMSUtil.clearSession();
        return CMSConstants.DISPLAY_FOLDER_LIST_PAGE;
    }

    public String update() {
        String folderName = (String) FacesContext.getCurrentInstance()
                .getExternalContext().getSessionMap().get(
                        CMSConstants.SELECTED_OBJECT_NAME);
        if (folderName == null) {
            // TODO i18n
            FacesMessageUtil.addErrorMessage("The selected object is null.");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("update() - getPath()=" + getPath());
            log.debug("update() - getName()=" + getName());
            log.debug("update() - name=" + folderName);
        }
        if (!folderName.equals(getName())) {
            // S2Container container =
            // SingletonS2ContainerFactory.getContainer();
            FolderNodeDao folderNodeDao = (FolderNodeDao) container
                    .getComponent(FolderNodeDao.class);
            try {
                FolderNodeDto folderNode = folderNodeDao.getFolderNode(CMSUtil
                        .getScopeFromRequest(),
                        CMSUtil.normalizedPath(getPath()
                                + CMSConstants.PATH_SEPARATOR)
                                + folderName);
                folderNode.setOldName(folderName);
                folderNode.setName(getName());
                folderNode.setLastModifiedTime(Calendar.getInstance());

                folderNodeDao.update(folderNode);
                FacesContext.getCurrentInstance().getExternalContext()
                        .getSessionMap().put(CMSConstants.SELECTED_OBJECT_NAME,
                                getName());
                // TODO i18n
                FacesMessageUtil.addInfoMessage("Updated this folder.");
            } catch (CMSException e) {
                log.error("Could not update this folder.", e);
                // TODO i18n
                FacesMessageUtil.addErrorMessage(
                        "Could not update this folder.", e);
            }
        } else {
            // TODO i18n
            FacesMessageUtil.addInfoMessage("The folder name is not changed.");
        }
        return null;
    }

    public String delete() {
        String folderName = (String) FacesContext.getCurrentInstance()
                .getExternalContext().getSessionMap().get(
                        CMSConstants.SELECTED_OBJECT_NAME);
        if (folderName == null) {
            // TODO i18n
            FacesMessageUtil.addErrorMessage("The selected object is null.");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("delete() - getPath()=" + getPath());
            log.debug("delete() - getName()=" + getName());
            log.debug("delete() - name=" + folderName);
        }
        // S2Container container = SingletonS2ContainerFactory.getContainer();
        FolderNodeDao folderNodeDao = (FolderNodeDao) container
                .getComponent(FolderNodeDao.class);
        try {
            FolderNodeDto folderNode = folderNodeDao.getFolderNode(CMSUtil
                    .getScopeFromRequest(), CMSUtil.normalizedPath(getPath()
                    + CMSConstants.PATH_SEPARATOR)
                    + folderName);
            folderNodeDao.delete(folderNode);
            // TODO i18n
            FacesMessageUtil.addInfoMessage("Deleted the folder.");
            return CMSConstants.DISPLAY_FOLDER_LIST_PAGE;
        } catch (CMSException e) {
            log.error("Could not delete: " + folderName, e);
            // TODO i18n
            FacesMessageUtil.addErrorMessage("Could not delete: " + folderName,
                    e);
        }

        return null;
    }

    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return Returns the path.
     */
    public String getPath() {
        return path;
    }

    /**
     * @param path
     *            The path to set.
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * @return Returns the container.
     */
    public S2Container getContainer() {
        return container;
    }

    /**
     * @param container
     *            The container to set.
     */
    public void setContainer(S2Container container) {
        this.container = container;
    }
}
