/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.facesresponse.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import jp.sf.pal.facesresponse.util.FacesResponseUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BufferedResponseStream {
    private static final Log log = LogFactory.getLog((Class)BufferedResponseStream.class);
    private ByteArrayOutputStream byteArrayOutputStream;
    private ByteArrayInputStream byteArrayInputStream;
    private Writer writer;
    private String encoding;
    private ByteArrayOutputStream facesOutputStream;

    public BufferedResponseStream(String encoding) {
        this.encoding = encoding;
        this.byteArrayOutputStream = null;
        this.byteArrayInputStream = null;
        this.writer = null;
        this.facesOutputStream = null;
    }

    public void recycle() {
        this.byteArrayInputStream = null;
        if (this.facesOutputStream != null) {
            this.facesOutputStream.reset();
            this.byteArrayOutputStream = this.facesOutputStream;
            try {
                this.writer = new OutputStreamWriter((OutputStream)this.byteArrayOutputStream, this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)("Unsupported encoding: " + this.getEncoding()), (Throwable)e);
                this.writer = new OutputStreamWriter(this.byteArrayOutputStream);
            }
        } else {
            this.byteArrayOutputStream = null;
            this.writer = null;
            this.facesOutputStream = null;
        }
    }

    public OutputStream getOutputStream() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getOutputStream()");
        }
        if (this.writer != null) {
            throw new IllegalStateException("getOutputStream() cannot be called after getWriter().");
        }
        if (this.byteArrayOutputStream == null) {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }
        return this.byteArrayOutputStream;
    }

    public Writer getWriter() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getWriter()");
        }
        if (this.byteArrayOutputStream != null && this.writer == null) {
            throw new IllegalStateException("getWriter() cannot be called after getOutputStream().");
        }
        if (this.writer == null) {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                this.writer = new OutputStreamWriter((OutputStream)this.byteArrayOutputStream, this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)("Unsupported encoding: " + this.getEncoding()), (Throwable)e);
                this.writer = new OutputStreamWriter(this.byteArrayOutputStream);
            }
        }
        return this.writer;
    }

    public Writer getFacesWriter() {
        Writer writer = this.getWriter();
        this.facesOutputStream = this.byteArrayOutputStream;
        return writer;
    }

    public InputStream getInputStream() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getInputStream()");
        }
        if (this.byteArrayInputStream == null) {
            byte[] emptyBytes = new byte[]{};
            this.byteArrayInputStream = new ByteArrayInputStream(emptyBytes);
        }
        return this.byteArrayInputStream;
    }

    public Reader getReader() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getReader()");
        }
        try {
            return new InputStreamReader(this.getInputStream(), this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("Unsupported encoding: " + this.getEncoding()), (Throwable)e);
            return new InputStreamReader(this.getInputStream());
        }
    }

    public boolean commit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("commit()- byteArrayOutputStream=" + this.byteArrayOutputStream));
        }
        if (this.byteArrayOutputStream != null) {
            try {
                if (this.writer != null) {
                    this.writer.flush();
                }
                this.byteArrayOutputStream.flush();
            }
            catch (IOException e) {
                log.error((Object)"Could not flush the output stream.", (Throwable)e);
                return false;
            }
            this.byteArrayInputStream = new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
            if (!(this.byteArrayOutputStream == this.facesOutputStream && FacesResponseUtil.isMyFacesFacesContext() || this.writer == null)) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Could not close the writer.", (Throwable)e);
                }
            }
            this.byteArrayOutputStream = null;
            this.writer = null;
            return true;
        }
        return false;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

