package jp.sf.pal.ggadget.action;

import java.io.Serializable;

import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

import jp.sf.pal.ggadget.GGadgetConstants;
import jp.sf.pal.ggadget.util.GGadgetUtil;

import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;
import org.seasar.struts.portlet.util.PortletUtil;

public class ViewAction implements Serializable {

    private static final long serialVersionUID = -66671108317476649L;

    public String url;

    private transient HttpServletRequest request;

    @Execute(validator = false, input = "error.jsp")
    public String index() {
        String value = GGadgetUtil.getPreferenceValue(request,
                GGadgetConstants.URL, "");
        if (value == null) {
            throw new ActionMessagesException("errors.invalid_portlet_state");
        } else if ("".equals(value)) {
            GGadgetUtil.addMessage(request, "warn.need_to_set_gadget_url");
            return "error.jsp";
        }
        url = value;

        setPortletTitle();

        return "index.jsp";
    }

    private void setPortletTitle() {
        RenderResponse renderResponse = PortletUtil.getRenderResponse(request);
        if (renderResponse != null) {
            String value = GGadgetUtil.getPreferenceValue(request,
                    GGadgetConstants.NAME, "");
            if (!"".equals(value)) {
                renderResponse.setTitle(value);
            }
        }
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}
