# testrequest.rb: testcases for additional methods on WEBrick::HTTPRequest

require 'test/unit'
load 'blazer-ja-proxy'

require 'nkf'
require 'cgi'
class TestResponse < Test::Unit::TestCase
	include WEBrick

	def multipart_request(body)
		head = <<"_END".gsub(/\r?\n/, "\r\n")
POST http://www.example.com/ HTTP/1.1
Host: www.example.com
Content-type: multipart/form-data; boundary=------------------------------117511377109921378543360
Content-length: #{body.size}
_END
		head + "\r\n" + body
	end

	def not_test_convert_query
		{
			'http://www.ruby-lang.org/ja/man-1.6/?cmd=view;name=Ruby' + CGI::escape(NKF::nkf('-w8', 'ե󥹥ޥ˥奢')) => [NKF::EUC, 'http://www.ruby-lang.org/ja/man-1.6/?cmd=view;name=Ruby%A5%EA%A5%D5%A5%A1%A5%EC%A5%F3%A5%B9%A5%DE%A5%CB%A5%E5%A5%A2%A5%EB'],
			'http://www.google.co.jp/xhtml?q=%C6%FC%CB%DC%B8%EC%A4%CE%B8%A1%BA%F7&hl=ja&lr=&btnG=%B8%A1%BA%F7&site=search&mrestrict=xhtml' => [NKF::UTF8, 'http://www.google.co.jp/xhtml?q=%EF%BB%BF%E6%97%A5%E6%9C%AC%E8%AA%9E%E3%81%AE%E6%A4%9C%E7%B4%A2&hl=ja&lr=&btnG=%EF%BB%BF%E6%A4%9C%E7%B4%A2&site=search&mrestrict=xhtml'],
		}.each_pair do |src, param|
			req = HTTPRequest.new( {:HTTPVersion => '1.1'} )
			req.unparsed_uri = src
			req.convert_query_to!(param[0])
			assert_equal(param[1], req.request_uri.to_s)
		end
	end

	def test_convert_body
		multipart_body = <<'_END'
--------------------------------117511377109921378543360
Content-Disposition: form-data; name="file"; filename="test"
Content-Type: application/octet-stream


--------------------------------117511377109921378543360
Content-Disposition: form-data; name="ja"

ܸʸϤǤ

--------------------------------117511377109921378543360
Content-Disposition: form-data; name="en"

English text

--------------------------------117511377109921378543360--
_END
		{
			<<'_END'.chomp => [NKF::EUC, 'text=%C6%FC%CB%DC%B8%EC&submit=SUBMIT'],
POST http://www.example.com/ HTTP/1.1
Host: www.example.com
Content-type: application/x-www-form-urlencoded
Content-length: 37

text=%93%FA%96%7B%8C%EA&submit=SUBMIT
_END
			multipart_request(NKF.nkf("-s -Lw", multipart_body)) =>
			[NKF::EUC, NKF.nkf("-e -Lw", multipart_body)],
		}.each_pair do |src, param|
			req = HTTPRequest.new( {:HTTPVersion => '1.1'} )
			req.parse(StringIO.new(src))
			req.convert_body_to!(param[0])
			assert_equal(param[1], req.body)
		end
	end

end
