%define __check_files %{nil}

%define _with_smtps 1
%define with_smtps %{?_with_smtps:1}%{!?_with_smtps:0}

%define version 0.9.5
%define release 1
%define _libdir_old %{_libdir}
%define _libdir /lib

Summary: A Pluggable Authentication Module for SMTP Authentication.
Name: pam_smtpauth
Version: %{version}
Release: %{release}
Source0: %{name}-%{version}.tar.gz
License: GPL
Vendor: HDE, Inc.
Packager: Taizo ITO <taizo.ito@hde.co.jp>
URL: http://sourceforge.jp/projects/pam-smtpauth/
Group: System Environment/Base
BuildRoot: %{_tmppath}/%{name}-root

Requires: pam > 0.70
BuildRequires: pam-devel

%if %{with_smtps}
Requires: openssl
BuildRequires: openssl-devel
BuildRequires: krb5-devel
%endif

### include local configuration
%{?include_specopt}

%description
This is pam_smtpauth, a pluggable authentication module that can be used with
Linux-PAM and SMTP Authentication.

%prep 
%setup -q

%build
LDFLAGS="-Wl,-rpath,%{_libdir_old} -L%{_libdir_old}"
export LDFLAGS
%configure \
  --prefix=%{_prefix} \
  --libdir=%{_libdir} \
  --enable-debug=no \
%if %{with_smtps}
  --enable-ssl=yes \
  --with-krb5-dir=%{_prefix}/kerberos \
%endif

#  --enable-debug=yes \

make %{?_smp_mflags} || make
## make check

%install
%makeinstall

%clean
rm -rf $RPM_BUILD_ROOT

%files
%doc NEWS INSTALL README ChangeLog AUTHORS sample
%defattr(-,root,root)
%{_libdir}/security/*
%config(noreplace) %{_sysconfdir}/pam_smtpauth.conf
%{_mandir}/man5/pam_smtpauth.5.gz

%changelog
* Tue Jun 22 2009 Taizo ITO <taizo.ito@hde.co.jp>
- version 0.9.3 build.
- support digest-md5 mechanism.

* Tue Jun 16 2009 Taizo ITO <taizo.ito@hde.co.jp>
- version 0.9.2 build.
- support smtps connection.

* Thu Jun 11 2009 Taizo ITO <taizo.ito@hde.co.jp>
- Initial 0.9.1 build.
