/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_HAPLOTYPE_PHASING__
#define __HEADER_FILE_HAPLOTYPE_PHASING__

#ifdef _MAIN_DEF
#define EXTERN
#else
#define EXTERN extern
#endif

#include "Config.h"
#include "DataReader.h"
#include "MemoryControl.h"


/* ̓f[^i[p\ */
typedef struct struct_InputPhasing {
    char inputFile[MAX_LEN];    /* ̓t@C */
    char ldBlockFile[MAX_LEN];/* LDubNt@C */
    char outputFile[MAX_LEN];   /* o̓t@C */
    int phasingType;           /* tF[WO */
    int snpNumLimit;            /* LDubNSNP̏ */
} InputPhasing;

/* nv^CvtF[WOs */
void haplotypePhasing(InputPhasing *inputPhasing);
/* Hapmapf[^tF[WO͌`ɕϊ */
int transHapmapForPhasing(InputPhasing *inputPhasing, SnpData *snpData, long blockNum, long *linkSNPNum, long *linkSNPStart);
/* tF[WOs */
int executePhasing(InputPhasing *inputPhasing, long blockNum);
/* tF[WOo͌ʂHapmap`ɕϊ */
int transPhasedDataFotHapmap(InputPhasing *inputPhasing, SnpData *snpData, long blockNum, long *linkSNPNum, long *linkSNPStart);

#ifdef MPI_USE
EXTERN int MyMpiSize; /* MPĨvZX */
EXTERN int MyMpiRank; /* MPI̎Rank   */
/* Ԍvp */
#define NUM_TM   10
double tm[NUM_TM];
#define TM_START    0
#define TM_READ     1
#define TM_SPLIT    2
#define TM_BCAST    3            
#define TM_PHASE    4
#define TM_Barrier  5
#define TM_MERGE    6
#define TM_END      7
#endif /* MPI_USE */


#endif /* __HEADER_FILE_HAPLOTYPE_PHASING__ */
