#include <stdio.h>
#include <stdlib.h>

#include "snp_Kuriage.h"
#include "snp_BunkaiOld.h"

void BunkaiOldInit(BunkaiOld* p_struct, int* min0, int min0_num, int* max0, int limit0){
  int i;
  int maxmin[2];
  int minSum = 0;
  int maxSum = 0;

  p_struct->size = (min0_num);
  p_struct->min = (int*)malloc(sizeof(int) * p_struct->size);
  if(NULL == p_struct->min) goto allocateerror;
  p_struct->max = (int*)malloc(sizeof(int) * p_struct->size);
  if(NULL == p_struct->max) goto allocateerror;
  p_struct->range = (int*)malloc(sizeof(int) * p_struct->size);
  if(NULL == p_struct->range) goto allocateerror;
  p_struct->kuriage = (Kuriage**)malloc(sizeof(Kuriage*) * p_struct->size);
  if(NULL == p_struct->kuriage) goto allocateerror;
  for(i=0;i<p_struct->size;i++){
    //maxmin = (int*)malloc(sizeof(int) * 2);
    p_struct->min[i] = min0[i];
    p_struct->max[i] = max0[i];
    p_struct->range[i] = p_struct->max[i] - p_struct->min[i];
    maxmin[0] = p_struct->min[i];
    maxmin[1] = p_struct->max[i];
    minSum+=p_struct->min[i];
    maxSum+=p_struct->max[i];
    p_struct->kuriage[i] = (Kuriage*)malloc(sizeof(Kuriage));
    if(NULL == p_struct->kuriage[i]) goto allocateerror;
    KuriageInit(p_struct->kuriage[i]);
    p_struct->kuriage[i]->min = maxmin[0];
    p_struct->kuriage[i]->max = maxmin[1];
  }

  for(i=0;i<p_struct->size-1;i++){
    KuriageSetParent(p_struct->kuriage[i], p_struct->kuriage[i+1]);
  }
  
  p_struct->banpei = (Kuriage*)malloc(sizeof(Kuriage));
  if(NULL == p_struct->banpei) goto allocateerror;
  KuriageInit(p_struct->banpei);
  KuriageSetParent(p_struct->kuriage[p_struct->size-1], p_struct->banpei);
  p_struct->result = (int*)malloc(sizeof(int) * p_struct->size); // filled with 0
  if(NULL == p_struct->result) goto allocateerror;
  return;
allocateerror:
  printf("memory allocate error!\n");
  exit(9);
}

void BunkaiOldFinalize(BunkaiOld* p_struct){
  int i;
  free(p_struct->min);
  free(p_struct->max);
  free(p_struct->range);
  for(i=0;i<p_struct->size;i++){
    free(p_struct->kuriage[i]);
  }
  free(p_struct->kuriage);
  free(p_struct->banpei);
  free(p_struct->result);
}

void BunkaiOldCount(BunkaiOld* p_struct){
  KuriageCount(p_struct->kuriage[0]);
}

int* BunkaiOldBunkai(BunkaiOld* p_struct){
  int i;
  for(i=0;i<p_struct->size;i++){ 
    p_struct->result[i]=KuriageValue(p_struct->kuriage[i]);
  }
  return p_struct->result;
}

int BunkaiOldDone(BunkaiOld* p_struct){
  if(KuriageValue(p_struct->banpei)>0){
    return 1;
  }
  return 0;
}

int BunkaiOldAllSum(BunkaiOld* p_struct){
  int i;
  int sum = 0;
  for(i=0;i<p_struct->size;i++){ 
    p_struct->result[i]=KuriageValue(p_struct->kuriage[i]);
    sum+=p_struct->result[i];
  }
  return sum;
}

int BunkaiOldSumWithoutTop(BunkaiOld* p_struct){
  int i;
  int sum = 0;
  for(i=0;i<p_struct->size-1;i++){ 
    p_struct->result[i]=KuriageValue(p_struct->kuriage[i]);
    sum+=p_struct->result[i];
  }
  return sum;
}
