#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "snp_MemoryControl.h"
#include "snp_Config.h"

/* 1z̃m */
void *malloc1Dim(int size, int dim1)
{
    int i = 0;
    void *array = NULL;

    /* m */
    array = malloc(size * dim1);
    if (NULL == array){
        printf("memory allocation error\n");
        return NULL;
    }

#ifdef DBG
    /* mallocJEgAbv */
    malloc_count++;
#endif

    /* z񏉊 */
    memset(array, 0, size * dim1 );

    return array;
}

/* int^2z̃m */
void **mallocInt2Dim(int dim1, int dim2)
{
    int i = 0;
    int j = 0;
    void **array = NULL;

    /* m */
    array = malloc1Dim(sizeof(int*), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = malloc1Dim(sizeof(int), dim2);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}

/* char^2z̃m */
void **mallocChar2Dim(int dim1, int dim2)
{
    int i = 0;
    int j = 0;
    void **array = NULL;

    /* m */
    array = malloc1Dim(sizeof(char*), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = malloc1Dim(sizeof(char), dim2 + 1);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}

/* double^2z̃m */
void **mallocDouble2Dim(int dim1, int dim2)
{
    int i = 0;
    int j = 0;
    void **array = NULL;

    /* m */
    array = malloc1Dim(sizeof(double*), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = malloc1Dim(sizeof(double), dim2 + 1);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}

/* int^3z̃m */
void ***mallocInt3Dim(int dim1, int dim2, int dim3)
{
    int i = 0;
    int j = 0;
    int k = 0;
    void ***array = NULL;

    /* m */
    array = malloc1Dim(sizeof(int**), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = mallocInt2Dim(dim2, dim3);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}


/* 1z̃J */
void free1Dim(void *array)
{
    if (NULL != array){
        free(array);

#ifdef DBG
        /* mallocJEg_E */
        malloc_count--;
#endif

    }
}

/* int^2z̃J */
void freeInt2Dim(int **array, int dim1)
{
    int i = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                free1Dim(array[i]);
            }
        }
        free(array);

#ifdef DBG
        /* mallocJEg_E */
        malloc_count--;
#endif
    }
}

/* char^2z̃J */
void freeChar2Dim(char **array, int dim1)
{
    int i = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                free1Dim(array[i]);
            }
        }
        free(array);

#ifdef DBG
        /* mallocJEg_E */
        malloc_count--;
#endif
    }
}

/* double^2z̃J */
void freeDouble2Dim(double **array, int dim1)
{
    int i = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                free1Dim(array[i]);
            }
        }
        free(array);

#ifdef DBG
        /* mallocJEg_E */
        malloc_count--;
#endif
    }
}

/* int^3z̃J */
void freeInt3Dim(int ***array, int dim1, int dim2)
{
    int i = 0;
    int j = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                freeInt2Dim(array[i], dim2);
            }
        }
        free(array);

#ifdef DBG
        /* mallocJEg_E */
        malloc_count--;
#endif
    }
}

/* molloc_countԂ */
int getMallocCount()
{
    return malloc_count;
}
