/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_HAPLOTYPE_PHASING__
#define __HEADER_FILE_HAPLOTYPE_PHASING__

#ifdef _MAIN_DEF
#define EXTERN
#else
#define EXTERN extern
#endif

#include "Config.h"
#include "DataReader.h"
#include "MemoryControl.h"


/* 入力データ格納用構造体 */
typedef struct struct_InputPhasing {
    char inputFile[MAX_LEN];    /* 入力ファイル名 */
    char ldBlockFile[MAX_LEN];/* LDブロックファイル名 */
    char outputFile[MAX_LEN];   /* 出力ファイル名 */
    int phasingType;           /* フェージング処理種別 */
    int snpNumLimit;            /* LDブロック毎のSNPの上限 */
} InputPhasing;

/* ハプロタイプフェージングを実行 */
void haplotypePhasing(InputPhasing *inputPhasing);
/* 入力Hapmapデータをフェージング処理入力形式に変換 */
int transHapmapForPhasing(InputPhasing *inputPhasing, SnpData *snpData, long blockNum, long *linkSNPNum, long *linkSNPStart);
/* フェージング処理を実行する */
int executePhasing(InputPhasing *inputPhasing, long blockNum);
/* フェージング出力結果をHapmap形式に変換 */
int transPhasedDataFotHapmap(InputPhasing *inputPhasing, SnpData *snpData, long blockNum, long *linkSNPNum, long *linkSNPStart);

#ifdef MPI_USE
EXTERN int MyMpiSize; /* MPIのプロセス数 */
EXTERN int MyMpiRank; /* MPIの自己Rank   */
/* 時間計測用 */
#define NUM_TM   10
double tm[NUM_TM];
#define TM_START    0
#define TM_READ     1
#define TM_SPLIT    2
#define TM_BCAST    3            
#define TM_PHASE    4
#define TM_Barrier  5
#define TM_MERGE    6
#define TM_END      7
#endif /* MPI_USE */


#endif /* __HEADER_FILE_HAPLOTYPE_PHASING__ */
