#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "DataReader.h"
#include "Config.h"
#include "MemoryControl.h"

/**********************/
/* 入力ファイルを開く */
/**********************/
int InputFileOpen(FILE **fp, char *file)
{
    int retval = 0;

    /* ファイルオープン */
    *fp = fopen(file, "r");
    if (NULL == *fp){
        printf("input file open error! FileName:%s\n", file);
        retval = 1;
    }

    return retval;
}

/**********************/
/* 出力ファイルを開く */
/**********************/
int OutputFileOpen(FILE **fp, char *file)
{
    int retval = 0;

    /* ファイルオープン */
    *fp = fopen(file, "w");
    if (NULL == *fp){
        printf("output file open error! FileName:%s\n", file);
        retval = 1;
    }

    return retval;
}

/********************/
/* ファイルを閉じる */
/********************/
void FileClose(FILE *fp)
{
    if (fp != NULL){
        fclose(fp);
    }
}


/********************************/
/* ファイルの行数をカウントする */
/********************************/
long DataReaderCountFileLine(FILE *fp)
{
    long index = 0;
    long count = 0;
    char buf[MAX_LEN];

    /* 特定文字数ずつ読み込む */
    while ( fgets(buf, MAX_LEN, fp) != NULL ){
        index = strlen(buf);
        if ('\n' == buf[index-1]){
            count++;
        }
    }

    return count;
}

/********************************/
/* Hapmapデータを構造体に収める */
/********************************/
int DataReaderSetAllHapmapData(FILE *fp, SnpData *snpData, long line, int phasingType)
{
    int retval = 0;
    long i = 0;
    long sampleNum = 0;

    /* HapmapDataのサンプル数を取得する */
    sampleNum = DataReaderGetHapmapSampleNum(fp);
    /* ファイルから読み込み */
    for (i = 1; i < line; i++){
        /* SNPデータ格納用配列のメモリ確保 */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
        retval = DataReaderSetHapmapData(fp, &snpData[i], i, phasingType);
    }

    return retval;
}

/************************************/
/* Hapmapデータ一行を構造体に収める */
/************************************/
int DataReaderSetHapmapData(FILE *fp, SnpData *snpData, long line, int phasingType)
{
    int i = 0;
    int j = 0;
    int retval = -1;    /* ファイル最後尾まで来ている場合は-1を返す */
    int column = 1;     /* Hapmapデータの列 */
    int index = 0;
    int maxIndex = 0;
    int dataIndex = 0;
    char buf[1024];
    char tmp[20];


    /* 複数文字ずつ読み込む */
    while ( fgets(buf, 1024, fp) != NULL ){
        maxIndex = strlen(buf);
        j = 0;
        /* １行読み込んだら値を保持して終了 */
        for (j = 0; j <= maxIndex; j++){
            if ('\n' == buf[j]){
                snpData->sampleNum = dataIndex / 2;
                retval = 0;
                dataIndex = 0;
                return retval;
            }
            /* ファイルの２行目以降から処理を行う */
            else if (line > 0){
                /* ファイル内の列をカウント */
                if (isspace(buf[j]) != 0){
                    if (HAPMAP_RS_NUM == column){
                        snpData->rsNumber[index] = '\0';
                    }
                    else if (HAPMAP_POS == column){
                        tmp[index] = '\0';
                        snpData->pos = atol(tmp);
                    }
                    column++;
                    index = 0;
                }
                /* rs#を取得する */
                else if (HAPMAP_RS_NUM == column){
                    if (isalnum(buf[j]) != 0){
                        snpData->rsNumber[index] = buf[j];
                        index++;
                    }
                }
                /* posを取得する */
                else if (HAPMAP_POS == column){
                    tmp[index] = buf[j];
                    index++;
                }
                /* 12列目移行のデータを参照する */
                else if (column >= HAPMAP_DATA){
                    /* 遺伝子データを格納 */
//                    snpData->SNPdata[dataIndex] = buf[j];
                    if ( ('N' == buf[j]) && (phasingType == 1) ) {
                            snpData->SNPdata[dataIndex] = '?';
                    }
                    else {
                        /* 遺伝子データを格納 */
                        snpData->SNPdata[dataIndex] = buf[j];
                    }
                    dataIndex++;
                }
            }
        }
    }

    return retval;
}

/*****************************************/
/* 構造体SnpDataのメモリを確保する */
/*****************************************/
int DataReaderSnpDataMemoryAllocate(SnpData *snpData, long dataNum, long sampleNum)
{
    long i = 0;

    /* ファイルから読み込み */
    for (i = 0; i < dataNum; i++){
        /* SNPデータ格納用配列のメモリ確保 */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
    }

    return 0;
}

/*****************************************/
/* 構造体SnpDataメンバのメモリを開放する */
/*****************************************/
int DataReaderSnpDataMemoryFree(SnpData *snpData, long dataNum)
{
    long i = 0;

    if (NULL != snpData){
        for (i = 0; i < dataNum; i++){
            /* SNPデータ格納用配列のメモリ開放 */
            free1Dim(snpData[i].SNPdata);
        }
        free1Dim(snpData);
    }

    return 0;
}

/*****************************************/
/* LDブロックを配列に格納する */
/*****************************************/
int DataReaderSetLDBlock(FILE *fp, long *ldBlock)
{
    long index = 0;
    long strIndex = 0;
    long valIndex = 0;
    char string[MAX_LEN];
    char value[MAX_LEN];

    /* 一行ずつ読み込む */
    while ( (fgets(string, MAX_LEN, fp)) != NULL){
        strIndex = 0;
        valIndex = 0;
        while (string[strIndex] != '\n'){
            value[valIndex] = string[strIndex];
            strIndex++;
            valIndex++;
        }
        value[valIndex] = '\0';
        ldBlock[index] = atol(value);
        index++;
    }
    return 0;
}



/*****************************************/
/* HapmapDataのサンプル数を取得する */
/*****************************************/
long DataReaderGetHapmapSampleNum(FILE *fp)
{
    int character = 0;
    long column = 1;     /* Haplotypeデータの列 */
    long dataNum = 0;    /* サンプル人数 */

    /* １文字ずつ読み込む */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* １行読み込んだら値を返して終了 */
        if ('\n' == character){
            return dataNum * 2;
        }
        /* ファイル内の列をカウント */
        else if (isspace(character) != 0){
            column++;
            /* 12列目移行のデータ数をカウント */
            if (column >= HAPMAP_DATA){
                dataNum++;
            }
        }
    }

    /* HapmapDataは一人（１列）で２つの遺伝子データを持っているので２倍する */
    return dataNum * 2;
}

/************************************/
/* snphap出力データを読み込む       */
/************************************/
int DataReaderSetSnphapData(FILE *fp, char** haplotype, int maxIndex, int maxSample)
{
    int i = 0;
    int j = 0;
    int flag_read = 0;
    int flag_noline = 0;
    int flag_tmp = 0;
    int retval = 0;
    int dataIndex = 0;
    int character = 0;
    int sampleNumber = 0;
    int tmpIndex = 0;
    long line = 0;
    char tmp[10];

    /* １文字ずつ読み込む */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* １行読み込んだらインデックスを更新 */
        if ('\n' == character){
            dataIndex = 0;
            if (flag_noline != 1){
                line++;
            }
            flag_read = 0;
            flag_noline = 0;
            flag_tmp = 0;
        }
        /* ファイルの４行目以降から処理を行う */
        else if (line > 2){
            if (flag_read == 1){
                /* ハプロタイプデータの後にスペースが入っているので、それ以降は飛ばす */
                if (isspace(character) != 0){
                    flag_read = 0;
                }
                /* 正常なデータであるかチェック */
                else if (isalpha(character) != 0){
                    /* 遺伝子データを格納 */
                    haplotype[line-3][dataIndex] = character;
                    dataIndex++;
                }
                /* 異常なデータ（推定できていない）の場合 */
                else {
                    /* ミッシングデータ（N）を格納 */
                    haplotype[line-3][dataIndex] = 'N';
                    dataIndex++;
                }
            }
            /* データ読み込みフラグを立てる */
            else if (')' == character){
                if (1 != flag_noline){
                    flag_read = 1;
                    /* ハプロタイプデータの前にスペースが入っているので飛ばす */
                    character = fgetc(fp);
                }
            }
            else if ('(' == character){
                tmp[tmpIndex] = '\0';
                tmpIndex = 0;
                flag_tmp =1;
                /* サンプル番号が飛んでいる場合、そのサンプルはミッシングデータで埋める */
                for (i = sampleNumber; i < atoi(tmp)-1; i++){
                    /* 1つ目のハプロタイプ */
                    for (j = 0; j < maxIndex; j++){
                        haplotype[line-3][j] = 'N';
                    }
                    line++;
                    /* 2つ目のハプロタイプ */
                    for (j = 0; j < maxIndex; j++){
                        haplotype[line-3][j] = 'N';
                    }
                    line++;
                }
                sampleNumber = atoi(tmp);
                /* サンプル対して複数のハプロタイプ候補を返している場合、最初の候補を採用する */
                character = fgetc(fp);
                character = fgetc(fp);
                if ('1' != character){
                    flag_noline = 1;
                }
            }
            /* サンプル番号を取得する */
            else if (flag_tmp == 0){
                if (isspace(character) == 0){
                    tmp[tmpIndex] = character;
                    tmpIndex++;
                }
            }
        }
    }
    
    /* サンプル番号が飛んでいる場合、そのサンプルはミッシングデータで埋める */
    for (i = sampleNumber; i < maxSample; i++){
        /* 1つ目のハプロタイプ */
        for (j = 0; j < maxIndex; j++){
            haplotype[line-3][j] = 'N';
        }
        line++;
        /* 2つ目のハプロタイプ */
        for (j = 0; j < maxIndex; j++){
            haplotype[line-3][j] = 'N';
        }
        line++;
    }

    return retval;
}

/************************************/
/* PHASE出力データを読み込む        */
/************************************/
int DataReaderSetPHASEData(FILE *fp, char** haplotype)
{
    int j = 0;
    int flag = 0;
    int retval = 0;
    int index = 0;
    int maxIndex = 0;
    int dataIndex = 0;
    long line = 0;
    char buf[1024];

    /* 複数文字ずつ読み込む */
    while ( fgets(buf, 1024, fp) != NULL ){
        maxIndex = strlen(buf);
        j = 0;
        /* ハプロタイプ推定部分まではスキップさせる */
        if (strncmp(buf, "BEGIN BESTPAIRS1", 16) == 0){
            flag = 1;
        }
        /* ハプロタイプ推定部分終了したらファイル読み込み終了 */
        else if (strncmp(buf, "END BESTPAIRS1", 14) == 0){
            return retval;
        }
        /* ハプロタイプ推定部分読み込み */
        else if (flag == 1) {
            /* １行読み込んだら次の行読み込み */
            for (j = 0; j <= maxIndex; j++){
                if ('\n' == buf[j]){
                    dataIndex = 0;
                    /* ハプロタイプ推定部分のサンプル数を示す部分は読まない */
                    if ( (line % 3) != 0 ){
                        index++;
                    }
                    line++;
                    break;
                }
                if (isalpha(buf[j]) != 0){
                    /* 遺伝子データを格納 */
                    haplotype[index][dataIndex] = buf[j];
                    dataIndex++;
                }
            }
        }
    }

    return retval;
}

