/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_DATA_READER__
#define __HEADER_FILE_DATA_READER__

#include "Config.h"

/* 入力データ格納用構造体 */
typedef struct struct_SNPData { 
	char rsNumber[RS_NUM_LEN];      /* rs# */ 
    long pos;                       /* pos */
    char *SNPdata;                  /* SNPデータ格納用 */
    int sampleNum;                    /* データのサンプル数 */
} SnpData;

/* プロトタイプ宣言 */
/* 入力ファイルを開く */
int InputFileOpen(FILE **fp, char *file);
/* 出力ファイルを開く */
int OutputFileOpen(FILE **fp, char *file);
/* ファイルを閉じる */
void FileClose(FILE *fp);

/* ファイルの行数をカウントする */
long DataReaderCountFileLine(FILE *fp);
/* Hapmapデータを構造体に収める */
int DataReaderSetAllHapmapData(FILE *fp, SnpData *snpData, long line, int phasingType);
/* Hapmapデータ一行を構造体に収める */
int DataReaderSetHapmapData(FILE *fp, SnpData *snpData, long line, int phasingType);
/* 構造体SnpDataメンバのメモリを確保する */
int DataReaderSnpDataMemoryAllocate(SnpData *snpData, long dataNum, long sampleNum);
/* 構造体SnpDataメンバのメモリを開放する */
int DataReaderSnpDataMemoryFree(SnpData *snpData, long dataNum);
/* LDブロックを配列に格納する */
int DataReaderSetLDBlock(FILE *fp, long *ldBlock);
/* HapmapDataのサンプル数を取得する */
long DataReaderGetHapmapSampleNum(FILE *fp);
/* snphap出力データを読み込む       */
int DataReaderSetSnphapData(FILE *fp, char** haplotype, int maxIndex, int maxSample);
/* PHASE出力データを読み込む        */
int DataReaderSetPHASEData(FILE *fp, char** haplotype);

#endif /* __HEADER_FILE_DATA_READER__ */
