/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_IMPUTATION__
#define __HEADER_FILE_IMPUTATION__

#ifdef _MAIN_DEF
#define EXTERN
#else
#define EXTERN extern
#endif

#ifdef _WIN32
typedef int pid_t;
#endif

#include "Config.h"
#include "DataReader.h"
#include "MemoryControl.h"


/* 入力データ格納用構造体 */
typedef struct struct_InputImputation {
    char hapmapDataFile[MAX_LEN];       /* HapmapData */
    char phasedHapmapDataFile[MAX_LEN]; /* PhasedHapmapData */
    char ldBlockFile[MAX_LEN];          /* LDブロックファイル名 */
    char recombinationFile[MAX_LEN];    /* Recombination File */
    char errorRateFile[MAX_LEN];        /* Error Rate File */
    char outputFile[MAX_LEN];           /* 出力ファイル名 */
    long samplePerDivision;             /* 分割後のサンプル数指定 */
    long estimateSampleNum;             /* パラメータ推定時の抽出サンプル数　0:パラメータ推定OFF */

    char simpleDataFile[MAX_LEN];       /* Simple Data File */
    char pedigreeFile[MAX_LEN];         /* Pegigree File */
    char snpListFile[MAX_LEN];          /* Snp List File */
    char phasedHaplotypeFile[MAX_LEN];  /* Phased Haplotype File */
} InputImputation;


/* Imputationを実行 */
void imputation(
    InputImputation* inputImputation);
/* LDブロックを読み込み、配列に格納する */
int setLDBlock(
    InputImputation* inputImputation,
    long*            ldBlockNum,
    long**           ldBlock);
/* 入力データをImputation処理用にフォーマット変換する */
int convertToImputation(
    InputImputation*    inputImputation,
    SnpData*            hapmapSnpData,
    SnpData*            phasedSnpData,
    long                impHapmapSnpNum,
    long                impPhasedSnpNum,
    long*               ldBlock,
    long                ldBlockNum);
/* パラメータ推定用に入力データをLDブロックで分割する */
int divideInputDataForEstimate(
    InputImputation*    inputImputation,
    SnpData*            hapmapSnpData,
    SnpData*            phasedSnpData,
    long                impHapmapSnpNum,
    long                impPhasedSnpNum,
    pid_t               pid,
    long*               ldBlock,
    long                ldBlockNum);
/* パラメータを推定する */
int estimateParameter(
    InputImputation* inputImputation,
    long             ldBlockNum,
    pid_t            pid);
/* パラメータ推定結果を結合する */
int margeEstimateResult(
    InputImputation* inputImputation,
    long             divideNum,
    pid_t            pid,
    long*            impPhasedSnpNum);
/* Pedigreeデータを分割する */
int dividePedigree(
    InputImputation* inputImputation,
    long*            divideNum,
    pid_t            pid);
/* Imputation処理を実行する */
int executeImputation(
    InputImputation* inputImputation,
    long             divideNum,
    pid_t            pid);
/* Genotypeデータを統合する */
int margeGenotype(
    InputImputation* inputImputation,
    long             divideNum,
    pid_t            pid,
    SnpData*         hapmapSnpData,
    long             impPhasedSnpNum,
    long             impPhasedStartNum,
    long             hapmapSampleNum);
/* 入力データの整合性をチェックしてImputation用データを作成する */
long MakeImputationData(
    SnpData *hapmapTmpSnpData,
    SnpData *phasedSnpData,
    long hapmapFileLine,
    long phasedFileLine,
    SnpData **hapmapSnpData,
    long*               ldBlock,
    long                ldBlockNum);
/* 入力LDブロック範囲内の最初のSnp位置を取得する */
int getFirstSnpNum(
    SnpData*            snpData,
    long                snpNum,
    long*               ldBlock,
    long                ldBlockNum);

EXTERN int MyMpiSize; /* MPIのプロセス数 */
EXTERN int MyMpiRank; /* MPIの自己Rank   */

#ifdef MPI_USE
/* 時間計測用 */
#define NUM_TM          14
double tm[NUM_TM];
#define TM_START        0
#define TM_READ         1
#define TM_TRANS        2
#define TM_EST_SPLIT    3
#define TM_EST_BCAST    4            
#define TM_ESTIMATE     5
#define TM_EST_Barrier  6
#define TM_EST_MERGE    7
#define TM_SPLIT        8
#define TM_BCAST        9            
#define TM_MACH         10
#define TM_Barrier      11
#define TM_MERGE        12
#define TM_END          13
#endif /* MPI_USE */

#endif /* __HEADER_FILE_IMPUTATION__ */
