/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_CONFIG__
#define __HEADER_FILE_CONFIG__

//#define DBG
//#define Linux

/* データタイプ */
enum { TYPE_HAPMAP = 0 };    /* Hapmapデータをあらわす */
enum { TYPE_PHASED = 1 };    /* PhasedHapmapデータをあらわす */

/* Hapmapデータ読み込み時のパラメータ */
enum { HAPMAP_RS_NUM = 1 };    /* Hapmapデータのrs#列を示す */
enum { HAPMAP_ALLELES = 2 };   /* HapmapデータのSNPalleles列を示す */
enum { HAPMAP_CHROM = 3 };     /* Hapmapデータのchrom列を示す */
enum { HAPMAP_POS = 4 };       /* Hapmapデータのpos列を示す */
enum { HAPMAP_DATA = 12 };     /* Hapmapデータの遺伝子データ開始列 */

/* PhasingされたHapmapデータ読み込み時のパラメータ */
enum { PHASE_RS_NUM = 1 };     /* PhasingHapmapデータのrs#列を示す */
enum { PHASE_POS = 2 };        /* PhasingHapmapデータのpos列を示す */
enum { PHASE_DATA = 3 };       /* PhasingHapmapデータの遺伝子データ開始列 */

/* データ格納用構造体に用いるパラメータ */
enum { RS_NUM_LEN = 30};    /* rs#の文字数 */
enum { ALLELES_LEN = 6 };   /* SNPallelesの文字数 */
enum { CHROM_LEN = 6};      /* chromの文字列 */

/* 入力データ読み込み時のパラメータ */
enum { MAX_LEN = 1024 };    /* 入力データファイルの一行の最大文字数 */

/* コマンドライン最大文字数 */
enum { CMD_LEN = 2048 };

/* ON/OFFフラグ */
enum { FLAG_OFF = 0 };
enum { FLAG_ON  = 1 };

#endif /* __HEADER_FILE_CONFIG__ */
