#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "MemoryControl.h"
#include "Config.h"

/* 1次元配列のメモリ確保 */
void *malloc1Dim(int size, int dim1)
{
    int i = 0;
    void *array = NULL;

    /* メモリ確保 */
    array = malloc(size * dim1);
    if (NULL == array){
        printf("memory allocation error\n");
        return NULL;
    }

#ifdef DBG
    /* mallocカウントアップ */
    malloc_count++;
#endif

    /* 配列初期化 */
    memset(array, 0, size * dim1 );

    return array;
}

/* int型の2次元配列のメモリ確保 */
void **mallocInt2Dim(int dim1, int dim2)
{
    int i = 0;
    int j = 0;
    void **array = NULL;

    /* メモリ確保 */
    array = malloc1Dim(sizeof(int*), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = malloc1Dim(sizeof(int), dim2);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}

/* char型の2次元配列のメモリ確保 */
void **mallocChar2Dim(int dim1, int dim2)
{
    int i = 0;
    int j = 0;
    void **array = NULL;

    /* メモリ確保 */
    array = malloc1Dim(sizeof(char*), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = malloc1Dim(sizeof(char), dim2 + 1);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}

/* double型の2次元配列のメモリ確保 */
void **mallocDouble2Dim(int dim1, int dim2)
{
    int i = 0;
    int j = 0;
    void **array = NULL;

    /* メモリ確保 */
    array = malloc1Dim(sizeof(double*), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = malloc1Dim(sizeof(double), dim2 + 1);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}

/* int型の3次元配列のメモリ確保 */
void ***mallocInt3Dim(int dim1, int dim2, int dim3)
{
    int i = 0;
    int j = 0;
    int k = 0;
    void ***array = NULL;

    /* メモリ確保 */
    array = malloc1Dim(sizeof(int**), dim1);
    if (NULL == array){
        return NULL;
    }

    for (i = 0; i < dim1; i++){
        array[i] = mallocInt2Dim(dim2, dim3);
        if (NULL == array[i]){
            return NULL;
        }
    }

    return array;
}


/* 1次元配列のメモリ開放 */
void free1Dim(void *array)
{
    if (NULL != array){
        free(array);

#ifdef DBG
        /* mallocカウントダウン */
        malloc_count--;
#endif

    }
}

/* int型2次元配列のメモリ開放 */
void freeInt2Dim(int **array, int dim1)
{
    int i = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                free1Dim(array[i]);
            }
        }
        free(array);

#ifdef DBG
        /* mallocカウントダウン */
        malloc_count--;
#endif
    }
}

/* char型2次元配列のメモリ開放 */
void freeChar2Dim(char **array, int dim1)
{
    int i = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                free1Dim(array[i]);
            }
        }
        free(array);

#ifdef DBG
        /* mallocカウントダウン */
        malloc_count--;
#endif
    }
}

/* double型2次元配列のメモリ開放 */
void freeDouble2Dim(double **array, int dim1)
{
    int i = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                free1Dim(array[i]);
            }
        }
        free(array);

#ifdef DBG
        /* mallocカウントダウン */
        malloc_count--;
#endif
    }
}

/* int型3次元配列のメモリ開放 */
void freeInt3Dim(int ***array, int dim1, int dim2)
{
    int i = 0;
    int j = 0;

    if (NULL != array){
        for (i = 0; i < dim1; i++){
            if (NULL != array[i]){
                freeInt2Dim(array[i], dim2);
            }
        }
        free(array);

#ifdef DBG
        /* mallocカウントダウン */
        malloc_count--;
#endif
    }
}

/* molloc_countを返す */
int getMallocCount()
{
    return malloc_count;
}
