#include <stdlib.h>

#include "snp_Kuriage.h"

void KuriageSetParent(Kuriage* p, Kuriage* parent0){
  p->parent=parent0;
}

void KuriageInit(Kuriage* p){
  p->p_value = 0;
  p->parent = NULL;
  p->max = 9;
  p->min = 0;
}

void KuriageCount(Kuriage* p){
  if (p->p_value>=p->max){
    p->p_value = p->min;
    if(p->parent!=NULL) {
      KuriageCount(p->parent); // kuriage
    }
  }else{
    p->p_value++;
  }
}

int KuriageValue(Kuriage* p){
  return p->p_value;
}

int KuriageHasMore(Kuriage* p){
  if(p->p_value<p->max) return 1;
  if( (p->p_value==p->max) && (p->parent!=NULL) ) return KuriageHasMore(p->parent);
  return 0;
}

void KuriageUp(Kuriage* p, int n){
  if(n<0) return;
  if(n<=(p->max-p->p_value)){
    p->p_value+=n;
  }else{
    if(p->parent!=NULL) KuriageUp(p->parent, n-(p->max-p->p_value));
    p->p_value=p->max;
  }
}

void KuriageDown(Kuriage* p, int n){
  int tmp=0;
  if(p->parent!=NULL){
    KuriageCount(p->parent);
  }
  if(n< (p->p_value-(p->min+1)) ){ // genshoubun
    tmp = (p->p_value-(n+1)); // genshoubun
    p->p_value=tmp;
  }else{
    p->p_value=p->min;
    if(p->parent!=NULL){
      KuriageDown(p->parent, n-(p->p_value-p->min)+1);
    }      
  }
}
