/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_DATA_READER__
#define __HEADER_FILE_DATA_READER__

#include "snp_Config.h"
#include "snp_Table.h"

/* 入力データ格納用構造体 */
typedef struct struct_SNPData { 
	char rsNumber[RS_NUM_LEN];      /* rs# */ 
	char SNPalleles[SNP_NUM];       /* SNPalleles */
    char chrom[CHROM_LEN];          /* chrom */
    long pos;                       /* pos */
	//char SNPdata[SNP_DATA_LEN];     /* SNPデータ格納用 */
    char *SNPdata;                  /* SNPデータ格納用 */
    int allelesNum;                 /* SNPallelesのパターン数 */
    int dataNum;                    /* データのサンプル数 */
    int SNPallelesCount[SNP_COUNT]; /* SNPallelesと合致するデータ数 */
    int missingDataCount;           /* MissingData(N)のデータ数 */
    /* add 2010.11.10 高速化のため以下を追加 */
    //int flag;                       /* 初期化済フラグ */
    //char maximumNuc;                /* majorな塩基 */
} SnpData;

/* 出力データ格納用構造体 */
typedef struct struct_OutputData { 
    double Sobs;
    double Pr;
    double Hj;
    double F;
    double p;
    int count;
} OutputData;

/* プロトタイプ宣言 */
/* 入力ファイルを開く */
int InputFileOpen(FILE **fp, char *file);
/* 出力ファイルを開く */
int OutputFileOpen(FILE **fp, char *file);
/* ファイルを閉じる */
void FileClose(FILE *fp);

/* ファイルの行数をカウントする */
long DataReaderCountFileLine(FILE *fp);
/* 入力データを構造体に収める */
int DataReaderSetAllData(FILE *fp, SnpData *snpData, long line, int dataType);
/* 入力データ一行を構造体に収める */
int DataReaderSetData(FILE *fp, SnpData *snpData, long line, int dataType);
/* Hapmapデータを構造体に収める */
int DataReaderSetAllHapmapData(FILE *fp, SnpData *snpData, long line);
/* Hapmapデータ一行を構造体に収める */
int DataReaderSetHapmapData(FILE *fp, SnpData *snpData, long line);
/* HaplotypeDataを構造体に収める */
int DataReaderSetAllHaplotypeData(FILE *fp, SnpData *snpData, long line);
/* HaplotypeData一行を構造体に収める */
int DataReaderSetHaplotypeData(FILE *fp, SnpData *snpData, long line);
/* phasingされたHapmapデータを構造体に収める */
int DataReaderSetAllPhasingHapmapData(FILE *fp, SnpData *snpData, long line);
/* phasingされたHapmapデータ一行を構造体に収める */
int DataReaderSetPhasingHapmapData(FILE *fp, SnpData *snpData, long line);
/* 構造体SnpDataにサンプルデータをコピーする */
int DataReaderDataCopyToSnpData(SnpData *snpData, char *sampleData, long dataNum, long sampleNum);
/* 構造体SnpDataメンバのメモリを確保する */
int DataReaderSnpDataMemoryAllocate(SnpData *snpData, long dataNum, long sampleNum);
/* 構造体SnpDataメンバのメモリを開放する */
int DataReaderSnpDataMemoryFree(SnpData *snpData, long dataNum);
/* haplotypeブロック領域を配列に格納する */
int DataReaderSetHaplotypeBlockArea(FILE *fp, long *blockArea);
/* 構造体データをファイルに出力する */
//void DataReaderOutputAllData(FILE *fp, SnpData *snpData, long line);
/* 構造体データをファイルに出力する */
//void DataReaderOutputData(FILE *fp, SnpData *snpData);

/* 入力データを構造体に収める */
//int DataReaderSetInputData(char *filename, InputData *inputData);
/* 一行から値を返す */
//int DataReaderGetValue(FILE *fp, char *key, char *value);

/* ２つの入力データから偶現表を作成 */
int DataReaderMakeTable(SnpData *snpData1, SnpData *snpData2, int **T);
/* ２つのSNPalleleの順番入れ替える */
int DataReaderShiftSNPalleles(SnpData *snpData, int allele1, int allele2);
/* ２つのデータのSNPallelesの順番をチェック */
int DataReaderCheckSNPalleles(SnpData *snpData1, SnpData *snpData2);
/* 入力データの整合性をチェックして並列化用の入力データを作成する */
long DataReaderMakeParallelData(SnpData *snpTmpData1, SnpData *snpTmpData2, long line1, long line2, SnpData **snpData1, SnpData **snpData2, char **caseData, char **controlData);

/* 入力ファイルの情報をファイルに出力する */
//void DataReaderOutputHeader(FILE *fp, InputData *inputData);
/* 検定結果をファイルに出力する */
//void DataReaderOutputAllResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, InputData *inputData, long dataNum);
/* １遺伝子分の検定結果をファイルに出力する */
//void DataReaderOutputResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat);
/* 検定結果ファイル出力（level0） */
//void DataReaderOutputResultLevel0(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat);
/* 検定結果ファイル出力（level1） */
//void DataReaderOutputResultLevel1(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData);

/* 入力データのサンプル人数を取得する */
long DataReaderGetSampleNum(FILE *fp, int dataType);
/* HapmapDataのサンプル数を取得する */
long DataReaderGetHapmapSampleNum(FILE *fp);
/* HaplotypeDataのサンプル人数を取得する */
long DataReaderGetHaplotypeSampleNum(FILE *fp);
/* phasingされたHapmapデータのサンプル人数を取得する */
long DataReaderGetPhasingHapmapSampleNum(FILE *fp);

/* HaplotypeData一行の遺伝子データを配列に格納 */
int DataReaderSetHaplotypeSequence(FILE *fp, char **sequence, int index);
/* 各Haplotypeの頻度を計算 */
int DataReaderCalcHaplotypeFrequency(char **sequence, long dataNum, int L, double **frequency);
/* SnpDataをシーケンスに変換 */
int DataReaderSequences(SnpData *snpData, long start, long linkedSNPnum, char **sequence);

/* populationTypeを計算 */
int DataReaderPopulationType(SnpData *snpData1, SnpData *snpData2, int *populationType);
/* ２つの入力データとDiから偶現表を作成 */
int DataReaderMakeTableDi(SnpData *snpData1, SnpData *snpData2, int *d, int **T);
/* ２つの入力データとDiから偶現表を作成（呼び出し側で必要メモリ確保版） */
int DataReaderMakeTableDiMemoryGiven(SnpData *snpData1, SnpData *snpData2, int *d, int **T, int *data1, int *data2, int *data);
/* 参照文字を返す */
char DataReaderMaximumNuc(SnpData *snpData);
/* genotypeを計算 */
int DataReaderCalcGenotype(SnpData *snpData, char reference, int *result);
/* 各Haplotypeの頻度を計算 */
long DataReaderHaplotypeFrequency(SnpData *snpData1, SnpData *snpData2, long jStart, long jEnd, char ***haplotype, double **freq);
/* SnpDataをシーケンスに変換 */
int DataReaderSequences(SnpData *snpData, long jStart, long jEnd, char **sequence);
/* DNA配列データをSnpDataの配列に変換 */
int DataReaderSequenceToSnpData(char **sequences, SnpData *snpData, long dataNum, long size);

#endif /* __HEADER_FILE_DATA_READER__ */
