#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "snp_Permutation.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"
#include "snp_Random.h"

/* 順番をシャッフル */
int PermutationCalcOmega(int len, int* result, dsfmt_t *snp_dsfmt_data)
{
    int *flag = NULL;
    int h = 0;
    int i = 0;
    int x = 0;
    int retval = 0;

    /* flagのメモリ確保 */
    flag = (int*)malloc1Dim(sizeof(int), len);
    if (NULL == flag) {
        retval = 1;
        goto finalize;
    }

    /* 配列を0で初期化する */
    for (i = 0; i < len; i++){
        result[i] = 0;
        flag[i] = 0;
    }

    /* 順番をシャッフルする */
    for (h = 0; h < len; h++){
        x = 1;
        do{
            x = (int)(myRand(snp_dsfmt_data) * len);
            result[h] = x;
        } while(flag[x] > 0);
        flag[x]++;
    }

    /* 正常終了 */
    retval = 0;

finalize:;
    /* 確保したメモリを開放 */
	free1Dim(flag);

    return retval;
}

/* diを計算 */
int PermutationCalcDi(int n, int a, int *omega, int *result)
{
    int h = 0;
    int i = 0;

    /* 配列を0で初期化する */
    for (i = 0; i< n; i++){
        result[i] = 0;
    }

    for (h = 0; h < a; h++){
        result[ omega[h] ]++;   /* 0からa-1までをcaseとする */
    }

    return 0;
}

/* 偶現表を作成 */
int PermutationCalcT(int *d, int *genotype, int **result, int len)
{
    int h = 0;
    int i = 0;
    int j = 0;

    /* 引数resultを0で初期化する */
    for (i = 0; i < ROW; i++){
        for (j = 0; j < COLUMN; j++){
            result[i][j] = 0;
        }
    }

    /* 偶現表を作成 */
    for (h = 0; h < len; h++){
        result[ d[h] ][ genotype[h] ]++;
    }

    return 0;
}

int PermutationConditionedDi(int *genotype, int **T, int *result_type, dsfmt_t *snp_dsfmt_data)
{
    int a1 = T[0][0], /* case */
        a2 = T[0][1],
        a = a1 + a2;
    int b1 = T[1][0], /* control */
        b2 = T[1][1],
        b = b1 + b2;
    int n1 = a1 + b1,
        n2 = a2 + b2,
        n = n1 + n2;

    //int *count = NULL;
    int *tmp = NULL;
    //int **num = NULL;
    int **shuffle = NULL;

    int h = 0;
    int i = 0;
    int j = 0;
    int tag = 0;
    int gen = 0;
    int retval = 0;

    /* tmpのメモリ確保 */
    tmp = (int*)malloc1Dim(sizeof(int), VAL);
    if (NULL == tmp) {
        retval = 1;
        goto finalize;
    }
    tmp[0] = n1;
    tmp[1] = n2;
    ///* countのメモリ確保 */
    //count = (int*)malloc1Dim(sizeof(int), VAL);
    //if (NULL == tmp) {
    //    retval = 2;
    //    goto finalize;
    //}
    ///* numのメモリ確保 */
    //num = (int**)malloc1Dim(sizeof(int*), VAL);
    //if (NULL == num) {
    //    retval = 3;
    //    goto finalize;
    //}
    //for (i = 0; i < VAL; i++){
    //    num[i] = (int*)malloc1Dim(sizeof(int), tmp[i]);
    //    if (NULL == num[i]) {
    //        retval = 4;
    //        goto finalize;
    //    }
    //}
    /* shuffleのメモリ確保 */
    shuffle = (int**)malloc1Dim(sizeof(int*), VAL);
    if (NULL == shuffle) {
        retval = 5;
        goto finalize;
    }
    for (i = 0; i < VAL; i++){
        shuffle[i] = (int*)malloc1Dim(sizeof(int), tmp[i]);
        if (NULL == shuffle[i]) {
            retval = 6;
            goto finalize;
        }
    }

    //for (h = 0; h < n; h++){
    //    gen = genotype[h];
    //    num[gen][ count[gen] ] = h;
    //    count[gen]++;
    //}
    /* 多数の遺伝子型に対応できるように将来的には拡張する */

    /* 順序を入れ替える */
    for(gen = 0; gen < VAL; gen++){
        retval = PermutationCalcOmega(tmp[gen], shuffle[gen], snp_dsfmt_data);
    }

    /* 周辺度数に合わせてcaseとcontrolを割り振る */
    for (gen = 0; gen < 2; gen++){
        for (h = 0; h < tmp[gen]; h++){
            tag = shuffle[gen][h];
            if (h < T[0][gen]){
                result_type[tag] = 0;
            }
            else{
                result_type[tag] = 1;
            }
        }
    }

    /* 正常終了 */
    retval = 0;

finalize:;
    /* 確保したメモリを開放する */
	free1Dim(tmp);
	//free1Dim(count);
    //freeInt2Dim(num, VAL);
    freeInt2Dim(shuffle, VAL);

	return retval;
}
