/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_TABLE__
#define __HEADER_FILE_TABLE__

/* メルセンヌツイスター */
#include "dSFMT.h"

typedef struct struct_SnpTable { 
	int *horizontalSum; /* 横方向（行）ごとの合計。行の数だけ要素がある配列 */
	int *verticalSum;   /* 縦方向（列）ごとの合計。列の数だけ要素がある配列 */
	int **table;
} SnpTable;

/* プロトタイプ宣言 */
int TableMain();
int TableInitTable(SnpTable *tbl);
int TableCreateTable(SnpTable *tbl, int numHori, int numVert);
int TableFinalTable(SnpTable *tbl);
int TableMakeTable4Int(SnpTable *tbl, int a1, int a2, int b1, int b2);
int TableMakeTableIntArray(SnpTable *tbl, int **T);
int **TableGetTable(SnpTable T);
int TableNewCandidate(SnpTable tbl, int a1, int **result);
int TableNewTable(SnpTable tbl, int a1, int **result);
int TableCalcL(SnpTable tbl);
int TableCalcU(SnpTable tbl);
double TableCalcPearsonScore(int **T);
int TableCalcV(SnpTable tbl, double Sobs);
int TableCalcW(SnpTable tbl, double Sobs);
double TableRootD(SnpTable tbl, double Sobs);
double TableDiscriminant(SnpTable tbl, double Sobs);
int TableTwoParts(SnpTable tbl, double Sobs);
double TableCalcFst(int **T);
void TableShowMatrix(int **data, int len1, int len2);
void TableShowVector(int *data, int len);
double TableCalcMu(int **T);
double TableCalcNu(int **T, double Sobs);
int TableInCj(double Sobs, int **T, int len1, int len2);
int TableJudgeCj(double Sobs, int **T, int len1, int len2);
double TableCalcR(int **T1, int len1, int len2, int **T2);
double TableCalcScore(int **T);
double TableCalcLogMu(int **T);
void TableMarkov1(SnpTable T, double Score, int **table, dsfmt_t *snp_dsfmt_data);
void TableMarkov2(SnpTable T, double Score, int **table, dsfmt_t *snp_dsfmt_data);
int TablePlusMinusOne(dsfmt_t *snp_dsfmt_data);

#endif /* __HEADER_FILE_TABLE__ */
