#!/bin/sh

if [ $# != 5 ];
  then
    echo "[usage]`basename $0` [InputFile] [LDblockFile] [OutputFile] [PhasingType] [SNPNumLimit]"
    exit
fi

InputFile=$1
LDblockFile=$2
OutputFile=$3
PhasingType=$4
SNPNumLimit=$5

ScriptFile=`basename $OutputFile`.batch

### InputFile is not exist, exit
#if [ ! -e "$InputFile" ];
#  then
#    echo "$InputFile is not exist"
#    exit
#fi

### LDblockFile is not exist, exit
#if [ ! -e "$LDblockFile" ];
#  then
#    echo "$LDblockFile is not exist"
#    exit
#fi

### Check PhasingType
#if [ $PhasingType != 0 -a $PhasingType != 1 ];
#  then
#    echo "Input error of PhasingType"
#    exit
#fi


### Make BatchScriptFile
echo "#!/bin/sh" > $ScriptFile
echo "" >> $ScriptFile
echo "#FX: -time 2:00:00" >> $ScriptFile
echo "#FX: -q fx32" >> $ScriptFile
echo "#FX: -eo" >> $ScriptFile
echo "" >> $ScriptFile
echo "cd \${QSUB_WORKDIR}" >> $ScriptFile
echo "haplotypePhasing.exe $InputFile $LDblockFile $OutputFile $PhasingType $SNPNumLimit" >> $ScriptFile

### Execute Batch Job
qsub $ScriptFile

### Delete BatchScriptFile
rm $ScriptFile
