#!/bin/sh

if [ $# != 9 ];
  then
    echo "[usage]`basename $0` [HapmapDataFile] [PhasedHapmapDataFile] [LDblockFile] [RecombinationFile] [ErrorRateFile] [OutputFile] [SamplePerDivision] [EstimateSampleNum] [ProcNum]"
    exit
fi

HapmapDataFile=$1
PhasedHapmapDataFile=$2
LDblockFile=$3
RecombinationFile=$4
ErrorRateFile=$5
OutputFile=$6
SamplePerDivision=$7
EstimateSampleNum=$8
ProcNum=$9

ScriptFile=`basename $OutputFile`.batch

### HapmapDataFile is not exist, exit
#if [ ! -e "$HapmapDataFile" ];
#  then
#    echo "$HapmapDataFile is not exist"
#    exit
#fi
### PhasedHapmapDataFile is not exist, exit
#if [ ! -e "$PhasedHapmapDataFile" ];
#  then
#    echo "$PhasedHapmapDataFile is not exist"
#    exit
#fi
### LDblockFile is not exist, exit
#if [ ! -e "$LDblockFile" ];
#  then
#    echo "$LDblockFile is not exist"
#    exit
#fi
### RecombinationFile,ErrorRateFile is not exist, exit
#if [ ! -e "$RecombinationFile" -a $EstimateSampleNum = 0 ];
#  then
#    echo "$RecombinationFile is not exist"
#    exit
#fi
#if [ ! -e "$ErrorRateFile" -a $EstimateSampleNum = 0 ];
#  then
#    echo "$ErrorRateFile is not exist"
#    exit
#fi


### Make BatchScriptFile
echo "#!/bin/sh" > $ScriptFile
echo "" >> $ScriptFile
echo "#FX: -proc $ProcNum" >> $ScriptFile
echo "#FX: -time 2:00:00" >> $ScriptFile
echo "#FX: -q fx32" >> $ScriptFile
echo "#FX: -eo" >> $ScriptFile
echo "" >> $ScriptFile
echo "cd \${QSUB_WORKDIR}" >> $ScriptFile
echo "mpiexec -n \${QSUB_VNODES} imputationParallel.exe $HapmapDataFile $PhasedHapmapDataFile $LDblockFile $RecombinationFile $ErrorRateFile $OutputFile $SamplePerDivision $EstimateSampleNum" >> $ScriptFile

### Execute Batch Job
qsub $ScriptFile

### Delete BatchScriptFile
rm $ScriptFile
