#!/bin/sh

if [ $# != 9 ];
  then
    echo "[usage]`basename $0` [InputFile1] [InputFile2] [OutputFile1] [AreaFileType] [BlockAreaFile] [Score] [Repeat] [Generation] [DataType]"
    exit
fi

InputFile1=$1
InputFile2=$2
OutputFile1=$3
AreaFileType=$4
BlockAreaFile=$5
Score=$6
Repeat=$7
Gen=$8
DataType=$9
ScriptFile=`basename $OutputFile1`.batch

### InputFile1 is not exist, exit
if [ ! -e "$InputFile1" ];
  then
    echo "$InputFile1 is not exist"
    exit
fi

### InputFile2 is not exist, exit
if [ ! -e "$InputFile2" ];
  then
    echo "$InputFile2 is not exist"
    exit
fi

### Check AreaFileType
if [ $AreaFileType != 0 -a $AreaFileType != 1 ];
  then
    echo "Input error of AreaFileType"
    exit
fi

### BlockAreaFile is not exist, exit
if [ ! -e "$BlockAreaFile" ];
  then
    echo "$BlockAreaFile is not exist"
    exit
fi

### Check Score
if [ $Score != 0 -a $Score != 1 ];
  then
    echo "Input error of Score"
    exit
fi

### Check DataType
if [ $DataType != 0 -a $DataType != 1 -a $DataType != 2 ];
  then
    echo "Input error of DataType"
    exit
fi


### Make BatchScriptFile
echo "#!/bin/sh" > $ScriptFile
echo "" >> $ScriptFile
echo "#MJS: -pc" >> $ScriptFile
echo "#MJS: -time 24:00:00" >> $ScriptFile
echo "#MJS: -cwd" >> $ScriptFile
echo "#MJS: -eo" >> $ScriptFile
echo "#MJS: -rerun y" >> $ScriptFile
echo "" >> $ScriptFile
echo "#BEFORE:MASTER: $InputFile1" >> $ScriptFile
echo "#BEFORE:MASTER: $InputFile2" >> $ScriptFile
echo "#BEFORE:MASTER: $BlockAreaFile" >> $ScriptFile
#echo "#AFTER:MASTER@\${MJS_CWD}: ${MJS_CWD}$OutputFile1" >> $ScriptFile
echo "#AFTER:MASTER:$OutputFile1" >> $ScriptFile
#echo "#BEFORE:*: ../bin/typeI.exe" >> $ScriptFile
echo "#BEFORE:*: $SNP_HOME/bin/typeI.exe" >> $ScriptFile
echo "" >> $ScriptFile
echo "cd \${MJS_CWD}" >> $ScriptFile
echo "typeI.exe $InputFile1 $InputFile2 $OutputFile1 $AreaFileType $BlockAreaFile $Score $Repeat $Gen $DataType" >> $ScriptFile

### Execute Batch Job
qsub $ScriptFile

### Delete BatchScriptFile
rm $ScriptFile
