#include <stdlib.h>
#include <string.h>
#include "ge_strutl.h"

/* 空白区切り文字列操作 */
/* 指定した番号のカラムを抜き出し。 whichindex は0からはじまる。   */
/* 空白区切りは空白が連続した場合の処理が必要なので、単純ではない。*/
int spcExtractCol(char* oneline, int whichindex, int extColSize, char* extCol)
{
  int RetVal     = 0;
  int index      = 0;
  int index2     = 0;
  int SPCIndex   = 0;
  char spc       = ' '; //区切り文字
  char spcflag   = 0;

  //最初の文字がNULLであった場合は空文字列。
  if (oneline[0] == '\0') {
    RetVal = 2; extCol[0] = '\0'; goto exit_function;
  }

  //抜き出し文字列用メモリバッファの初期化
  memset(extCol,'\0',extColSize);

  //最初のカラムを抜き出す場合、最初の文字から空白文字まで。
  if (whichindex == 0) {
    index = 0; extCol[0] = '\0';
    if (oneline[index] != spc) { //空白文字でなければ文字列取り出し
      while ((oneline[index] != '\0') && (oneline[index] != spc)) {
        extCol[index] = oneline[index];
        index++;
      }
    } else {
      while (oneline[index] == spc) { //連続した空白文字の場合は飛ばす
        index++;
      }
      while ((oneline[index] != '\0') && (oneline[index] != spc)) {
        extCol[index] = oneline[index];
        index++;
      }
    }
    extCol[index] = '\0'; // 文字列の最後
  } else {
    index = 0;SPCIndex = 0;
    /* spc を数えて取り出し直前までindexを増やす */
    spcflag = 0;
    while (oneline[index] != '\0') {
      if (oneline[index] == spc) {
        spcflag = 1; //文字がspcならspcflag=1を保持する。
      } else {
        if (spcflag == 1) { //文字がspcでなく、かつ直前の文字がspcならSPCIndexを+1する。
          SPCIndex++;
          spcflag = 0; //フラグを下げる。
        }
        if (SPCIndex == whichindex) {
          break; // whileを抜ける。
        }
      }
      index++;
    }
    // indexは直前位置文字がspcで、index位置文字はspcでは無い位置。
    // ここから文字列を抜き出す。
    index2 = 0;
    while ((oneline[index] != '\0') && (oneline[index] != spc)) {
      extCol[index2] = oneline[index];
      index++;
      index2++;
    }
    extCol[index2] = '\0';
  }

exit_function:;
  return RetVal;
}

/* csv文字列操作 */
/* csvカラム数を数える。*/
int csvCountCol(char* oneline)
{
  int RetVal = 0;
  int index = 0;

  // 空白文字列の場合
  if (oneline[0] == '\0') {
    RetVal = 0; goto emergencyexit;
  }

  // カンマの数を数えて1を足す(植木算)
  index = 0;
  RetVal = 0;
  while( oneline[index] != '\0') {
    if (oneline[index] == ',') {
      RetVal++;
    }
    index++;
  }
  RetVal++; /* 植木算 */

emergencyexit:;
  return RetVal;
}

/* csv文字列操作 */
/* csvである文字列の指定した番号のカラムを抜き出し。 whichindex は0からはじまる。 */
/* この関数はカンマがエスケープできない。                                         */
int csvExtractCol(char* oneline, int whichindex, char* extCol)
{
  int RetVal = 0;
  int index = 0;
  int index2 = 0;
  int CommaIndex = 0;
  int ColNum = 0;

  // NULL文字列の場合の処理
  if (oneline[0] == '\0') {
    RetVal = 2; extCol[0] = '\0'; goto emergencyexit;
  }

  // まずカラムの数を数える。
  ColNum = csvCountCol(oneline);
  if (whichindex >= ColNum) {
    RetVal = -1; goto emergencyexit;
  }

  if (whichindex == 0) {  // 先頭カラムの抜き出しの場合
    index = 0; extCol[0] = '\0';
    while ((oneline[index] != '\0') && (oneline[index] != ',')) {
      extCol[index] = oneline[index];
      index++;
    }
    extCol[index] = '\0';
  } else { // 先頭以外のカラムの場合
    index = 0;CommaIndex = 0;
    /* comma を数えて取り出しカラム直前までindexを増やす */
    while (oneline[index] != '\0') {
      if (oneline[index] == ',') {
        CommaIndex++;
      }
      if (CommaIndex == whichindex) {
        break;
      }
      index++;
    }
    index++; /* カンマの次の文字へ */
    index2 = 0;
    while ((oneline[index] != '\0') && (oneline[index] != ',')) {
      extCol[index2] = oneline[index];
      index++;
      index2++;
    }
    extCol[index2] = '\0';
  }

emergencyexit:;
  return RetVal;
}

/* 私家版 isnumerical() */
/* 与えられた文字列が数値に変換できるかどうかを調べる。*/
int StrCanBeANum(char* numstring)
{
/*
  RetVal : -2 : string length > 128
           -1 : Can not be a number
            0 : Integer
            1 : real (not float)
            2 : real (float)
*/

  int RetVal = 0;
  int length = 0;

  unsigned int i;

  char periodflag0 = 0;
  char periodflag1 = 0;
  unsigned int periodposition0 = 0;
  unsigned int periodposition1 = 0;
  char eflag = 0;
  unsigned int eposition = 0;

  if (numstring == '\0') { RetVal = -2; goto emergencyexit0; }
  length = RmTopLastSpaceAndRet(numstring);
  if ( (length > 128) || (length <= 0) ){ RetVal = -2; goto emergencyexit0; }

  periodflag0 = 0;
  periodflag1 = 0;
  eflag = 0;
  for (i=0;i<(unsigned int)length;i++) {

    if (
        (
         (numstring[i] < 48) || (numstring[i] > 57)
        ) &&
         (numstring[i] != '.') &&
         (numstring[i] != 'E') && (numstring[i] != 'e') &&
         (numstring[i] != '+') && (numstring[i] != '-')
       ) {
      RetVal = -1; goto emergencyexit0;
    }
    if ((periodflag0 == 0) && (eflag == 0) && (numstring[i] == '.')) {
      periodflag0 = 1; periodposition0 = i; goto next_char;
    }
    if ((periodflag0 == 0) && (eflag == 1) && (numstring[i] == '.')) {
      periodflag1 = 1; periodposition1 = i; goto next_char;
    }
    if ((periodflag0 == 1) && (numstring[i] == '.')) {
      RetVal = -1; goto emergencyexit0;
    }
    if ((eflag == 0) && ((numstring[i] == 'e') || (numstring[i] == 'E'))) {
      eflag = 1; eposition = i; goto next_char;
    }
    if ((eflag == 1) && ((numstring[i] == 'e') || (numstring[i] == 'E'))) {
      RetVal = -1; goto emergencyexit0;
    }
    if ((numstring[i] == '+') || (numstring[i] == '-')) {
      if ((i != 0) && (eflag == 0)) { RetVal = -1; goto emergencyexit0; }
      if ((eflag == 1) && (i != (eposition + 1))) { RetVal = -1; goto emergencyexit0; }
    }
next_char:;
  }

  if ((periodflag0 == 0) && (eflag == 0)) { RetVal = 0; goto emergencyexit0; }
  if ((periodflag0 == 1) && (eflag == 0)) { RetVal = 1; goto emergencyexit0; }
  if ((periodflag0 == 1) && (eflag == 1)) { RetVal = 2; goto emergencyexit0; }
  if ((periodflag0 == 0) && (eflag == 1)) { RetVal = 2; goto emergencyexit0; }


emergencyexit0:;
  return RetVal;
}

/* 私家版trim */
/* 最初と最後の続いている空白文字と最後のリターンコードを削除する。*/
int RmTopLastSpaceAndRet(char* numstring) {

  int RetVal = 0;
  int length = 0;
  int i;
  char* copyelement = NULL;
  unsigned int ibase = 0;

  length = (int)strlen(numstring);
  if (length <= 0) { RetVal = 0; goto emergencyexit; }

  copyelement = (char*)malloc((length+1) * sizeof(char));
  if (copyelement == NULL) { RetVal = -1; goto emergencyexit; }

  for (i=0;i<length;i++) { copyelement[i] = numstring[i]; }
  copyelement[length] = '\0';

// トップの空白を除去
  ibase = 0;
  for (i=0;i<length;i++) {
    if (numstring[i] != ' ' && numstring[i] != '\t') break;
    ibase = ibase + 1;
  }
  for (i=ibase;i<length;i++) { numstring[i - ibase] = copyelement[i]; }
  numstring[length - ibase] = '\0';

// ラストの空白とリターンを除去
  length = (int)strlen(numstring);
  for (i=(length-1);i>=0;i--) {
    if (( numstring[i] != '\n' ) && ( numstring[i] != ' ' ) && (numstring[i] != '\t') ) break;
    numstring[i] = '\0';
  }
  RetVal = (int)strlen(numstring);

  free(copyelement);
emergencyexit:;

  return RetVal;
}

/* ファイルの拡張子がExStrと同じかどうか調べる。       */
/* OrgStrにファイル名を入れる。                        */
/* OrgStrの拡張子がExStrと同じなら 0を返す。           */
/* 異なれば負の値を返す。                              */
/* 空白文字を数えるのでOrgStrの後に空白をつけないこと。*/
int FileExCheck(char* OrgStr, char* ExStr)
{
  int   RetVal = 0;
  int   iresult = 0;
  int   i,j;
  int   checklength  = 0;
  int   OrgStrLength = 0;
  int   OrgExLength  = 0;
  char* OrgEx = NULL;
  int   index = 0,i0;

  checklength = (int)strlen(ExStr);

  OrgEx = (char*)calloc(1,checklength * sizeof(char));
  if (OrgEx == NULL) { RetVal = 1; goto exit_function; }

  // 後ろから数えて'.'の最初の位置をもとめる。
  OrgStrLength = (int)strlen(OrgStr);
  if (OrgStr[OrgStrLength-1] == '\n') { OrgStr[OrgStrLength-1] = '\0'; }
  OrgStrLength = (int)strlen(OrgStr);
  for (i=(OrgStrLength-1);i>0;i--) {
    if (OrgStr[i] == '.') {
      break;
    }
  }
  index = OrgStrLength - 1 - i;
  if (index != checklength) { RetVal = -1; goto exit_function; } // 拡張子の長さ違い
  j = 0;
  i0 = i + 1;
  for (i=i0;i<OrgStrLength;i++) {
    OrgEx[j] = OrgStr[i];
    j++;
  }
  iresult = strncmp(OrgEx,ExStr,checklength);
  if (iresult != 0) { RetVal = -2; } else { RetVal = 0; }

exit_function:;
  if (OrgEx != NULL) { free(OrgEx); }
  return RetVal;
}

// 入力検査などをせず、いくつかのカラムを一度に分解する。入力チェック無し。
// OneLine : 入力一行
// maxcol  : カラムの最大長さ
// NumOfCol: カラム数
// extCol  : カラム数だけの数のカラム
int csvEasyExtractCol(char DivCh, char* OneLine, int maxcol, int NumOfCol, char* extCol)
{
  int RetVal = 0;
  int index  = 0;
  int icol   = 0;
  int ichar  = 0;
  int icp    = 0;
  char Achar;

  memset(extCol,'\0',maxcol*NumOfCol);

  ichar = 0; // OneLine中での文字位置
  icol  = 0; // カラムの番号
  icp   = 0; // カラム内での文字インデックス
  do {
    Achar = OneLine[ichar];
    //if (Achar == '\0') { break; } // 文字列OneLineの終わり。//最後の'\0'もextColにセットする。
    index = icol * maxcol + icp; // extCol内での文字位置
    if (Achar == DivCh) {
      extCol[index] = '\0';
      icol++; // 次のカラムへ
      if (icol >= NumOfCol) { break; } // 念のため、カラム番号をチェックしておく。
      icp = 0; // カラム内での文字位置をリセット
      ichar++; // カラム位置からひとつ進める。
      continue;
    } else if (Achar == '\n') {  // 一行を分解する関数なので、改行なら終わり。
      extCol[index] = '\0'; break;
    }

    extCol[index] = Achar; // Acharが','でも'\n'でもない場合はそのまま代入する。

    icp++; // カラム内文字インデックスを増やす。
    ichar++; //
  } while (Achar != '\0');

  return RetVal;
}

/* tab区切文字列操作 */
/* tab区切カラム数を数える。*/
int tabCountCol(char* oneline)
{
  int RetVal = 0;
  int index = 0;

  if (oneline[0] == '\0') {
    RetVal = 0; goto emergencyexit;
  }

  index = 0;
  RetVal = 0;
  while( oneline[index] != '\0') {
    if (oneline[index] == '\t') {
      RetVal++;
    }
    index++;
  }
  RetVal++; /* 植木算 */

emergencyexit:;
  return RetVal;
}

/* tab区切文字列操作 */
/* tab区切である文字列の指定した番号のカラムを抜き出し。 whichindex は0からはじまる。 */
int tabExtractCol(char* oneline, int whichindex, char* extCol)
{
  int RetVal = 0;
  int index = 0;
  int index2 = 0;
  int CommaIndex = 0;
  int ColNum = 0;
  char DivChar = '\t';

  if (oneline[0] == '\0') {
    RetVal = 2; extCol[0] = '\0'; goto emergencyexit;
  }

  ColNum = tabCountCol(oneline);
  if (whichindex >= ColNum) {
    RetVal = -1; goto emergencyexit;
  }

  if (whichindex == 0) {
    index = 0; extCol[0] = '\0';
    while ((oneline[index] != '\0') && (oneline[index] != DivChar)) {
      extCol[index] = oneline[index];
      index++;
    }
    extCol[index] = '\0';
  } else {
    index = 0;CommaIndex = 0;
    /* comma を数えて取り出し直前までindexを増やす */
    while (oneline[index] != '\0') {
      if (oneline[index] == DivChar) {
        CommaIndex++;
      }
      if (CommaIndex == whichindex) {
        break;
      }
      index++;
    }
    index++; /* tabの次の文字へ */
    index2 = 0;
    while ((oneline[index] != '\0') && (oneline[index] != DivChar)) {
      extCol[index2] = oneline[index];
      index++;
      index2++;
    }
    extCol[index2] = '\0';
  }

emergencyexit:;
  return RetVal;
}

// "//"以降を削除する。返値は'/'の位置
int slashCommentCut(char* oneline)
{
  int RetVal = 0;
  int length = 0;
  int i;

  length = (int)strlen(oneline);
  for (i=0;i<(length-1);i++) {
    if ((oneline[i] == '/') && (oneline[i+1] == '/')) { // "//"ならば最初の'/'以降を
      oneline[i] = '\0'; // 無いことにする。
      break;
    }
  }

  RetVal = i; // 切った位置を返す。
  return RetVal;
}

/* 文字列操作 */
/* divchar(空白文字以外のascii文字)で区切られた一行のカラム数を数える。*/
int charCountCol(char divchar, char* oneline)
{
  int RetVal = 0;
  int index = 0;

  // 空白文字列の場合
  if (oneline[0] == '\0') {
    RetVal = 0; goto emergencyexit;
  }

  // カンマの数を数えて1を足す(植木算)
  index = 0;
  RetVal = 0;
  while( oneline[index] != '\0') {
    if (oneline[index] == divchar) {
      RetVal++;
    }
    index++;
  }
  RetVal++; /* 植木算 */

emergencyexit:;
  return RetVal;
}

/* 文字列操作 */
/* divchar(空白文字以外のascii文字)で区切られたある文字列の指定した番号のカラムを抜き出し。 whichindex は0からはじまる。 */
/* この関数はカンマがエスケープできない。                                         */
int charExtractCol(char divchar, char* oneline, int whichindex, char* extCol)
{
  int RetVal = 0;
  int index = 0;
  int index2 = 0;
  int CommaIndex = 0;
  int ColNum = 0;

  // NUL文字列の場合の処理
  if (oneline[0] == '\0') {
    RetVal = 2; extCol[0] = '\0'; goto emergencyexit;
  }

  // まずカラムの数を数える。
  ColNum = charCountCol(divchar,oneline);
  if (whichindex >= ColNum) {
    RetVal = -1; goto emergencyexit;
  }

  if (whichindex == 0) {  // 先頭カラムの抜き出しの場合
    index = 0; extCol[0] = '\0';
    while ((oneline[index] != '\0') && (oneline[index] != divchar)) {
      extCol[index] = oneline[index];
      index++;
    }
    extCol[index] = '\0';
  } else { // 先頭以外のカラムの場合
    index = 0;CommaIndex = 0;
    /* divchar を数えて取り出しカラム直前までindexを増やす */
    while (oneline[index] != '\0') {
      if (oneline[index] == divchar) {
        CommaIndex++;
      }
      if (CommaIndex == whichindex) {
        break;
      }
      index++;
    }
    index++; /* カンマの次の文字へ */
    index2 = 0;
    while ((oneline[index] != '\0') && (oneline[index] != divchar)) {
      extCol[index2] = oneline[index];
      index++;
      index2++;
    }
    extCol[index2] = '\0';
  }

emergencyexit:;
  return RetVal;
}

// CommentChar以降を削除する。返値はCommentCharの位置
int charCommentCut(char CommentChar,char* oneline)
{
  int RetVal = 0;
  int length = 0;
  int i;

  length = (int)strlen(oneline);
  for (i=0;i<length;i++) {
    if (oneline[i] == CommentChar) { // CommentCharならばCommentChar以降を無いことにする。
      oneline[i] = '\0';
      break;
    }
  }

  RetVal = i; // 切った位置を返す。
  return RetVal;
}

// rmChar で指定される文字を消去して左詰めする。
int charRmChar(char rmChar, char* oneline)
{
  int RetVal = 0;
  int i;
  int index;
  int length = 0;
  char* copystring = NULL;

  length = (int)strlen(oneline);
  copystring = (char*)calloc((length + 1),sizeof(char));
  if (copystring == NULL) { RetVal = 1; goto exit_function; }

  index = 0; // コピー側の文字位置
  for (i=0;i<length;i++) {
    if (oneline[i] != rmChar) { // rmCharでないとき、oneline文字列をcopystringにコピー。
      copystring[index] = oneline[i];
      index++;
    }
  }
  copystring[index] = '\0';
  memset(oneline,'\0',length); // 元文字列を0クリア。
  strcpy(oneline,copystring);  // 元文字列位置にrmCharを除いたコピー文字列をコピー。

exit_function:;
  if (copystring != NULL) { free(copystring); }
  return RetVal;
}

//add by yyukawa:2008/5/12
/* csv文字列操作 */
/* csvである文字列のカラムを一気に配列にコピーする */
/* この関数はカンマがエスケープできない。                                         */
int csvCopyCol(char* oneline, char** copycol, int maxcolnum)
{
  int RetVal = 0;
  int index = 0;
  int index2 = 0;
  int CommaIndex = 0;
  int ColNum = 0;

  // NULL文字列の場合の処理
  if (oneline[0] == '\0') {
    RetVal = 2; copycol[CommaIndex][0] = '\0'; goto emergencyexit;
  }

  // まずカラムの数を数える。
  ColNum = csvCountCol(oneline);
  if (maxcolnum < ColNum) {
    RetVal = -1; goto emergencyexit;
  }

  // 先頭カラムの抜き出し
  {
    index = 0; copycol[CommaIndex][0] = '\0';
    while ((oneline[index] != '\0') && (oneline[index] != ',')) {
      copycol[CommaIndex][index] = oneline[index];
      index++;
    }
    copycol[CommaIndex][index] = '\0';
    CommaIndex++;
  }
  // 先頭以外のカラムの場合
  while(CommaIndex < ColNum) {
    //index = 0;CommaIndex = 0;
    index++; /* カンマの次の文字へ */
    index2 = 0;
    while ((oneline[index] != '\0') && (oneline[index] != ',')) {
      copycol[CommaIndex][index2] = oneline[index];
      index++;
      index2++;
    }
    copycol[CommaIndex][index2] = '\0';
    CommaIndex++;
    if(oneline[index] == '\0') {
      break;
    }
  }
  //カラム数を返す
  RetVal = ColNum;

emergencyexit:;
  return RetVal;
}
//add by yyukawa:2008/6/12
/* tab文字列操作 */
/* tab区切りである文字列のカラムを一気に配列にコピーする */
int tabCopyCol(char* oneline, char** copycol, int maxcolnum)
{
  int RetVal = 0;
  int index = 0;
  int index2 = 0;
  int CommaIndex = 0;
  int ColNum = 0;

  // NULL文字列の場合の処理
  if (oneline[0] == '\0') {
    RetVal = 2; copycol[CommaIndex][0] = '\0'; goto emergencyexit;
  }

  // まずカラムの数を数える。
  ColNum = tabCountCol(oneline);
  if (maxcolnum < ColNum) {
    RetVal = -1; goto emergencyexit;
  }

  // 先頭カラムの抜き出し
  {
    index = 0; copycol[CommaIndex][0] = '\0';
    while ((oneline[index] != '\0') && (oneline[index] != '\t')) {
      copycol[CommaIndex][index] = oneline[index];
      index++;
    }
    copycol[CommaIndex][index] = '\0';
    CommaIndex++;
  }
  // 先頭以外のカラムの場合
  while(CommaIndex < ColNum) {
    //index = 0;CommaIndex = 0;
    index++; /* カンマの次の文字へ */
    index2 = 0;
    while ((oneline[index] != '\0') && (oneline[index] != '\t')) {
      copycol[CommaIndex][index2] = oneline[index];
      index++;
      index2++;
    }
    copycol[CommaIndex][index2] = '\0';
    CommaIndex++;
    if(oneline[index] == '\0') {
      break;
    }
  }
  //カラム数を返す
  RetVal = ColNum;

emergencyexit:;
  return RetVal;
}
//add by yyukawa:2008/11/4
/* 空白区切りである文字列のカラムを一気に配列にコピーする */
/* 空白区切カラム数を数える。*/
int spcCountCol(char* oneline)
{
  int RetVal = 0;
  int index = 0;

  if (oneline[0] == '\0') {
    RetVal = 0; goto emergencyexit;
  }

  index = 0;
  RetVal = 0;
  while( oneline[index] != '\0') {
    if (oneline[index] == ' ') {
      RetVal++;
    }
    index++;
  }
  RetVal++; /* 植木算 */

emergencyexit:;
  return RetVal;
}
int spcCopyCol(char* oneline, char** copycol, int maxcolnum)
{
  int RetVal = 0;
  int index = 0;
  int index2 = 0;
  int CommaIndex = 0;
  int ColNum = 0;

  // NULL文字列の場合の処理
  if (oneline[0] == '\0') {
    RetVal = 2; copycol[CommaIndex][0] = '\0'; goto emergencyexit;
  }

  // まずカラムの数を数える。
  ColNum = spcCountCol(oneline);
  if (maxcolnum < ColNum) {
    RetVal = -1; goto emergencyexit;
  }

  // 先頭カラムの抜き出し
  {
    index = 0; copycol[CommaIndex][0] = '\0';
    while ((oneline[index] != '\0') && (oneline[index] != ' ')) {
      copycol[CommaIndex][index] = oneline[index];
      index++;
    }
    copycol[CommaIndex][index] = '\0';
    CommaIndex++;
  }
  // 先頭以外のカラムの場合
  while(CommaIndex < ColNum) {
    //index = 0;CommaIndex = 0;
    index++; /* カンマの次の文字へ */
    index2 = 0;
    while ((oneline[index] != '\0') && (oneline[index] != ' ')) {
      copycol[CommaIndex][index2] = oneline[index];
      index++;
      index2++;
    }
    copycol[CommaIndex][index2] = '\0';
    CommaIndex++;
    if(oneline[index] == '\0') {
      break;
    }
  }
  //カラム数を返す
  RetVal = ColNum;

emergencyexit:;
  return RetVal;
}
