#include <stdio.h>
#include <stdlib.h>
#include <math.h>
//#include <iostream>
#include <string>
//#include <vector>
#include <search.h>

//#define _TEST_OUT

extern "C" int printflag;

extern "C" {
// ysh string utilities : 変更改修版　for RPD project.
// 200603 NIS ysh
/* 空白区切り文字列操作 */
/* 指定した番号のカラムを抜き出し。 whichindex は0からはじまる。 */
int spcExtractCol(char* oneline, int whichindex, int extColSize, char* extCol);
/* csv文字列操作 */
/* csvカラム数を数える。*/
int csvCountCol(char* oneline);
/* csv文字列操作 */
/* csvである文字列の指定した番号のカラムを抜き出し。 whichindex は0からはじまる。 */
int csvExtractCol(char* oneline, int whichindex, char* extCol);
/* 私家版 isnumerical() */
/* 与えられた文字列が数値に変換できるかどうかを調べる。*/
int StrCanBeANum(char* numstring);
/* 私家版trim */
/* 最初と最後の続いている空白文字と最後のリターンコードを削除する。*/
int RmTopLastSpaceAndRet(char* numstring);
/* ファイル拡張子のチェック */
int FileExCheck(char* OrgStr, char* ExStr);
/* 簡易型カラム抜き出し。エラーチェックなし。一度にカラムに分解。*/
int csvEasyExtractCol(char DivCh, char* OneLine, int maxcol, int NumOfCol, char* extCol);
/* tab区切文字列操作 */
/* tab区切カラム数を数える。*/
int tabCountCol(char* oneline);
/* tab区切文字列操作 */
/* tab区切である文字列の指定した番号のカラムを抜き出し。 whichindex は0からはじまる。 */
int tabExtractCol(char* oneline, int whichindex, char* extCol);
// "//"以降を削除する。返値は'/'の位置
int slashCommentCut(char* oneline);
// 汎用文字区切り(空白文字以外のascii文字で区切られている)カラム数をかぞえる
int charCountCol(char divchar, char* oneline);
// 汎用文字区切り(空白文字以外のascii文字で区切られている)カラム取り出し。
int charExtractCol(char divchar, char* oneline, int whichindex, char* extCol);
// CommentChar文字以降を削除する。返値はCommentCharの位置。
int charCommentCut(char CommentChar, char* oneline);
// rmChar で指定される文字を消去して左詰めする。
int charRmChar(char rmChar, char* oneline);
//add by yyukawa:2008/5/12
/* csvである文字列のカラムを一気に配列にコピーする */
int csvCopyCol(char* oneline, char** copycol, int maxcolnum);
//add by yyukawa:2008/6/12
int tabCopyCol(char* oneline, char** copycol, int maxcolnum);
//add by yyukawa:2008/11/4
int spcCountCol(char* oneline);
int spcCopyCol(char* oneline, char** copycol, int maxcolnum);
}
 
#define _STR_MAX_ 100 //FinalReportの一部のSampleIDが長いが未確認
#define _SAMPLE_MAX_ 6000 //_STR_MAX_ 100にしたことで、少し減らした
#define _MAX_ONELINE_ 100000

#include "snpslist.h"
#include "illumina.h"

/*
タイピングデータ
*/
CFinalReport::CFinalReport(const char* filename, int type) {
  pFinalReportFile = NULL;
  if(filename) pFinalReportFile = fopen(filename, "r");
  num_sample = 0;
  case_or_control = type; //0:case 1:control

  sample_plate_well_list = new char*[_SAMPLE_MAX_];
  for(int i = 0; i < _SAMPLE_MAX_; i++) {
    sample_plate_well_list[i] = new char[_STR_MAX_];
  }
};
CFinalReport::~CFinalReport() {
  if(pFinalReportFile) fclose(pFinalReportFile);
  for(int i = 0; i < _SAMPLE_MAX_; i++) {
    delete sample_plate_well_list[i];
  }
  delete [] sample_plate_well_list;
};

int CFinalReport::read_sample_plate_plate_well() {
  int ret = 0;
  //sample_plate_plate_wellの行を読み出しておく
  //[Header]の情報を元に、Sample数を可変にすることも可能だが後で、、、
  if(!pFinalReportFile) {
    printf("CFinalReport::read_sample_plate_plate_well:pFinalReportFile is NULL");
    ret = -1;
    return ret;
  }

  char oneline[_MAX_ONELINE_]; //1行格納

  //FinalReportの読み込み
  fseek(pFinalReportFile, 0L, SEEK_SET); //先頭に戻す
  //9行飛ばす（ヘッダー行）
  for(int i = 0; i < 9; i++) {
    fgets(oneline, _MAX_ONELINE_, pFinalReportFile);
  }
#ifdef _TEST_OUT
  FILE* fpd = fopen("sample_plate_plate_well.txt", "w");
  //FILE* fpd = fopen("C:\\cygwin\\home\\riken\\sample_plate_plate_well.txt", "w");
#endif

  //Sample一覧を取り出す
  char** copycol = new char*[_SAMPLE_MAX_];
  for(int i = 0; i < _SAMPLE_MAX_; i++) {
    copycol[i] = new char[_STR_MAX_];
  }
  fgets(oneline, _MAX_ONELINE_, pFinalReportFile);
  ret = RmTopLastSpaceAndRet(oneline);
  num_sample = csvCopyCol(oneline, copycol, _SAMPLE_MAX_);
  num_sample -= 1;
  //num_sample = csvCountCol(oneline) - 1; //1カラム目は空
  for(int i = 0; i < num_sample; i++) {
    //char onecol[_STR_MAX_];
    //csvExtractCol(oneline, i+1, onecol); //1カラム目は空
    strcpy(sample_plate_well_list[i], copycol[i+1]);
#ifdef _TEST_OUT
    fprintf(fpd, "%s\n", sample_plate_well_list[i]);
#endif
  }
  for(int i = 0; i < _SAMPLE_MAX_; i++) {
    delete copycol[i];
  }
  delete [] copycol;

exit_function:
#ifdef _TEST_OUT
fclose(fpd);
#endif
  return ret;
};

void CFinalReport::get_samplenum(int& n) { n = num_sample; } //Sample数

int CFinalReport::get_sample_by_index(char S_Plate_Plate_Well[], int index) { //サンプル名を取り出す。S_Plate_Plate_Wellは呼び出し側で確保しておくこと
  if(index > num_sample - 1) {
    printf("Error!:CFinalReport::get_sample_by_index\n");
    return -1;
  }
  int ret = 0;
  strcpy(S_Plate_Plate_Well, sample_plate_well_list[index]);
  return ret;
};

int CFinalReport::set_snpshead() { //データ行の先頭にSEEKする
  int ret = 0;
  char oneline[_MAX_ONELINE_]; //1行格納

  //FinalReportの読み込み
  fseek(pFinalReportFile, 0L, SEEK_SET); //先頭に戻す
  //10行飛ばす（ヘッダー行＋Sample一覧）
  for(int i = 0; i < 10; i++) {
    fgets(oneline, _MAX_ONELINE_, pFinalReportFile);
  }

  return ret;
};

int CFinalReport::get_snpsdata(char oneline[], int& endflag) { //タイピングデータを一行づつ読み出す
  int ret = 0;
  endflag = 0;
  if(fgets(oneline, _MAX_ONELINE_, pFinalReportFile) == NULL) {
    endflag = 1; //終わり
  }
  return ret;
};

//FinalReportを読み込んで、SNP情報を付けて出力する
/*
PLINKのtped形式で出力する。標準出力に出してみる
*/
int CFinalReport::illumina2hapmap(
  FILE* afp,
  CSNPsList* pSNPList
  )
{
  
  int ret = 0;
  //SNPs名配列をソートする（検索用）
  pSNPList->sort_by_SNPsName();

  //HapMapヘッダー情報出力
  //rs# SNPalleles  chrom pos strand genome_build  center protLSID assayLSID panelLSID QC_code 
  fprintf(afp, "rs# SNPalleles  chrom pos strand genome_build  center protLSID assayLSID panelLSID QC_code");

  //SampleID出力
  int samplenum = 0;
  this->get_samplenum(samplenum);
  for(int i = 0; i < samplenum; i++) {
    char sampleid[_STR_MAX_];
    this->get_sample_by_index(sampleid, i);
    fprintf(afp, " %s", sampleid);
  }
  fprintf(afp, "\n");

  //タイピングデータ読み出し準備
  ret = this->set_snpshead();
  if(ret < 0) {
    return ret;
  }

  char** copycol = new char*[_SAMPLE_MAX_];
  for(int i = 0; i < _SAMPLE_MAX_; i++) {
    copycol[i] = new char[_STR_MAX_];
  }

  //
  float homoavg = 0;
  float snpnum = 0;

  char oneline[_MAX_ONELINE_]; //1行格納
  while(fgets(oneline, _MAX_ONELINE_, pFinalReportFile)) {

    ret = RmTopLastSpaceAndRet(oneline);
    if(ret < 0) {
      printf("criteria4:error RmTopLastSpaceAndRet()\n");
      goto exit_function;
    }
    //rs#,genotype,...を取り出す
    int _colnum = csvCopyCol(oneline, copycol, _SAMPLE_MAX_);

    //SNPListにあれば、SNP情報を追加して出力する
    int flag = 0;
    CSNPsData* pSL = pSNPList->search_list(copycol[0], flag);
    if(!flag || !pSL) {
      continue; //SNPListにない
    }

    //SNP情報出力
    //rs# SNPalleles  chrom pos strand genome_build  center protLSID assayLSID panelLSID QC_code 
    fprintf(afp, "%s %c/%c chr%s %d 0 0 0 0 0 0 0", pSL->pSNPsName, pSL->genotype1, pSL->genotype2, pSL->pSNPsChr, pSL->SNPsPos); //Genetic distanceは常に０

    //homo/hetero情報出力
    for(int i = 1; i < _colnum; i++) {


      //"--"
      if(copycol[i][0] == '-' && copycol[i][1] == '-') { //no call
        fprintf(afp, " %s%s", "N", "N");
      }
      //
      if(copycol[i][0] == 'A' && copycol[i][1] == 'A') { //homo
        fprintf(afp, " %c%c", pSL->genotype1, pSL->genotype1);
      }
      if(copycol[i][0] == 'A' && copycol[i][1] == 'B') { //hetero
        fprintf(afp, " %c%c", pSL->genotype1, pSL->genotype2);
      }
      if(copycol[i][0] == 'B' && copycol[i][1] == 'A') { //hetero
        fprintf(afp, " %c%c", pSL->genotype2, pSL->genotype1);
      }
      if(copycol[i][0] == 'B' && copycol[i][1] == 'B') { //homo
        fprintf(afp, " %c%c", pSL->genotype2, pSL->genotype2);
      }

    }

    //
    fprintf(afp, "\n");
  }

exit_function:
  for(int i = 0; i < _SAMPLE_MAX_; i++) {
    delete copycol[i];
  }
  delete [] copycol;
  return ret;
}

