#include <stdio.h>
#include <stdlib.h>
#include <math.h>
//#include <iostream>
#include <string>
//#include <vector>
#include <search.h>

#ifdef GSL
#include <gsl/gsl_cdf.h>
#endif

#ifdef WIN32
//Windows版GSLを入れたら生かす
//もしくはnumericalを入れておく？
double gsl_cdf_chisq_P(double x, double df) {
  return 0.0;
}
double gsl_cdf_chisq_Q(double x, double df) {
  return 0.0;
}
int isinf(double x) {
  return 0;
}
#endif

//#define _TEST_OUT

extern "C" int printflag;

#define _STR_MAX_ 100 //FinalReportの一部のSampleIDが長いが未確認
#define _SAMPLE_MAX_ 6000 //_STR_MAX_ 100にしたことで、少し減らした
#define _MAX_ONELINE_ 100000

#include "snpslist.h"
#include "illumina.h"


/*

Illumina & snplist -> HapMap
*/
int main(int argc, char** argv)
{
  int ret = 0;

  CFinalReport* aFinalReport; //タイピングデータ
  CSNPsList aSNPList; //SNPsリスト
  //CSampleList aSampleList; //サンプルリスト(未使用。念のためI/Fを残してあるだけ)

  if(argc < 3) {
    printf("usage:\n");
    printf("  argv[1] Illumina File(Input)\n");
    printf("  argv[2] SNPInfo File(Input)\n");
    printf("  argv[3] Hapmap File(Output)\n");
    ret = -1;
    return ret;
  }

  int inputmode = 0;

  aFinalReport = new CFinalReport(argv[1], 0); //タイピングデータ（ケース）

  //SNPsを読み込む
  ret = aSNPList.read_data(argv[2]);

  FILE* afp = stdout; //デフォルトの出力先を標準出力にする

  if(argv[3][0] != '-') {
    //出力ファイルオープン
    char anastr[512];
    sprintf(anastr, "%s", argv[3]);
    afp = fopen(anastr, "w");
    if(!afp) {
      printf("error fopen %s\n", anastr);
      ret = -1;
      return ret;
    }
  }

  int mode = 0;

  //Illumina
  if(inputmode == 0) {

    aFinalReport->read_sample_plate_plate_well();

    //HapMpa形式で出力
    if(mode == 0) {
      aFinalReport->illumina2hapmap(afp, &aSNPList);
    }

  }

  if(afp && afp != stdout) fclose(afp);

exit_function:
  return ret;
}
